/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class NodeMetadata {
    static final String NODE_ID_KEY = "node_id";
    static final String NODE_VERSION_KEY = "node_version";
    static final String OLDEST_INDEX_VERSION_KEY = "oldest_index_version";
    private final String nodeId;
    private final Version nodeVersion;
    private final Version previousNodeVersion;
    private final IndexVersion oldestIndexVersion;
    public static final MetadataStateFormat<NodeMetadata> FORMAT = new NodeMetadataStateFormat(false);

    private NodeMetadata(String nodeId, Version nodeVersion, Version previousNodeVersion, IndexVersion oldestIndexVersion) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.previousNodeVersion = Objects.requireNonNull(previousNodeVersion);
        this.oldestIndexVersion = Objects.requireNonNull(oldestIndexVersion);
    }

    public NodeMetadata(String nodeId, Version nodeVersion, IndexVersion oldestIndexVersion) {
        this(nodeId, nodeVersion, nodeVersion, oldestIndexVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetadata that = (NodeMetadata)o;
        return this.nodeId.equals(that.nodeId) && this.nodeVersion.equals(that.nodeVersion) && this.oldestIndexVersion.equals(that.oldestIndexVersion) && Objects.equals(this.previousNodeVersion, that.previousNodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeVersion, this.previousNodeVersion, this.oldestIndexVersion);
    }

    public String toString() {
        return "NodeMetadata{nodeId='" + this.nodeId + "', nodeVersion=" + this.nodeVersion + ", previousNodeVersion=" + this.previousNodeVersion + ", oldestIndexVersion=" + this.oldestIndexVersion + "}";
    }

    public String nodeId() {
        return this.nodeId;
    }

    public Version nodeVersion() {
        return this.nodeVersion;
    }

    public Version previousNodeVersion() {
        return this.previousNodeVersion;
    }

    public IndexVersion oldestIndexVersion() {
        return this.oldestIndexVersion;
    }

    public void verifyUpgradeToCurrentVersion() {
        assert (!this.nodeVersion.equals(Version.V_EMPTY) || Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "version is required in the node metadata from v9 onwards";
        if (this.nodeVersion.before(Version.CURRENT.minimumCompatibilityVersion())) {
            throw new IllegalStateException("cannot upgrade a node from version [" + this.nodeVersion + "] directly to version [" + Version.CURRENT + "], upgrade to version [" + Version.CURRENT.minimumCompatibilityVersion() + "] first.");
        }
        if (this.nodeVersion.after(Version.CURRENT)) {
            throw new IllegalStateException("cannot downgrade a node from version [" + this.nodeVersion + "] to version [" + Version.CURRENT + "]");
        }
    }

    public NodeMetadata upgradeToCurrentVersion() {
        this.verifyUpgradeToCurrentVersion();
        return this.nodeVersion.equals(Version.CURRENT) ? this : new NodeMetadata(this.nodeId, Version.CURRENT, this.nodeVersion, this.oldestIndexVersion);
    }

    static class NodeMetadataStateFormat
    extends MetadataStateFormat<NodeMetadata> {
        private ObjectParser<Builder, Void> objectParser;

        NodeMetadataStateFormat(boolean ignoreUnknownFields) {
            super("node-");
            this.objectParser = new ObjectParser("node_meta_data", ignoreUnknownFields, Builder::new);
            this.objectParser.declareString(Builder::setNodeId, new ParseField(NodeMetadata.NODE_ID_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setNodeVersionId, new ParseField(NodeMetadata.NODE_VERSION_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setOldestIndexVersion, new ParseField(NodeMetadata.OLDEST_INDEX_VERSION_KEY, new String[0]));
        }

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, NodeMetadata nodeMetadata) throws IOException {
            builder.field(NodeMetadata.NODE_ID_KEY, nodeMetadata.nodeId);
            builder.field(NodeMetadata.NODE_VERSION_KEY, nodeMetadata.nodeVersion.id);
            builder.field(NodeMetadata.OLDEST_INDEX_VERSION_KEY, nodeMetadata.oldestIndexVersion.id());
        }

        @Override
        public NodeMetadata fromXContent(XContentParser parser) throws IOException {
            return ((Builder)this.objectParser.apply(parser, null)).build();
        }
    }

    private static class Builder {
        String nodeId;
        Version nodeVersion;
        Version previousNodeVersion;
        IndexVersion oldestIndexVersion;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void setNodeVersionId(int nodeVersionId) {
            this.nodeVersion = Version.fromId(nodeVersionId);
        }

        public void setPreviousNodeVersionId(int previousNodeVersionId) {
            this.previousNodeVersion = Version.fromId(previousNodeVersionId);
        }

        public void setOldestIndexVersion(int oldestIndexVersion) {
            this.oldestIndexVersion = IndexVersion.fromId(oldestIndexVersion);
        }

        public NodeMetadata build() {
            Version nodeVersion;
            if (this.nodeVersion == null) {
                assert (Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "version is required in the node metadata from v9 onwards";
                nodeVersion = Version.V_EMPTY;
            } else {
                nodeVersion = this.nodeVersion;
            }
            if (this.previousNodeVersion == null) {
                this.previousNodeVersion = nodeVersion;
            }
            IndexVersion oldestIndexVersion = this.oldestIndexVersion == null ? IndexVersion.ZERO : this.oldestIndexVersion;
            return new NodeMetadata(this.nodeId, nodeVersion, this.previousNodeVersion, oldestIndexVersion);
        }
    }
}

