/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collector;

public final class Sets {
    private Sets() {
    }

    public static <T> HashSet<T> newHashSet(Iterator<T> iterator) {
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Iterable<T> iterable) {
        return iterable instanceof Collection ? new HashSet<T>((Collection)iterable) : Sets.newHashSet(iterable.iterator());
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static <E> Set<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Sets.capacity(expectedSize));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(Sets.capacity(expectedSize));
    }

    static int capacity(int expectedSize) {
        assert (expectedSize >= 0);
        return expectedSize < 2 ? expectedSize + 1 : (int)((double)expectedSize / 0.75 + 1.0);
    }

    public static <T> boolean haveEmptyIntersection(Set<T> left, Set<T> right) {
        for (T t : left) {
            if (!right.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean haveNonEmptyIntersection(Set<T> left, Set<T> right) {
        return !Sets.haveEmptyIntersection(left, right);
    }

    public static <T> Set<T> difference(Set<T> left, Set<T> right) {
        HashSet<T> set = new HashSet<T>();
        for (T k : left) {
            if (right.contains(k)) continue;
            set.add(k);
        }
        return set;
    }

    public static <T> SortedSet<T> sortedDifference(Set<T> left, Set<T> right) {
        TreeSet<T> set = new TreeSet<T>();
        for (T k : left) {
            if (right.contains(k)) continue;
            set.add(k);
        }
        return set;
    }

    public static <T> Collector<T, SortedSet<T>, SortedSet<T>> toUnmodifiableSortedSet() {
        return Collector.of(TreeSet::new, Set::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, Collections::unmodifiableSortedSet, new Collector.Characteristics[0]);
    }

    public static <T> Set<T> union(Set<T> left, Set<T> right) {
        HashSet<T> union = new HashSet<T>(left);
        union.addAll(right);
        return union;
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        Set<T> empty;
        Set<T> right;
        Set<T> left;
        if (set1.size() < set2.size()) {
            left = set1;
            right = set2;
        } else {
            left = set2;
            right = set1;
        }
        Set<T> result = empty = Set.of();
        for (T t : left) {
            if (!right.contains(t)) continue;
            if (result == empty) {
                result = new HashSet();
            }
            result.add(t);
        }
        return result == empty ? result : Collections.unmodifiableSet(result);
    }

    public static <E> Set<E> addToCopy(Set<E> set, E ... elements) {
        HashSet<E> res = new HashSet<E>(set);
        Collections.addAll(res, elements);
        return Set.copyOf(res);
    }
}

