/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class RunOnce
implements Runnable {
    private final AtomicReference<Runnable> delegateRef;

    public RunOnce(Runnable delegate) {
        this.delegateRef = new AtomicReference<Runnable>(Objects.requireNonNull(delegate));
    }

    @Override
    public void run() {
        Runnable acquired = this.delegateRef.getAndSet(null);
        if (acquired != null) {
            acquired.run();
        }
    }

    public boolean hasRun() {
        return this.delegateRef.get() == null;
    }

    public String toString() {
        return "RunOnce[" + this.delegateRef.get() + "]";
    }
}

