/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;

public class AbstractThrottledTaskRunner<T extends ActionListener<Releasable>> {
    private static final Logger logger = LogManager.getLogger(AbstractThrottledTaskRunner.class);
    private final String taskRunnerName;
    private final int maxRunningTasks;
    private final AtomicInteger runningTasks = new AtomicInteger();
    private final Queue<T> tasks;
    private final Executor executor;

    public AbstractThrottledTaskRunner(String name, int maxRunningTasks, Executor executor, Queue<T> taskQueue) {
        assert (maxRunningTasks > 0);
        this.taskRunnerName = name;
        this.maxRunningTasks = maxRunningTasks;
        this.executor = executor;
        this.tasks = taskQueue;
    }

    public void enqueueTask(T task) {
        logger.trace("[{}] enqueuing task {}", (Object)this.taskRunnerName, task);
        this.tasks.add(task);
        this.pollAndSpawn();
    }

    protected boolean isForceExecution(T task) {
        return false;
    }

    private void pollAndSpawn() {
        while (this.incrementRunningTasks()) {
            final ActionListener task = (ActionListener)this.tasks.poll();
            if (task == null) {
                logger.trace("[{}] task queue is empty", (Object)this.taskRunnerName);
                int decremented = this.runningTasks.decrementAndGet();
                assert (decremented >= 0);
                if (this.tasks.peek() != null) continue;
                break;
            }
            final boolean isForceExecution = this.isForceExecution(task);
            this.executor.execute(new AbstractRunnable(){
                private boolean rejected;
                private final Releasable releasable = Releasables.releaseOnce(() -> {
                    int decremented = AbstractThrottledTaskRunner.this.runningTasks.decrementAndGet();
                    assert (decremented >= 0);
                    if (!this.rejected) {
                        AbstractThrottledTaskRunner.this.pollAndSpawn();
                    }
                });

                @Override
                public boolean isForceExecution() {
                    return isForceExecution;
                }

                @Override
                public void onRejection(Exception e) {
                    logger.trace("[{}] task {} rejected", (Object)AbstractThrottledTaskRunner.this.taskRunnerName, (Object)task);
                    this.rejected = true;
                    try {
                        task.onFailure(e);
                    }
                    finally {
                        this.releasable.close();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    logger.error(() -> Strings.format((String)"[%s] task %s failed", (Object[])new Object[]{AbstractThrottledTaskRunner.this.taskRunnerName, task}), (Throwable)e);
                    assert (false) : e;
                    task.onFailure(e);
                }

                @Override
                protected void doRun() {
                    logger.trace("[{}] running task {}", (Object)AbstractThrottledTaskRunner.this.taskRunnerName, (Object)task);
                    task.onResponse(this.releasable);
                }

                public String toString() {
                    return task.toString();
                }
            });
        }
    }

    private boolean incrementRunningTasks() {
        int preUpdateValue = this.runningTasks.getAndAccumulate(this.maxRunningTasks, (v, maxRunning) -> v < maxRunning ? v + 1 : v);
        assert (preUpdateValue <= this.maxRunningTasks);
        return preUpdateValue < this.maxRunningTasks;
    }

    int runningTasks() {
        return this.runningTasks.get();
    }
}

