/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.JavaDateFormatter;

class EpochTime {
    private static final ValueRange POSITIVE_LONG_INTEGER_RANGE = ValueRange.of(0L, Long.MAX_VALUE);
    private static final long NEGATIVE_SIGN_PLACEHOLDER = -1L;
    private static final EpochField NEGATIVE_SIGN_FIELD = new EpochField(ChronoUnit.FOREVER, ChronoUnit.FOREVER, ValueRange.of(-1L, -1L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.getLong(ChronoField.INSTANT_SECONDS) < 0L;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return -1L;
        }
    };
    private static final EpochField UNSIGNED_SECONDS = new EpochField(ChronoUnit.SECONDS, ChronoUnit.FOREVER, POSITIVE_LONG_INTEGER_RANGE){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            long seconds = temporal.getLong(ChronoField.INSTANT_SECONDS);
            if (seconds >= 0L) {
                return seconds;
            }
            long nanos = temporal.getLong(ChronoField.NANO_OF_SECOND);
            if (nanos != 0L) {
                ++seconds;
            }
            return -seconds;
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            Long isNegative = fieldValues.remove(NEGATIVE_SIGN_FIELD);
            long seconds = fieldValues.remove(this);
            Long nanos = fieldValues.remove(NANOS_OF_SECOND);
            if (isNegative != null) {
                seconds = -seconds;
                if (nanos != null) {
                    --seconds;
                    nanos = 1000000000L - nanos;
                }
            }
            fieldValues.put(ChronoField.INSTANT_SECONDS, seconds);
            if (nanos != null) {
                fieldValues.put(ChronoField.NANO_OF_SECOND, nanos);
            }
            return null;
        }
    };
    private static final EpochField NANOS_OF_SECOND = new EpochField(ChronoUnit.NANOS, ChronoUnit.SECONDS, ValueRange.of(0L, 999999999L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.NANO_OF_SECOND);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (temporal.getLong(ChronoField.INSTANT_SECONDS) < 0L) {
                return (1000000000L - temporal.getLong(ChronoField.NANO_OF_SECOND)) % 1000000000L;
            }
            return temporal.getLong(ChronoField.NANO_OF_SECOND);
        }
    };
    private static final EpochField UNSIGNED_MILLIS = new EpochField(ChronoUnit.MILLIS, ChronoUnit.FOREVER, POSITIVE_LONG_INTEGER_RANGE){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && (temporal.isSupported(ChronoField.NANO_OF_SECOND) || temporal.isSupported(ChronoField.MILLI_OF_SECOND));
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            long millis = temporal.getLong(ChronoField.INSTANT_SECONDS) * 1000L;
            if (millis >= 0L || !temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
                return millis + temporal.getLong(ChronoField.MILLI_OF_SECOND);
            }
            long nanos = temporal.getLong(ChronoField.NANO_OF_SECOND);
            if (nanos % 1000000L != 0L) {
                ++millis;
            }
            return -(millis += nanos / 1000000L);
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            long nanos;
            long seconds;
            Long isNegative = fieldValues.remove(NEGATIVE_SIGN_FIELD);
            Long nanosOfMilli = fieldValues.remove(NANOS_OF_MILLI);
            long secondsAndMillis = fieldValues.remove(this);
            if (isNegative != null) {
                secondsAndMillis = -secondsAndMillis;
                seconds = secondsAndMillis / 1000L;
                nanos = secondsAndMillis % 1000L * 1000000L;
                if (nanosOfMilli != null) {
                    nanos -= nanosOfMilli.longValue();
                }
                if (nanos != 0L) {
                    --seconds;
                    nanos = 1000000000L + nanos;
                }
            } else {
                seconds = secondsAndMillis / 1000L;
                nanos = secondsAndMillis % 1000L * 1000000L;
                if (nanosOfMilli != null) {
                    nanos += nanosOfMilli.longValue();
                }
            }
            fieldValues.put(ChronoField.INSTANT_SECONDS, seconds);
            fieldValues.put(ChronoField.NANO_OF_SECOND, nanos);
            if (fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                fieldValues.put(ChronoField.MILLI_OF_SECOND, nanos / 1000000L);
            }
            return null;
        }
    };
    private static final EpochField NANOS_OF_MILLI = new EpochField(ChronoUnit.NANOS, ChronoUnit.MILLIS, ValueRange.of(0L, 999999L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.isSupported(ChronoField.NANO_OF_SECOND) && temporal.getLong(ChronoField.NANO_OF_SECOND) % 1000000L != 0L;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (temporal.getLong(ChronoField.INSTANT_SECONDS) < 0L) {
                return (1000000000L - temporal.getLong(ChronoField.NANO_OF_SECOND)) % 1000000L;
            }
            return temporal.getLong(ChronoField.NANO_OF_SECOND) % 1000000L;
        }
    };
    private static final DateTimeFormatter SECONDS_FORMATTER1 = new DateTimeFormatterBuilder().optionalStart().appendText((TemporalField)NEGATIVE_SIGN_FIELD, Map.of(-1L, "-")).optionalEnd().appendValue(UNSIGNED_SECONDS, 1, 19, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(NANOS_OF_SECOND, 0, 9, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter SECONDS_FORMATTER2 = new DateTimeFormatterBuilder().optionalStart().appendText((TemporalField)NEGATIVE_SIGN_FIELD, Map.of(-1L, "-")).optionalEnd().appendValue(UNSIGNED_SECONDS, 1, 19, SignStyle.NOT_NEGATIVE).appendLiteral('.').toFormatter(Locale.ROOT);
    public static final DateTimeFormatter MILLISECONDS_FORMATTER1 = new DateTimeFormatterBuilder().optionalStart().appendText((TemporalField)NEGATIVE_SIGN_FIELD, Map.of(-1L, "-")).optionalEnd().appendValue(UNSIGNED_MILLIS, 1, 19, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(NANOS_OF_MILLI, 0, 6, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter MILLISECONDS_FORMATTER2 = new DateTimeFormatterBuilder().append(MILLISECONDS_FORMATTER1).appendLiteral('.').toFormatter(Locale.ROOT);
    static final DateFormatter SECONDS_FORMATTER = new JavaDateFormatter("epoch_second", SECONDS_FORMATTER1, (builder, parser) -> builder.parseDefaulting(ChronoField.NANO_OF_SECOND, 999999999L), SECONDS_FORMATTER1, SECONDS_FORMATTER2);
    static final DateFormatter MILLIS_FORMATTER = new JavaDateFormatter("epoch_millis", MILLISECONDS_FORMATTER1, (builder, parser) -> builder.parseDefaulting(NANOS_OF_MILLI, 999999L), MILLISECONDS_FORMATTER1, MILLISECONDS_FORMATTER2);

    EpochTime() {
    }

    private static abstract class EpochField
    implements TemporalField {
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;

        private EpochField(TemporalUnit baseUnit, TemporalUnit rangeUnit, ValueRange range) {
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.range = range;
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.toString();
        }

        @Override
        public String toString() {
            return "Epoch" + this.baseUnit.toString() + (String)(this.rangeUnit != ChronoUnit.FOREVER ? "Of" + this.rangeUnit.toString() : "");
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return true;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            return (R)temporal.with(this, newValue);
        }
    }
}

