/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.logging.Level;
import org.elasticsearch.logging.Logger;

class JULBridge
extends Handler {
    private static final Map<java.util.logging.Level, Level> levelMap = Map.of(java.util.logging.Level.OFF, Level.OFF, java.util.logging.Level.SEVERE, Level.ERROR, java.util.logging.Level.WARNING, Level.WARN, java.util.logging.Level.INFO, Level.INFO, java.util.logging.Level.FINE, Level.DEBUG, java.util.logging.Level.FINEST, Level.TRACE, java.util.logging.Level.ALL, Level.ALL);
    private static final NavigableMap<Integer, Level> sortedLevelMap = levelMap.entrySet().stream().collect(Maps.toUnmodifiableSortedMap(e -> ((java.util.logging.Level)e.getKey()).intValue(), Map.Entry::getValue));

    public static void install() {
        java.util.logging.Logger rootJulLogger = LogManager.getLogManager().getLogger("");
        for (Handler existingHandler : rootJulLogger.getHandlers()) {
            rootJulLogger.removeHandler(existingHandler);
        }
        rootJulLogger.addHandler(new JULBridge());
    }

    private JULBridge() {
    }

    @Override
    public void publish(LogRecord record) {
        Logger logger = org.elasticsearch.logging.LogManager.getLogger((String)record.getLoggerName());
        Level level = this.translateJulLevel(record.getLevel());
        Throwable thrown = record.getThrown();
        String rawMessage = record.getMessage();
        String message = rawMessage == null ? "<null message>" : new MessageFormat(rawMessage, Locale.ROOT).format(record.getParameters());
        if (thrown == null) {
            logger.log(level, message);
        } else {
            logger.log(level, () -> message, thrown);
        }
    }

    private Level translateJulLevel(java.util.logging.Level julLevel) {
        Level esLevel = levelMap.get(julLevel);
        if (esLevel != null) {
            return esLevel;
        }
        Map.Entry<Integer, Level> closestEntry = sortedLevelMap.lowerEntry(julLevel.intValue());
        assert (closestEntry != null);
        return closestEntry.getValue();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

