/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.fetch.subphase.LookupField;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentParser;

public class DocumentField
implements Writeable,
Iterable<Object> {
    private final String name;
    private final List<Object> values;
    private final List<Object> ignoredValues;
    private final List<LookupField> lookupFields;

    public DocumentField(StreamInput in) throws IOException {
        this.name = in.readString();
        this.values = in.readList(StreamInput::readGenericValue);
        this.ignoredValues = in.getTransportVersion().onOrAfter(TransportVersion.V_7_16_0) ? in.readList(StreamInput::readGenericValue) : Collections.emptyList();
        this.lookupFields = in.getTransportVersion().onOrAfter(TransportVersion.V_8_2_0) ? in.readList(LookupField::new) : List.of();
    }

    public DocumentField(String name, List<Object> values) {
        this(name, values, Collections.emptyList());
    }

    public DocumentField(String name, List<Object> values, List<Object> ignoredValues) {
        this(name, values, ignoredValues, Collections.emptyList());
    }

    public DocumentField(String name, List<Object> values, List<Object> ignoredValues, List<LookupField> lookupFields) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.values = Objects.requireNonNull(values, "values must not be null");
        this.ignoredValues = Objects.requireNonNull(ignoredValues, "ignoredValues must not be null");
        this.lookupFields = Objects.requireNonNull(lookupFields, "lookupFields must not be null");
        assert (lookupFields.isEmpty() || values.isEmpty() && ignoredValues.isEmpty()) : "DocumentField can't have both lookup fields and values";
    }

    public String getName() {
        return this.name;
    }

    public <V> V getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return (V)this.values.get(0);
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public List<Object> getIgnoredValues() {
        return this.ignoredValues == Collections.emptyList() ? this.ignoredValues : Collections.unmodifiableList(this.ignoredValues);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.values, StreamOutput::writeGenericValue);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_16_0)) {
            out.writeCollection(this.ignoredValues, StreamOutput::writeGenericValue);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_2_0)) {
            out.writeList(this.lookupFields);
        } else if (!this.lookupFields.isEmpty()) {
            assert (false) : "Lookup fields require all nodes be on 8.2 or later";
            throw new IllegalStateException("Lookup fields require all nodes be on 8.2 or later");
        }
    }

    public List<LookupField> getLookupFields() {
        return this.lookupFields;
    }

    public ToXContentFragment getValidValuesWriter() {
        return (builder, params) -> {
            builder.startArray(this.name);
            for (Object value : this.values) {
                try {
                    builder.value(value);
                }
                catch (RuntimeException e) {
                    builder.value("<unserializable>");
                }
            }
            builder.endArray();
            return builder;
        };
    }

    public ToXContentFragment getIgnoredValuesWriter() {
        return (builder, params) -> {
            builder.startArray(this.name);
            for (Object value : this.ignoredValues) {
                builder.value(value);
            }
            builder.endArray();
            return builder;
        };
    }

    public static DocumentField fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String fieldName = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser);
        ArrayList<Object> values = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            values.add(XContentParserUtils.parseFieldsValue(parser));
        }
        return new DocumentField(fieldName, values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentField objects = (DocumentField)o;
        return Objects.equals(this.name, objects.name) && Objects.equals(this.values, objects.values) && Objects.equals(this.ignoredValues, objects.ignoredValues) && Objects.equals(this.lookupFields, objects.lookupFields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values, this.ignoredValues, this.lookupFields);
    }

    public String toString() {
        return "DocumentField{name='" + this.name + "', values=" + this.values + ", ignoredValues=" + this.ignoredValues + ", lookupFields=" + this.lookupFields + "}";
    }
}

