/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.elasticsearch.common.util.Maps;

public final class ImmutableOpenMap<KType, VType>
extends AbstractMap<KType, VType> {
    private final ObjectObjectHashMap<KType, VType> map;
    private Set<Map.Entry<KType, VType>> entrySet;
    private static final ImmutableOpenMap EMPTY = new ImmutableOpenMap(new ObjectObjectHashMap());

    private ImmutableOpenMap(ObjectObjectHashMap<KType, VType> map) {
        this.map = map;
    }

    @Override
    public VType get(Object key) {
        return (VType)this.map.get(key);
    }

    @Override
    public VType getOrDefault(Object key, VType defaultValue) {
        return (VType)this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (ObjectCursor cursor : this.map.values()) {
            if (!Objects.equals(cursor.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VType put(KType key, VType value) {
        throw new UnsupportedOperationException("modification is not supported");
    }

    @Override
    public VType remove(Object key) {
        throw new UnsupportedOperationException("modification is not supported");
    }

    @Override
    public void putAll(Map<? extends KType, ? extends VType> m) {
        throw new UnsupportedOperationException("modification is not supported");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("modification is not supported");
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Map.Entry<KType, VType>> entrySet() {
        Set<Map.Entry<KType, VType>> es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet<KType, VType>(this.map)) : es;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImmutableOpenMap) {
            ImmutableOpenMap immutableOpenMap = (ImmutableOpenMap)o;
            return this.map.equals(immutableOpenMap.map);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Set<KType> keySet() {
        return new KeySet(this.map.keys());
    }

    @Override
    public Collection<VType> values() {
        return new AbstractCollection<VType>(){

            @Override
            public Iterator<VType> iterator() {
                return ImmutableOpenMap.iterator(ImmutableOpenMap.this.map.values());
            }

            @Override
            public int size() {
                return ImmutableOpenMap.this.map.size();
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super KType, ? super VType> action) {
        this.map.forEach(action::accept);
    }

    static <T> Iterator<T> iterator(ObjectCollection<T> collection) {
        final Iterator iterator = collection.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return ((ObjectCursor)iterator.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    public static <KType, VType> ImmutableOpenMap<KType, VType> of() {
        return EMPTY;
    }

    public static <KType, VType> Builder<KType, VType> builder() {
        return new Builder();
    }

    public static <KType, VType> Builder<KType, VType> builder(int size) {
        return new Builder(size);
    }

    public static <KType, VType> Builder<KType, VType> builder(Map<KType, VType> map) {
        if (map instanceof ImmutableOpenMap) {
            ImmutableOpenMap iom = (ImmutableOpenMap)map;
            return new Builder(iom);
        }
        Builder<KType, VType> builder = new Builder<KType, VType>(map.size());
        builder.putAllFromMap(map);
        return builder;
    }

    private static final class EntrySet<KType, VType>
    extends AbstractSet<Map.Entry<KType, VType>> {
        private final ObjectObjectHashMap<KType, VType> map;

        private EntrySet(ObjectObjectHashMap<KType, VType> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("removal is unsupported");
        }

        @Override
        public Iterator<Map.Entry<KType, VType>> iterator() {
            return new ConversionIterator(this.map.iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (!this.map.containsKey(key)) {
                return false;
            }
            Object val = this.map.get(key);
            return Objects.equals(val, e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("removal is not supported");
        }

        @Override
        public Spliterator<Map.Entry<KType, VType>> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)this.size(), 64);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<KType, VType>> action) {
            this.map.forEach(ooCursor -> {
                Maps.ImmutableEntry<Object, Object> entry = new Maps.ImmutableEntry<Object, Object>(ooCursor.key, ooCursor.value);
                action.accept(entry);
            });
        }
    }

    private static final class KeySet<KType, VType>
    extends AbstractSet<KType> {
        private final ObjectObjectHashMap.KeysContainer keys;

        private KeySet(ObjectObjectHashMap.KeysContainer keys) {
            this.keys = keys;
        }

        @Override
        public Iterator<KType> iterator() {
            final Iterator iterator = this.keys.iterator();
            return new Iterator<KType>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public KType next() {
                    return ((ObjectCursor)iterator.next()).value;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.keys.contains(o);
        }
    }

    public static class Builder<KType, VType> {
        private ImmutableOpenMap<KType, VType> reference;
        private ObjectObjectHashMap<KType, VType> mutableMap;

        private void maybeCloneMap() {
            if (this.reference != null) {
                this.mutableMap = this.reference.map.clone();
                this.reference = null;
            }
        }

        public Builder() {
            this(EMPTY);
        }

        public Builder(int size) {
            this.mutableMap = new ObjectObjectHashMap(size);
        }

        public Builder(ImmutableOpenMap<KType, VType> immutableOpenMap) {
            this.reference = Objects.requireNonNull(immutableOpenMap);
        }

        public ImmutableOpenMap<KType, VType> build() {
            if (this.reference != null) {
                ImmutableOpenMap<KType, VType> reference = this.reference;
                this.reference = null;
                return reference;
            }
            ObjectObjectHashMap<KType, VType> mutableMap = this.mutableMap;
            this.mutableMap = null;
            return mutableMap.isEmpty() ? ImmutableOpenMap.of() : new ImmutableOpenMap<KType, VType>(mutableMap);
        }

        public Builder<KType, VType> putAllFromMap(Map<KType, VType> map) {
            this.maybeCloneMap();
            for (Map.Entry<KType, VType> entry : map.entrySet()) {
                this.mutableMap.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder<KType, VType> fPut(KType key, VType value) {
            this.maybeCloneMap();
            this.mutableMap.put(key, value);
            return this;
        }

        public VType put(KType key, VType value) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.put(key, value);
        }

        public VType get(KType key) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.get(key);
        }

        public VType getOrDefault(KType kType, VType vType) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.getOrDefault(kType, vType);
        }

        public VType remove(KType key) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.remove(key);
        }

        public boolean containsKey(KType key) {
            this.maybeCloneMap();
            return this.mutableMap.containsKey(key);
        }

        public int size() {
            this.maybeCloneMap();
            return this.mutableMap.size();
        }

        public void clear() {
            this.maybeCloneMap();
            this.mutableMap.clear();
        }

        public Set<KType> keys() {
            this.maybeCloneMap();
            return new KeySet(this.mutableMap.keys());
        }

        public int removeAll(BiPredicate<? super KType, ? super VType> predicate) {
            this.maybeCloneMap();
            return this.mutableMap.removeAll(predicate::test);
        }
    }

    private static final class ConversionIterator<KType, VType>
    implements Iterator<Map.Entry<KType, VType>> {
        private final Iterator<ObjectObjectCursor<KType, VType>> original;

        ConversionIterator(Iterator<ObjectObjectCursor<KType, VType>> original) {
            this.original = original;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public Map.Entry<KType, VType> next() {
            ObjectObjectCursor<KType, VType> obj = this.original.next();
            if (obj == null) {
                return null;
            }
            return new Maps.ImmutableEntry<Object, Object>(obj.key, obj.value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("removal is unsupported");
        }
    }
}

