/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    static final Set<Character> INVALID_CHARS = Set.of(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(' '), Character.valueOf(','));
    public static final String INVALID_FILENAME_CHARS = INVALID_CHARS.stream().map(c -> "'" + c + "'").collect(Collectors.joining(",", "[", "]"));
    public static final Pattern INVALID_FILENAME_CHARS_REGEX = Pattern.compile("[" + INVALID_CHARS.stream().map(Objects::toString).map(Pattern::quote).collect(Collectors.joining()) + "]+");

    public static void spaceify(int spaces, String from, StringBuilder to) throws IOException {
        char[] spaceChars = new char[spaces];
        Arrays.fill(spaceChars, ' ');
        try (BufferedReader reader = new BufferedReader(new StringReader(from));){
            String line;
            while ((line = reader.readLine()) != null) {
                to.append(spaceChars).append(line).append('\n');
            }
        }
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasLength(BytesReference bytesReference) {
        return bytesReference != null && bytesReference.length() > 0;
    }

    public static boolean hasLength(String str) {
        return Strings.hasLength((CharSequence)str);
    }

    public static boolean isEmpty(CharSequence str) {
        return !Strings.hasLength(str);
    }

    public static boolean hasText(CharSequence str) {
        if (!Strings.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return !Strings.isNullOrBlank(str);
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        int i;
        if (!Strings.hasLength(str)) {
            return str;
        }
        for (i = 0; i < str.length() && str.charAt(i) == leadingCharacter; ++i) {
        }
        return str.substring(i);
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString, pos, index);
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String deleteAny(String inString, String charsToDelete) {
        return inString != null ? Strings.deleteAny((CharSequence)inString, charsToDelete).toString() : null;
    }

    public static CharSequence deleteAny(CharSequence inString, String charsToDelete) {
        if (!Strings.hasLength(inString) || !Strings.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb;
    }

    public static String capitalize(String str) {
        return Strings.changeFirstCharacterCase(str, true);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        char newChar;
        if (str == null || str.length() == 0) {
            return str;
        }
        char c = newChar = capitalize ? Character.toUpperCase(str.charAt(0)) : Character.toLowerCase(str.charAt(0));
        if (newChar == str.charAt(0)) {
            return str;
        }
        return newChar + str.substring(1);
    }

    public static boolean validFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            if (!Strings.isInvalidFileNameCharacter(fileName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean validFileNameExcludingAstrix(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '*' || !Strings.isInvalidFileNameCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvalidFileNameCharacter(char c) {
        return switch (c) {
            case ' ', '\"', '*', ',', '/', '<', '>', '?', '\\', '|' -> true;
            default -> false;
        };
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return (String[])collection.toArray(String[]::new);
    }

    public static String[] concatStringArrays(String[] first, String[] second) {
        if (first == null && second == null) {
            return EMPTY_ARRAY;
        }
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        String[] concat = new String[first.length + second.length];
        System.arraycopy(first, 0, concat, 0, first.length);
        System.arraycopy(second, 0, concat, first.length, second.length);
        return concat;
    }

    public static Set<String> tokenizeByCommaToSet(String s) {
        if (s == null) {
            return Collections.emptySet();
        }
        return Strings.tokenizeToCollection(s, ",", HashSet::new);
    }

    public static String[] splitStringByCommaToArray(String s) {
        if (s == null || s.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return s.split(",");
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!Strings.hasLength(toSplit) || !Strings.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] tokenizeToStringArray(String s, String delimiters) {
        if (s == null) {
            return EMPTY_ARRAY;
        }
        return Strings.toStringArray(Strings.tokenizeToCollection(s, delimiters, ArrayList::new));
    }

    private static <T extends Collection<String>> T tokenizeToCollection(String s, String delimiters, Supplier<T> supplier) {
        if (s == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        Collection tokens = (Collection)supplier.get();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return (T)tokens;
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return Strings.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        ArrayList<String> result;
        if (str == null) {
            return EMPTY_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        if (delimiter.isEmpty()) {
            result = new ArrayList(str.length());
            if (charsToDelete == null) {
                charsToDelete = "";
            }
            for (int i = 0; i < str.length(); ++i) {
                if (charsToDelete.indexOf(str.charAt(i)) == -1) {
                    result.add(Character.toString(str.charAt(i)));
                    continue;
                }
                result.add("");
            }
        } else {
            int delPos;
            result = new ArrayList<String>();
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(Strings.deleteAny(str.subSequence(pos, delPos), charsToDelete).toString());
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(Strings.deleteAny(str.subSequence(pos, str.length()), charsToDelete).toString());
            }
        }
        return Strings.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return Strings.delimitedListToStringArray(str, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        String[] tokens = Strings.commaDelimitedListToStringArray(str);
        return new TreeSet<String>(Arrays.asList(tokens));
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        Strings.collectionToDelimitedString(coll, delim, prefix, suffix, sb);
        return sb.toString();
    }

    public static void collectionToDelimitedString(Iterable<?> coll, String delim, String prefix, String suffix, StringBuilder sb) {
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
    }

    public static void collectionToDelimitedStringWithLimit(Iterable<?> coll, String delim, String prefix, String suffix, int appendLimit, StringBuilder sb) {
        Iterator<?> it = coll.iterator();
        long lengthLimit = sb.length() + appendLimit;
        int count = 0;
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            ++count;
            if (!it.hasNext()) continue;
            sb.append(delim);
            if ((long)sb.length() <= lengthLimit) continue;
            int omitted = 0;
            while (it.hasNext()) {
                it.next();
                ++omitted;
            }
            sb.append("... (").append(count + omitted).append(" in total, ").append(omitted).append(" omitted)");
        }
    }

    public static String collectionToDelimitedString(Iterable<?> coll, String delim) {
        return Strings.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Iterable<?> coll) {
        return Strings.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        StringBuilder sb = new StringBuilder();
        Strings.arrayToDelimitedString(arr, delim, sb);
        return sb.toString();
    }

    public static void arrayToDelimitedString(Object[] arr, String delim, StringBuilder sb) {
        if (Strings.isEmpty(arr)) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return Strings.arrayToDelimitedString(arr, ",");
    }

    public static String format1Decimals(double value, String suffix) {
        String p = String.valueOf(value);
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        char fraction = p.charAt(ix);
        if (fraction == '0') {
            if (ex != -1) {
                return p.substring(0, ix - 1) + p.substring(ex) + suffix;
            }
            return p.substring(0, ix - 1) + suffix;
        }
        if (ex != -1) {
            return p.substring(0, ix) + fraction + p.substring(ex) + suffix;
        }
        return p.substring(0, ix) + fraction + suffix;
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private Strings() {
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence) {
        return Strings.toUTF8Bytes(charSequence, new BytesRefBuilder());
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence, BytesRefBuilder spare) {
        spare.copyChars(charSequence);
        return Arrays.copyOf(spare.bytes(), spare.length());
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        int realEndIndex;
        if (s == null) {
            return s;
        }
        int n = realEndIndex = s.length() > 0 ? s.length() - 1 : 0;
        if (endIndex > realEndIndex) {
            return s.substring(beginIndex);
        }
        return s.substring(beginIndex, endIndex);
    }

    public static boolean isAllOrWildcard(String[] data) {
        return CollectionUtils.isEmpty(data) || data.length == 1 && Strings.isAllOrWildcard(data[0]);
    }

    public static boolean isAllOrWildcard(String data) {
        return "_all".equals(data) || "*".equals(data);
    }

    public static String toString(ToXContent toXContent) {
        return Strings.toString(toXContent, false, false);
    }

    @Deprecated
    public static String toString(ChunkedToXContent chunkedToXContent) {
        return Strings.toString(chunkedToXContent, false, false);
    }

    public static String toString(ToXContent toXContent, ToXContent.Params params) {
        return Strings.toString(toXContent, params, false, false);
    }

    public static String toString(XContentBuilder xContentBuilder) {
        return BytesReference.bytes(xContentBuilder).utf8ToString();
    }

    public static String toString(ToXContent toXContent, boolean pretty, boolean human) {
        return Strings.toString(toXContent, ToXContent.EMPTY_PARAMS, pretty, human);
    }

    @Deprecated
    public static String toString(ChunkedToXContent chunkedToXContent, boolean pretty, boolean human) {
        return Strings.toString(ChunkedToXContent.wrapAsToXContent(chunkedToXContent), pretty, human);
    }

    private static String toString(ToXContent toXContent, ToXContent.Params params, boolean pretty, boolean human) {
        try {
            XContentBuilder builder = Strings.createBuilder(pretty, human);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            return Strings.toString(builder);
        }
        catch (IOException e) {
            try {
                XContentBuilder builder = Strings.createBuilder(pretty, human);
                builder.startObject();
                builder.field("error", "error building toString out of XContent: " + e.getMessage());
                builder.field("stack_trace", ExceptionsHelper.stackTrace(e));
                builder.endObject();
                return Strings.toString(builder);
            }
            catch (IOException e2) {
                throw new ElasticsearchException("cannot generate error message for deserialization", (Throwable)e, new Object[0]);
            }
        }
    }

    private static XContentBuilder createBuilder(boolean pretty, boolean human) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder();
        if (pretty) {
            builder.prettyPrint();
        }
        if (human) {
            builder.humanReadable(true);
        }
        return builder;
    }

    public static String cleanTruncate(String s, int length) {
        if (s == null) {
            return s;
        }
        if (length == 0) {
            return "";
        }
        if (length >= s.length()) {
            return s;
        }
        if (Character.isHighSurrogate(s.charAt(length - 1))) {
            --length;
        }
        return s.substring(0, length);
    }

    public static String requireNonEmpty(String str, String message) {
        if (Strings.isNullOrEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static String requireNonBlank(String str, String message) {
        if (Strings.isNullOrBlank(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNullOrBlank(@Nullable String s) {
        return s == null || s.isBlank();
    }

    public static String padStart(String s, int minimumLength, char c) {
        Objects.requireNonNull(s, "s");
        if (s.length() >= minimumLength) {
            return s;
        }
        return Character.toString(c).repeat(minimumLength - s.length()) + s;
    }

    public static String toLowercaseAscii(String in) {
        return in.codePoints().map(cp -> cp <= 128 ? Character.toLowerCase(cp) : cp).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String format(String format, Object ... args) {
        return org.elasticsearch.core.Strings.format((String)format, (Object[])args);
    }

    public static String stripDisallowedChars(String string) {
        return INVALID_FILENAME_CHARS_REGEX.matcher(string).replaceAll("");
    }
}

