/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.allocator.ContinuousComputation;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceComputer;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceInput;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceReconciler;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceStats;
import org.elasticsearch.cluster.routing.allocation.allocator.PendingListenersQueue;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.threadpool.ThreadPool;

public class DesiredBalanceShardsAllocator
implements ShardsAllocator {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceShardsAllocator.class);
    private final ShardsAllocator delegateAllocator;
    private final ThreadPool threadPool;
    private final DesiredBalanceReconcilerAction reconciler;
    private final DesiredBalanceComputer desiredBalanceComputer;
    private final DesiredBalanceReconciler desiredBalanceReconciler;
    private final ContinuousComputation<DesiredBalanceInput> desiredBalanceComputation;
    private final PendingListenersQueue queue;
    private final AtomicLong indexGenerator = new AtomicLong(-1L);
    private final ConcurrentLinkedQueue<List<MoveAllocationCommand>> pendingDesiredBalanceMoves = new ConcurrentLinkedQueue();
    private final MasterServiceTaskQueue<ReconcileDesiredBalanceTask> masterServiceTaskQueue;
    private volatile DesiredBalance currentDesiredBalance = DesiredBalance.INITIAL;
    private volatile boolean resetCurrentDesiredBalance = false;
    protected final CounterMetric computationsSubmitted = new CounterMetric();
    protected final CounterMetric computationsExecuted = new CounterMetric();
    protected final CounterMetric computationsConverged = new CounterMetric();
    protected final MeanMetric computedShardMovements = new MeanMetric();
    protected final CounterMetric cumulativeComputationTime = new CounterMetric();
    protected final CounterMetric cumulativeReconciliationTime = new CounterMetric();

    public DesiredBalanceShardsAllocator(ClusterSettings clusterSettings, ShardsAllocator delegateAllocator, ThreadPool threadPool, ClusterService clusterService, DesiredBalanceReconcilerAction reconciler) {
        this(delegateAllocator, threadPool, clusterService, new DesiredBalanceComputer(clusterSettings, threadPool, delegateAllocator), reconciler);
    }

    public DesiredBalanceShardsAllocator(ShardsAllocator delegateAllocator, ThreadPool threadPool, ClusterService clusterService, final DesiredBalanceComputer desiredBalanceComputer, DesiredBalanceReconcilerAction reconciler) {
        this.delegateAllocator = delegateAllocator;
        this.threadPool = threadPool;
        this.reconciler = reconciler;
        this.desiredBalanceComputer = desiredBalanceComputer;
        this.desiredBalanceReconciler = new DesiredBalanceReconciler(clusterService.getClusterSettings(), threadPool);
        this.desiredBalanceComputation = new ContinuousComputation<DesiredBalanceInput>(threadPool){

            @Override
            protected void processInput(DesiredBalanceInput desiredBalanceInput) {
                long index = desiredBalanceInput.index();
                logger.debug("Starting desired balance computation for [{}]", (Object)index);
                DesiredBalanceShardsAllocator.this.recordTime(DesiredBalanceShardsAllocator.this.cumulativeComputationTime, () -> DesiredBalanceShardsAllocator.this.setCurrentDesiredBalance(desiredBalanceComputer.compute(this.getInitialDesiredBalance(), desiredBalanceInput, DesiredBalanceShardsAllocator.this.pendingDesiredBalanceMoves, this::isFresh)));
                DesiredBalanceShardsAllocator.this.computationsExecuted.inc();
                if (this.isFresh(desiredBalanceInput)) {
                    logger.debug("Desired balance computation for [{}] is completed, scheduling reconciliation", (Object)index);
                    DesiredBalanceShardsAllocator.this.computationsConverged.inc();
                    DesiredBalanceShardsAllocator.this.submitReconcileTask(DesiredBalanceShardsAllocator.this.currentDesiredBalance);
                } else {
                    logger.debug("Desired balance computation for [{}] is discarded as newer one is submitted", (Object)index);
                }
            }

            private DesiredBalance getInitialDesiredBalance() {
                if (DesiredBalanceShardsAllocator.this.resetCurrentDesiredBalance) {
                    logger.info("Resetting current desired balance");
                    DesiredBalanceShardsAllocator.this.resetCurrentDesiredBalance = false;
                    return new DesiredBalance(DesiredBalanceShardsAllocator.this.currentDesiredBalance.lastConvergedIndex(), Map.of());
                }
                return DesiredBalanceShardsAllocator.this.currentDesiredBalance;
            }

            public String toString() {
                return "DesiredBalanceShardsAllocator#updateDesiredBalanceAndReroute";
            }
        };
        this.queue = new PendingListenersQueue();
        this.masterServiceTaskQueue = clusterService.createTaskQueue("reconcile-desired-balance", Priority.URGENT, new ReconcileDesiredBalanceExecutor());
        clusterService.addListener(event -> {
            if (!event.localNodeMaster()) {
                this.onNoLongerMaster();
            }
        });
    }

    @Override
    public ShardAllocationDecision decideShardAllocation(ShardRouting shard, RoutingAllocation allocation) {
        return this.delegateAllocator.decideShardAllocation(shard, allocation);
    }

    @Override
    public void allocate(RoutingAllocation allocation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void allocate(RoutingAllocation allocation, ActionListener<Void> listener) {
        assert (MasterService.assertMasterUpdateOrTestThread()) : Thread.currentThread().getName();
        assert (!allocation.ignoreDisable());
        this.computationsSubmitted.inc();
        long index = this.indexGenerator.incrementAndGet();
        logger.debug("Executing allocate for [{}]", (Object)index);
        this.queue.add(index, listener);
        this.desiredBalanceComputation.onNewInput(DesiredBalanceInput.create(index, allocation));
        this.reconcile(this.currentDesiredBalance, allocation);
    }

    @Override
    public RoutingExplanations execute(RoutingAllocation allocation, AllocationCommands commands, boolean explain, boolean retryFailed) {
        RoutingExplanations explanations = ShardsAllocator.super.execute(allocation, commands, explain, retryFailed);
        List<MoveAllocationCommand> moves = DesiredBalanceShardsAllocator.getMoveCommands(commands);
        if (!moves.isEmpty()) {
            this.pendingDesiredBalanceMoves.add(moves);
        }
        return explanations;
    }

    private static List<MoveAllocationCommand> getMoveCommands(AllocationCommands commands) {
        ArrayList<MoveAllocationCommand> moves = new ArrayList<MoveAllocationCommand>();
        for (AllocationCommand command : commands.commands()) {
            if (!(command instanceof MoveAllocationCommand)) continue;
            MoveAllocationCommand move = (MoveAllocationCommand)command;
            moves.add(move);
        }
        return moves;
    }

    private void setCurrentDesiredBalance(DesiredBalance newDesiredBalance) {
        if (logger.isTraceEnabled()) {
            String diff = DesiredBalance.hasChanges(this.currentDesiredBalance, newDesiredBalance) ? "Diff: " + DesiredBalance.humanReadableDiff(this.currentDesiredBalance, newDesiredBalance) : "No changes";
            logger.trace("Desired balance updated: {}. {}", (Object)newDesiredBalance, (Object)diff);
        } else {
            logger.debug("Desired balance updated for [{}]", (Object)newDesiredBalance.lastConvergedIndex());
        }
        this.computedShardMovements.inc(DesiredBalance.shardMovements(this.currentDesiredBalance, newDesiredBalance));
        this.currentDesiredBalance = newDesiredBalance;
    }

    protected void submitReconcileTask(DesiredBalance desiredBalance) {
        this.masterServiceTaskQueue.submitTask("reconcile-desired-balance", new ReconcileDesiredBalanceTask(desiredBalance), null);
    }

    protected void reconcile(DesiredBalance desiredBalance, RoutingAllocation allocation) {
        if (logger.isTraceEnabled()) {
            logger.trace("Reconciling desired balance: {}", (Object)desiredBalance);
        } else {
            logger.debug("Reconciling desired balance for [{}]", (Object)desiredBalance.lastConvergedIndex());
        }
        this.recordTime(this.cumulativeReconciliationTime, () -> this.desiredBalanceReconciler.reconcile(desiredBalance, allocation));
        if (logger.isTraceEnabled()) {
            logger.trace("Reconciled desired balance: {}", (Object)desiredBalance);
        } else {
            logger.debug("Reconciled desired balance for [{}]", (Object)desiredBalance.lastConvergedIndex());
        }
    }

    private AllocationService.RerouteStrategy createReconcileAllocationAction(final DesiredBalance desiredBalance) {
        return new AllocationService.RerouteStrategy(){

            @Override
            public void removeDelayMarkers(RoutingAllocation allocation) {
            }

            @Override
            public void execute(RoutingAllocation allocation) {
                DesiredBalanceShardsAllocator.this.reconcile(desiredBalance, allocation);
            }
        };
    }

    public DesiredBalance getDesiredBalance() {
        return this.currentDesiredBalance;
    }

    public void resetDesiredBalance() {
        this.resetCurrentDesiredBalance = true;
    }

    public DesiredBalanceStats getStats() {
        return new DesiredBalanceStats(this.currentDesiredBalance.lastConvergedIndex(), this.desiredBalanceComputation.isActive(), this.computationsSubmitted.count(), this.computationsExecuted.count(), this.computationsConverged.count(), this.desiredBalanceComputer.iterations.sum(), this.computedShardMovements.sum(), this.cumulativeComputationTime.count(), this.cumulativeReconciliationTime.count());
    }

    private void onNoLongerMaster() {
        if (this.indexGenerator.getAndSet(-1L) != -1L) {
            this.currentDesiredBalance = DesiredBalance.INITIAL;
            this.queue.completeAllAsNotMaster();
            this.pendingDesiredBalanceMoves.clear();
            this.desiredBalanceReconciler.clear();
        }
    }

    protected final void completeToLastConvergedIndex() {
        this.queue.complete(this.currentDesiredBalance.lastConvergedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTime(CounterMetric metric, Runnable action) {
        long started = this.threadPool.relativeTimeInMillis();
        try {
            action.run();
        }
        finally {
            long finished = this.threadPool.relativeTimeInMillis();
            metric.inc(finished - started);
        }
    }

    @FunctionalInterface
    public static interface DesiredBalanceReconcilerAction {
        public ClusterState apply(ClusterState var1, AllocationService.RerouteStrategy var2);
    }

    private final class ReconcileDesiredBalanceExecutor
    implements ClusterStateTaskExecutor<ReconcileDesiredBalanceTask> {
        private ReconcileDesiredBalanceExecutor() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<ReconcileDesiredBalanceTask> batchExecutionContext) {
            ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> latest = this.findLatest(batchExecutionContext.taskContexts());
            ClusterState newState = this.applyBalance(batchExecutionContext, latest);
            this.discardSupersededTasks(batchExecutionContext.taskContexts(), latest);
            return newState;
        }

        private ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> findLatest(List<? extends ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask>> taskContexts) {
            return taskContexts.stream().max(Comparator.comparing(context -> ((ReconcileDesiredBalanceTask)context.getTask()).desiredBalance.lastConvergedIndex())).get();
        }

        private ClusterState applyBalance(ClusterStateTaskExecutor.BatchExecutionContext<ReconcileDesiredBalanceTask> batchExecutionContext, ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> latest) {
            try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                ClusterState newState = DesiredBalanceShardsAllocator.this.reconciler.apply(batchExecutionContext.initialState(), DesiredBalanceShardsAllocator.this.createReconcileAllocationAction(latest.getTask().desiredBalance));
                latest.success(() -> DesiredBalanceShardsAllocator.this.queue.complete(((ReconcileDesiredBalanceTask)latest.getTask()).desiredBalance.lastConvergedIndex()));
                ClusterState clusterState = newState;
                return clusterState;
            }
        }

        private void discardSupersededTasks(List<? extends ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask>> taskContexts, ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> latest) {
            for (ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> taskContext : taskContexts) {
                if (taskContext == latest) continue;
                taskContext.success(() -> {});
            }
        }
    }

    private static final class ReconcileDesiredBalanceTask
    implements ClusterStateTaskListener {
        private final DesiredBalance desiredBalance;

        private ReconcileDesiredBalanceTask(DesiredBalance desiredBalance) {
            this.desiredBalance = desiredBalance;
        }

        @Override
        public void onFailure(Exception e) {
            assert (MasterService.isPublishFailureException(e)) : e;
        }

        public String toString() {
            return "ReconcileDesiredBalanceTask[lastConvergedIndex=" + this.desiredBalance.lastConvergedIndex() + "]";
        }
    }
}

