/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;

public class RoutingTable
implements Iterable<IndexRoutingTable>,
Diffable<RoutingTable> {
    public static final RoutingTable EMPTY_ROUTING_TABLE = new RoutingTable(0L, ImmutableOpenMap.of());
    private final long version;
    private final ImmutableOpenMap<String, IndexRoutingTable> indicesRouting;

    private RoutingTable(long version, ImmutableOpenMap<String, IndexRoutingTable> indicesRouting) {
        this.version = version;
        this.indicesRouting = indicesRouting;
    }

    public RoutingTable withIncrementedVersion() {
        return new RoutingTable(this.version + 1L, this.indicesRouting);
    }

    public static IndexShardRoutingTable shardRoutingTable(IndexRoutingTable indexRouting, int shardId) {
        IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(indexRouting.getIndex(), shardId));
        }
        return indexShard;
    }

    public long version() {
        return this.version;
    }

    @Override
    public Iterator<IndexRoutingTable> iterator() {
        return this.indicesRouting.values().iterator();
    }

    public boolean hasIndex(String index) {
        return this.indicesRouting.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexRoutingTable indexRouting = this.index(index);
        return indexRouting != null;
    }

    public IndexRoutingTable index(String index) {
        return this.indicesRouting.get(index);
    }

    public IndexRoutingTable index(Index index) {
        IndexRoutingTable indexRouting = this.index(index.getName());
        return indexRouting != null && indexRouting.getIndex().equals(index) ? indexRouting : null;
    }

    public Map<String, IndexRoutingTable> indicesRouting() {
        return this.indicesRouting;
    }

    public Map<String, IndexRoutingTable> getIndicesRouting() {
        return this.indicesRouting();
    }

    public IndexShardRoutingTable shardRoutingTable(String index, int shardId) {
        IndexRoutingTable indexRouting = this.index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return RoutingTable.shardRoutingTable(indexRouting, shardId);
    }

    public IndexShardRoutingTable shardRoutingTable(ShardId shardId) {
        IndexRoutingTable indexRouting = this.index(shardId.getIndex());
        if (indexRouting == null) {
            throw new IndexNotFoundException(shardId.getIndex());
        }
        IndexShardRoutingTable shard = indexRouting.shard(shardId.id());
        if (shard == null) {
            throw new ShardNotFoundException(shardId);
        }
        return shard;
    }

    public ShardRouting deduplicate(ShardRouting shardRouting) {
        IndexRoutingTable indexShardRoutingTable = this.indicesRouting.get(shardRouting.index().getName());
        if (indexShardRoutingTable == null) {
            return shardRouting;
        }
        IndexShardRoutingTable shardRoutingTable = indexShardRoutingTable.shard(shardRouting.id());
        if (shardRoutingTable == null) {
            return shardRouting;
        }
        for (int i = 0; i < shardRoutingTable.size(); ++i) {
            ShardRouting found = shardRoutingTable.shard(i);
            if (!shardRouting.equals(found)) continue;
            return found;
        }
        return shardRouting;
    }

    @Nullable
    public ShardRouting getByAllocationId(ShardId shardId, String allocationId) {
        IndexRoutingTable indexRoutingTable = this.index(shardId.getIndex());
        if (indexRoutingTable == null) {
            return null;
        }
        IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shardId.getId());
        return shardRoutingTable == null ? null : shardRoutingTable.getByAllocationId(allocationId);
    }

    public boolean validate(Metadata metadata) {
        for (IndexRoutingTable indexRoutingTable : this) {
            if (indexRoutingTable.validate(metadata)) continue;
            return false;
        }
        return true;
    }

    public Stream<ShardRouting> allShards() {
        return this.indicesRouting.values().stream().flatMap(IndexRoutingTable::allShards).flatMap(IndexShardRoutingTable::allShards);
    }

    public Iterable<ShardRouting> allShardsIterator() {
        return () -> this.allShards().iterator();
    }

    public List<ShardRouting> allShards(String index) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        IndexRoutingTable indexRoutingTable = this.index(index);
        if (indexRoutingTable == null) {
            throw new IndexNotFoundException(index);
        }
        for (int shardId = 0; shardId < indexRoutingTable.size(); ++shardId) {
            IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(shardId);
            for (int copy = 0; copy < indexShardRoutingTable.size(); ++copy) {
                shards.add(indexShardRoutingTable.shard(copy));
            }
        }
        return shards;
    }

    public GroupShardsIterator<ShardIterator> allActiveShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, ShardRouting::active);
    }

    public GroupShardsIterator<ShardIterator> allAssignedShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, ShardRouting::assignedToNode);
    }

    private GroupShardsIterator<ShardIterator> allSatisfyingPredicateShardsGrouped(String[] indices, boolean includeEmpty, Predicate<ShardRouting> predicate) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (int shardId = 0; shardId < indexRoutingTable.size(); ++shardId) {
                IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(shardId);
                for (int copy = 0; copy < indexShardRoutingTable.size(); ++copy) {
                    ShardRouting shardRouting = indexShardRoutingTable.shard(copy);
                    if (predicate.test(shardRouting)) {
                        set.add(shardRouting.shardsIt());
                        continue;
                    }
                    if (!includeEmpty) continue;
                    set.add(new PlainShardIterator(shardRouting.shardId(), Collections.emptyList()));
                }
            }
        }
        return GroupShardsIterator.sortAndCreate(set);
    }

    public ShardsIterator allShards(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, shardRouting -> true, false);
    }

    public ShardsIterator allActiveShards(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, ShardRouting::active, false);
    }

    public ShardsIterator allShardsIncludingRelocationTargets(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, shardRouting -> true, true);
    }

    private ShardsIterator allShardsSatisfyingPredicate(String[] indices, Predicate<ShardRouting> predicate, boolean includeRelocationTargets) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (int shardId = 0; shardId < indexRoutingTable.size(); ++shardId) {
                IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(shardId);
                for (int copy = 0; copy < indexShardRoutingTable.size(); ++copy) {
                    ShardRouting shardRouting = indexShardRoutingTable.shard(copy);
                    if (!predicate.test(shardRouting)) continue;
                    shards.add(shardRouting);
                    if (!includeRelocationTargets || !shardRouting.relocating()) continue;
                    shards.add(shardRouting.getTargetRelocatingShard());
                }
            }
        }
        return new PlainShardsIterator((List<ShardRouting>)shards);
    }

    public GroupShardsIterator<ShardIterator> activePrimaryShardsGrouped(String[] indices, boolean includeEmpty) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) {
                throw new IndexNotFoundException(index);
            }
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(i);
                ShardRouting primary = indexShardRoutingTable.primaryShard();
                if (primary.active()) {
                    set.add(primary.shardsIt());
                    continue;
                }
                if (!includeEmpty) continue;
                set.add(new PlainShardIterator(primary.shardId(), Collections.emptyList()));
            }
        }
        return GroupShardsIterator.sortAndCreate(set);
    }

    @Override
    public Diff<RoutingTable> diff(RoutingTable previousState) {
        return new RoutingTableDiff(previousState, this);
    }

    public static Diff<RoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return new RoutingTableDiff(in);
    }

    public static RoutingTable readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder();
        builder.version = in.readLong();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            IndexRoutingTable index = IndexRoutingTable.readFrom(in);
            builder.add(index);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeCollection(this.indicesRouting.values());
    }

    public static RoutingTable of(long version, RoutingNodes routingNodes) {
        HashMap<String, IndexRoutingTable.Builder> indexRoutingTableBuilders = new HashMap<String, IndexRoutingTable.Builder>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shardRoutingEntry : routingNode) {
                if (shardRoutingEntry.initializing() && shardRoutingEntry.relocatingNodeId() != null) continue;
                Builder.addShard(indexRoutingTableBuilders, shardRoutingEntry);
            }
        }
        for (ShardRouting shardRoutingEntry : routingNodes.unassigned()) {
            Builder.addShard(indexRoutingTableBuilders, shardRoutingEntry);
        }
        for (ShardRouting shardRoutingEntry : routingNodes.unassigned().ignored()) {
            Builder.addShard(indexRoutingTableBuilders, shardRoutingEntry);
        }
        ImmutableOpenMap.Builder<String, IndexRoutingTable> indicesRouting = ImmutableOpenMap.builder(indexRoutingTableBuilders.size());
        for (IndexRoutingTable.Builder indexBuilder : indexRoutingTableBuilders.values()) {
            IndexRoutingTable indexRoutingTable = indexBuilder.build();
            indicesRouting.put(indexRoutingTable.getIndex().getName(), indexRoutingTable);
        }
        return new RoutingTable(version, indicesRouting.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutingTable routingTable) {
        return new Builder(routingTable);
    }

    public static Builder builder(ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        return new Builder(shardRoutingRoleStrategy);
    }

    public static Builder builder(ShardRoutingRoleStrategy shardRoutingRoleStrategy, RoutingTable routingTable) {
        return new Builder(shardRoutingRoleStrategy, routingTable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("routing_table (version ").append(this.version).append("):\n");
        for (IndexRoutingTable entry : this.indicesRouting.values()) {
            sb.append(entry.prettyPrint()).append('\n');
        }
        return sb.toString();
    }

    private static class RoutingTableDiff
    implements Diff<RoutingTable> {
        private final long version;
        private final Diff<ImmutableOpenMap<String, IndexRoutingTable>> indicesRouting;
        private static final DiffableUtils.DiffableValueReader<String, IndexRoutingTable> DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexRoutingTable::readFrom, IndexRoutingTable::readDiffFrom);

        RoutingTableDiff(RoutingTable before, RoutingTable after) {
            this.version = after.version;
            this.indicesRouting = DiffableUtils.diff(before.indicesRouting, after.indicesRouting, DiffableUtils.getStringKeySerializer());
        }

        RoutingTableDiff(StreamInput in) throws IOException {
            this.version = in.readLong();
            this.indicesRouting = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), DIFF_VALUE_READER);
        }

        @Override
        public RoutingTable apply(RoutingTable part) {
            ImmutableOpenMap<String, IndexRoutingTable> updatedRouting = this.indicesRouting.apply(part.indicesRouting);
            if (part.version == this.version && updatedRouting == part.indicesRouting) {
                return part;
            }
            return new RoutingTable(this.version, updatedRouting);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.version);
            this.indicesRouting.writeTo(out);
        }
    }

    public static class Builder {
        private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;
        private long version;
        private ImmutableOpenMap.Builder<String, IndexRoutingTable> indicesRouting;

        public Builder() {
            this(ShardRoutingRoleStrategy.NO_SHARD_CREATION);
        }

        public Builder(RoutingTable routingTable) {
            this(ShardRoutingRoleStrategy.NO_SHARD_CREATION, routingTable);
        }

        public Builder(ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
            this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
            this.indicesRouting = ImmutableOpenMap.builder();
        }

        public Builder(ShardRoutingRoleStrategy shardRoutingRoleStrategy, RoutingTable routingTable) {
            this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
            this.version = routingTable.version;
            this.indicesRouting = ImmutableOpenMap.builder(routingTable.indicesRouting);
        }

        private static void addShard(Map<String, IndexRoutingTable.Builder> indexRoutingTableBuilders, ShardRouting shardRoutingEntry) {
            Index index = shardRoutingEntry.index();
            indexRoutingTableBuilders.computeIfAbsent(index.getName(), idxName -> IndexRoutingTable.builder(index)).addShard(shardRoutingEntry);
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            for (String index : indices) {
                int i;
                IndexRoutingTable indexRoutingTable = this.indicesRouting.get(index);
                if (indexRoutingTable == null) continue;
                int currentNumberOfReplicas = indexRoutingTable.shard(0).size() - 1;
                IndexRoutingTable.Builder builder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexRoutingTable.getIndex());
                builder.ensureShardArray(indexRoutingTable.size());
                for (i = 0; i < indexRoutingTable.size(); ++i) {
                    builder.addIndexShard(new IndexShardRoutingTable.Builder(indexRoutingTable.shard(i)));
                }
                if (currentNumberOfReplicas < numberOfReplicas) {
                    for (i = 0; i < numberOfReplicas - currentNumberOfReplicas; ++i) {
                        builder.addReplica(this.shardRoutingRoleStrategy.newReplicaRole());
                    }
                } else if (currentNumberOfReplicas > numberOfReplicas) {
                    for (i = 0; i < currentNumberOfReplicas - numberOfReplicas; ++i) {
                        builder.removeReplica();
                    }
                }
                this.indicesRouting.put(index, builder.build());
            }
            return this;
        }

        public Builder addAsNew(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsNew(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRecovery(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsRecovery(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromDangling(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsFromDangling(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromCloseToOpen(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsFromCloseToOpen(indexMetadata, this.indicesRouting.get(indexMetadata.getIndex().getName()));
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromOpenToClose(IndexMetadata indexMetadata) {
            assert (MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata));
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsFromOpenToClose(indexMetadata, this.indicesRouting.get(indexMetadata.getIndex().getName()));
            return this.add(indexRoutingBuilder);
        }

        public Builder addAsRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsRestore(indexMetadata, recoverySource, this.indicesRouting.get(indexMetadata.getIndex().getName()));
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder addAsNewRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource, Set<Integer> ignoreShards) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(this.shardRoutingRoleStrategy, indexMetadata.getIndex()).initializeAsNewRestore(indexMetadata, recoverySource, ignoreShards);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder add(IndexRoutingTable indexRoutingTable) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.put(indexRoutingTable.getIndex().getName(), indexRoutingTable);
            return this;
        }

        public Builder add(IndexRoutingTable.Builder indexRoutingTableBuilder) {
            this.add(indexRoutingTableBuilder.build());
            return this;
        }

        public Builder remove(String index) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.remove(index);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder incrementVersion() {
            ++this.version;
            return this;
        }

        public RoutingTable build() {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            RoutingTable table = new RoutingTable(this.version, this.indicesRouting.build());
            this.indicesRouting = null;
            return table;
        }
    }
}

