/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ComposableIndexTemplate
implements SimpleDiffable<ComposableIndexTemplate>,
ToXContentObject {
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField PRIORITY = new ParseField("priority", new String[0]);
    private static final ParseField COMPOSED_OF = new ParseField("composed_of", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ParseField ALLOW_AUTO_CREATE = new ParseField("allow_auto_create", new String[0]);
    private static final ParseField IGNORE_MISSING_COMPONENT_TEMPLATES = new ParseField("ignore_missing_component_templates", new String[0]);
    public static final ConstructingObjectParser<ComposableIndexTemplate, Void> PARSER = new ConstructingObjectParser("index_template", false, a -> new ComposableIndexTemplate((List)a[0], (Template)a[1], (List)a[2], (Long)a[3], (Long)a[4], (Map)a[5], (DataStreamTemplate)a[6], (Boolean)a[7], (List)a[8]));
    private final List<String> indexPatterns;
    @Nullable
    private final Template template;
    @Nullable
    private final List<String> componentTemplates;
    @Nullable
    private final Long priority;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final DataStreamTemplate dataStreamTemplate;
    @Nullable
    private final Boolean allowAutoCreate;
    @Nullable
    private final List<String> ignoreMissingComponentTemplates;

    static Diff<ComposableIndexTemplate> readITV2DiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ComposableIndexTemplate::new, in);
    }

    public static ComposableIndexTemplate parse(XContentParser parser) throws IOException {
        return (ComposableIndexTemplate)PARSER.parse(parser, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata) {
        this(indexPatterns, template, componentTemplates, priority, version, metadata, null, null, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata, @Nullable DataStreamTemplate dataStreamTemplate) {
        this(indexPatterns, template, componentTemplates, priority, version, metadata, dataStreamTemplate, null, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata, @Nullable DataStreamTemplate dataStreamTemplate, @Nullable Boolean allowAutoCreate) {
        this(indexPatterns, template, componentTemplates, priority, version, metadata, dataStreamTemplate, null, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata, @Nullable DataStreamTemplate dataStreamTemplate, @Nullable Boolean allowAutoCreate, @Nullable List<String> ignoreMissingComponentTemplates) {
        this.indexPatterns = indexPatterns;
        this.template = template;
        this.componentTemplates = componentTemplates;
        this.priority = priority;
        this.version = version;
        this.metadata = metadata;
        this.dataStreamTemplate = dataStreamTemplate;
        this.allowAutoCreate = allowAutoCreate;
        this.ignoreMissingComponentTemplates = ignoreMissingComponentTemplates;
    }

    public ComposableIndexTemplate(StreamInput in) throws IOException {
        this.indexPatterns = in.readStringList();
        this.template = in.readBoolean() ? new Template(in) : null;
        this.componentTemplates = in.readOptionalStringList();
        this.priority = in.readOptionalVLong();
        this.version = in.readOptionalVLong();
        this.metadata = in.readMap();
        this.dataStreamTemplate = in.readOptionalWriteable(DataStreamTemplate::new);
        this.allowAutoCreate = in.readOptionalBoolean();
        this.ignoreMissingComponentTemplates = in.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0) ? in.readOptionalStringList() : null;
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public Template template() {
        return this.template;
    }

    public List<String> composedOf() {
        if (this.componentTemplates == null) {
            return List.of();
        }
        return this.componentTemplates;
    }

    public List<String> getRequiredComponentTemplates() {
        if (this.componentTemplates == null) {
            return List.of();
        }
        if (this.ignoreMissingComponentTemplates == null) {
            return this.componentTemplates;
        }
        return this.componentTemplates.stream().filter(componentTemplate -> !this.ignoreMissingComponentTemplates.contains(componentTemplate)).toList();
    }

    @Nullable
    public Long priority() {
        return this.priority;
    }

    public long priorityOrZero() {
        if (this.priority == null) {
            return 0L;
        }
        return this.priority;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Nullable
    public DataStreamTemplate getDataStreamTemplate() {
        return this.dataStreamTemplate;
    }

    @Nullable
    public Boolean getAllowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nullable
    public List<String> getIgnoreMissingComponentTemplates() {
        return this.ignoreMissingComponentTemplates;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indexPatterns);
        if (this.template == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.template.writeTo(out);
        }
        out.writeOptionalStringCollection(this.componentTemplates);
        out.writeOptionalVLong(this.priority);
        out.writeOptionalVLong(this.version);
        out.writeGenericMap(this.metadata);
        out.writeOptionalWriteable(this.dataStreamTemplate);
        out.writeOptionalBoolean(this.allowAutoCreate);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0)) {
            out.writeOptionalStringCollection(this.ignoreMissingComponentTemplates);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
        builder.startObject();
        builder.stringListField(INDEX_PATTERNS.getPreferredName(), this.indexPatterns);
        if (this.template != null) {
            builder.field(TEMPLATE.getPreferredName());
            this.template.toXContent(builder, params, rolloverConfiguration);
        }
        if (this.componentTemplates != null) {
            builder.stringListField(COMPOSED_OF.getPreferredName(), this.componentTemplates);
        }
        if (this.priority != null) {
            builder.field(PRIORITY.getPreferredName(), this.priority);
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.dataStreamTemplate != null) {
            builder.field(DATA_STREAM.getPreferredName(), (ToXContent)this.dataStreamTemplate, params);
        }
        if (this.allowAutoCreate != null) {
            builder.field(ALLOW_AUTO_CREATE.getPreferredName(), this.allowAutoCreate);
        }
        if (this.ignoreMissingComponentTemplates != null) {
            builder.stringListField(IGNORE_MISSING_COMPONENT_TEMPLATES.getPreferredName(), this.ignoreMissingComponentTemplates);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indexPatterns, this.template, this.componentTemplates, this.priority, this.version, this.metadata, this.dataStreamTemplate, this.allowAutoCreate, this.ignoreMissingComponentTemplates);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComposableIndexTemplate other = (ComposableIndexTemplate)obj;
        return Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.template, other.template) && ComposableIndexTemplate.componentTemplatesEquals(this.componentTemplates, other.componentTemplates) && Objects.equals(this.priority, other.priority) && Objects.equals(this.version, other.version) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.dataStreamTemplate, other.dataStreamTemplate) && Objects.equals(this.allowAutoCreate, other.allowAutoCreate) && Objects.equals(this.ignoreMissingComponentTemplates, other.ignoreMissingComponentTemplates);
    }

    static boolean componentTemplatesEquals(List<String> c1, List<String> c2) {
        if (Objects.equals(c1, c2)) {
            return true;
        }
        if (c1 == null && c2.isEmpty()) {
            return true;
        }
        return c2 == null && c1.isEmpty();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX_PATTERNS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Template.PARSER, TEMPLATE);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), COMPOSED_OF);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PRIORITY);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataStreamTemplate.PARSER, DATA_STREAM);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_AUTO_CREATE);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), IGNORE_MISSING_COMPONENT_TEMPLATES);
    }

    public static class DataStreamTemplate
    implements Writeable,
    ToXContentObject {
        private static final ParseField HIDDEN = new ParseField("hidden", new String[0]);
        private static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
        public static final ConstructingObjectParser<DataStreamTemplate, Void> PARSER = new ConstructingObjectParser("data_stream_template", false, args -> new DataStreamTemplate(args[0] != null && (Boolean)args[0] != false, args[1] != null && (Boolean)args[1] != false));
        private final boolean hidden;
        private final boolean allowCustomRouting;
        public static CompressedXContent DATA_STREAM_MAPPING_SNIPPET;

        public DataStreamTemplate() {
            this(false, false);
        }

        public DataStreamTemplate(boolean hidden, boolean allowCustomRouting) {
            this.hidden = hidden;
            this.allowCustomRouting = allowCustomRouting;
        }

        DataStreamTemplate(StreamInput in) throws IOException {
            this.hidden = in.readBoolean();
            this.allowCustomRouting = in.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0) ? in.readBoolean() : false;
            if (in.getTransportVersion().between(TransportVersion.V_8_1_0, TransportVersion.V_8_3_0)) {
                boolean value = in.readBoolean();
                assert (!value) : "expected false, because this used to be an optional enum that never got set";
            }
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isAllowCustomRouting() {
            return this.allowCustomRouting;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.hidden);
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0)) {
                out.writeBoolean(this.allowCustomRouting);
            }
            if (out.getTransportVersion().between(TransportVersion.V_8_1_0, TransportVersion.V_8_3_0)) {
                out.writeBoolean(false);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("hidden", this.hidden);
            builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.allowCustomRouting);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStreamTemplate that = (DataStreamTemplate)o;
            return this.hidden == that.hidden && this.allowCustomRouting == that.allowCustomRouting;
        }

        public int hashCode() {
            return Objects.hash(this.hidden, this.allowCustomRouting);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_CUSTOM_ROUTING);
            try {
                DATA_STREAM_MAPPING_SNIPPET = new CompressedXContent((builder, params) -> builder.field("_doc", Map.of("_data_stream_timestamp", Map.of("enabled", true))));
            }
            catch (IOException e) {
                throw new AssertionError("no actual IO happens here", e);
            }
        }
    }

    public static class Builder {
        private List<String> indexPatterns;
        private Template template;
        private List<String> componentTemplates;
        private Long priority;
        private Long version;
        private Map<String, Object> metadata;
        private DataStreamTemplate dataStreamTemplate;
        private Boolean allowAutoCreate;
        private List<String> ignoreMissingComponentTemplates;

        public Builder indexPatterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            return this;
        }

        public Builder componentTemplates(List<String> componentTemplates) {
            this.componentTemplates = componentTemplates;
            return this;
        }

        public Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder dataStreamTemplate(DataStreamTemplate dataStreamTemplate) {
            this.dataStreamTemplate = dataStreamTemplate;
            return this;
        }

        public Builder allowAutoCreate(Boolean allowAutoCreate) {
            this.allowAutoCreate = allowAutoCreate;
            return this;
        }

        public Builder ignoreMissingComponentTemplates(List<String> ignoreMissingComponentTemplates) {
            this.ignoreMissingComponentTemplates = ignoreMissingComponentTemplates;
            return this;
        }

        public ComposableIndexTemplate build() {
            return new ComposableIndexTemplate(this.indexPatterns, this.template, this.componentTemplates, this.priority, this.version, this.metadata, this.dataStreamTemplate, this.allowAutoCreate, this.ignoreMissingComponentTemplates);
        }
    }
}

