/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ComponentTemplate
implements SimpleDiffable<ComponentTemplate>,
ToXContentObject {
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    public static final ConstructingObjectParser<ComponentTemplate, Void> PARSER = new ConstructingObjectParser("component_template", false, a -> new ComponentTemplate((Template)a[0], (Long)a[1], (Map)a[2]));
    private final Template template;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Object> metadata;

    static Diff<ComponentTemplate> readComponentTemplateDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ComponentTemplate::new, in);
    }

    public static ComponentTemplate parse(XContentParser parser) {
        return (ComponentTemplate)PARSER.apply(parser, null);
    }

    public ComponentTemplate(Template template, @Nullable Long version, @Nullable Map<String, Object> metadata) {
        this.template = template;
        this.version = version;
        this.metadata = metadata;
    }

    public ComponentTemplate(StreamInput in) throws IOException {
        this.template = new Template(in);
        this.version = in.readOptionalVLong();
        this.metadata = in.readBoolean() ? in.readMap() : null;
    }

    public Template template() {
        return this.template;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.template.writeTo(out);
        out.writeOptionalVLong(this.version);
        if (this.metadata == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeGenericMap(this.metadata);
        }
    }

    public int hashCode() {
        return Objects.hash(this.template, this.version, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ComponentTemplate other = (ComponentTemplate)obj;
        return Objects.equals(this.template, other.template) && Objects.equals(this.version, other.version) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
        builder.startObject();
        builder.field(TEMPLATE.getPreferredName());
        this.template.toXContent(builder, params, rolloverConfiguration);
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Template.PARSER, TEMPLATE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
    }
}

