/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SearchResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private static final ParseField SCROLL_ID = new ParseField("_scroll_id", new String[0]);
    private static final ParseField POINT_IN_TIME_ID = new ParseField("pit_id", new String[0]);
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField TERMINATED_EARLY = new ParseField("terminated_early", new String[0]);
    private static final ParseField NUM_REDUCE_PHASES = new ParseField("num_reduce_phases", new String[0]);
    private final SearchResponseSections internalResponse;
    private final String scrollId;
    private final String pointInTimeId;
    private final int totalShards;
    private final int successfulShards;
    private final int skippedShards;
    private final ShardSearchFailure[] shardFailures;
    private final Clusters clusters;
    private final long tookInMillis;

    public SearchResponse(StreamInput in) throws IOException {
        super(in);
        this.internalResponse = new InternalSearchResponse(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        this.clusters = new Clusters(in);
        this.scrollId = in.readOptionalString();
        this.tookInMillis = in.readVLong();
        this.skippedShards = in.readVInt();
        this.pointInTimeId = in.getTransportVersion().onOrAfter(TransportVersion.V_7_10_0) ? in.readOptionalString() : null;
    }

    public SearchResponse(SearchResponseSections internalResponse, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, Clusters clusters) {
        this(internalResponse, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, shardFailures, clusters, null);
    }

    public SearchResponse(SearchResponseSections internalResponse, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, Clusters clusters, String pointInTimeId) {
        this.internalResponse = internalResponse;
        this.scrollId = scrollId;
        this.pointInTimeId = pointInTimeId;
        this.clusters = clusters;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.skippedShards = skippedShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
        assert (skippedShards <= totalShards) : "skipped: " + skippedShards + " total: " + totalShards;
        assert (scrollId == null || pointInTimeId == null) : "SearchResponse can't have both scrollId [" + scrollId + "] and searchContextId [" + pointInTimeId + "]";
    }

    public RestStatus status() {
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures);
    }

    public SearchResponseSections getInternalResponse() {
        return this.internalResponse;
    }

    public SearchHits getHits() {
        return this.internalResponse.hits();
    }

    @Nullable
    public Aggregations getAggregations() {
        return this.internalResponse.aggregations();
    }

    public boolean hasAggregations() {
        return this.getAggregations() != null && this.getAggregations() != InternalAggregations.EMPTY;
    }

    public Suggest getSuggest() {
        return this.internalResponse.suggest();
    }

    public boolean isTimedOut() {
        return this.internalResponse.timedOut();
    }

    public Boolean isTerminatedEarly() {
        return this.internalResponse.terminatedEarly();
    }

    public int getNumReducePhases() {
        return this.internalResponse.getNumReducePhases();
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public String pointInTimeId() {
        return this.pointInTimeId;
    }

    @Nullable
    public Map<String, SearchProfileShardResult> getProfileResults() {
        return this.internalResponse.profile();
    }

    public Clusters getClusters() {
        return this.clusters;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject(), this.innerToXContentChunked(params), ChunkedToXContentHelper.endObject());
    }

    public Iterator<? extends ToXContent> innerToXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.singleChunk(this::headerToXContent), Iterators.single(this.clusters), this.internalResponse.toXContentChunked(params));
    }

    public XContentBuilder headerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.scrollId != null) {
            builder.field(SCROLL_ID.getPreferredName(), this.scrollId);
        }
        if (this.pointInTimeId != null) {
            builder.field(POINT_IN_TIME_ID.getPreferredName(), this.pointInTimeId);
        }
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.isTimedOut());
        if (this.isTerminatedEarly() != null) {
            builder.field(TERMINATED_EARLY.getPreferredName(), this.isTerminatedEarly());
        }
        if (this.getNumReducePhases() != 1) {
            builder.field(NUM_REDUCE_PHASES.getPreferredName(), this.getNumReducePhases());
        }
        RestActions.buildBroadcastShardsHeader(builder, params, this.getTotalShards(), this.getSuccessfulShards(), this.getSkippedShards(), this.getFailedShards(), this.getShardFailures());
        return builder;
    }

    public static SearchResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        parser.nextToken();
        return SearchResponse.innerFromXContent(parser);
    }

    public static SearchResponse innerFromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String currentFieldName = parser.currentName();
        SearchHits hits = null;
        Aggregations aggs = null;
        Suggest suggest = null;
        SearchProfileResults profile = null;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        int numReducePhases = 1;
        long tookInMillis = -1L;
        int successfulShards = -1;
        int totalShards = -1;
        int skippedShards = 0;
        String scrollId = null;
        String searchContextId = null;
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        Clusters clusters = Clusters.EMPTY;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token.isValue()) {
                if (SCROLL_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    scrollId = parser.text();
                } else if (POINT_IN_TIME_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    searchContextId = parser.text();
                } else if (TOOK.match(currentFieldName, parser.getDeprecationHandler())) {
                    tookInMillis = parser.longValue();
                } else if (TIMED_OUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    timedOut = parser.booleanValue();
                } else if (TERMINATED_EARLY.match(currentFieldName, parser.getDeprecationHandler())) {
                    terminatedEarly = parser.booleanValue();
                } else if (NUM_REDUCE_PHASES.match(currentFieldName, parser.getDeprecationHandler())) {
                    numReducePhases = parser.intValue();
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("hits".equals(currentFieldName)) {
                    hits = SearchHits.fromXContent(parser);
                } else if ("aggregations".equals(currentFieldName)) {
                    aggs = Aggregations.fromXContent(parser);
                } else if ("suggest".equals(currentFieldName)) {
                    suggest = Suggest.fromXContent(parser);
                } else if ("profile".equals(currentFieldName)) {
                    profile = SearchProfileResults.fromXContent(parser);
                } else if (RestActions._SHARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (RestActions.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                parser.intValue();
                                continue;
                            }
                            if (RestActions.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                successfulShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                totalShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                skippedShards = parser.intValue();
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if (RestActions.FAILURES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    failures.add(ShardSearchFailure.fromXContent(parser));
                                }
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        parser.skipChildren();
                    }
                } else if (Clusters._CLUSTERS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    clusters = Clusters.fromXContent(parser);
                } else {
                    parser.skipChildren();
                }
            }
            token = parser.nextToken();
        }
        SearchResponseSections searchResponseSections = new SearchResponseSections(hits, aggs, suggest, timedOut, terminatedEarly, profile, numReducePhases);
        return new SearchResponse(searchResponseSections, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, failures.toArray(ShardSearchFailure.EMPTY_ARRAY), clusters, searchContextId);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.internalResponse.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        this.clusters.writeTo(out);
        out.writeOptionalString(this.scrollId);
        out.writeVLong(this.tookInMillis);
        out.writeVInt(this.skippedShards);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_10_0)) {
            out.writeOptionalString(this.pointInTimeId);
        }
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static SearchResponse empty(Supplier<Long> tookInMillisSupplier, Clusters clusters) {
        SearchHits searchHits = new SearchHits(new SearchHit[0], new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Float.NaN);
        InternalSearchResponse internalSearchResponse = new InternalSearchResponse(searchHits, InternalAggregations.EMPTY, null, null, false, null, 0);
        return new SearchResponse(internalSearchResponse, null, 0, 0, 0, tookInMillisSupplier.get(), ShardSearchFailure.EMPTY_ARRAY, clusters, null);
    }

    public static class Clusters
    implements ToXContentFragment,
    Writeable {
        public static final Clusters EMPTY = new Clusters(0, 0, 0);
        static final ParseField _CLUSTERS_FIELD = new ParseField("_clusters", new String[0]);
        static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
        static final ParseField SKIPPED_FIELD = new ParseField("skipped", new String[0]);
        static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
        static final ParseField DETAILS_FIELD = new ParseField("details", new String[0]);
        private final int total;
        private final int successful;
        private final int skipped;
        private final Map<String, AtomicReference<Cluster>> clusterInfo;
        private final transient boolean ccsMinimizeRoundtrips;

        public Clusters(@Nullable OriginalIndices localIndices, Map<String, OriginalIndices> remoteClusterIndices, boolean ccsMinimizeRoundtrips) {
            this.total = remoteClusterIndices.size() + (localIndices == null ? 0 : 1);
            assert (this.total >= 1) : "No local indices or remote clusters passed in";
            this.successful = 0;
            this.skipped = 0;
            this.ccsMinimizeRoundtrips = ccsMinimizeRoundtrips;
            HashMap<String, AtomicReference<Cluster>> m = new HashMap<String, AtomicReference<Cluster>>();
            if (localIndices != null) {
                String localKey = "";
                Cluster c = new Cluster(localKey, String.join((CharSequence)",", localIndices.indices()));
                m.put(localKey, new AtomicReference<Cluster>(c));
            }
            for (Map.Entry<String, OriginalIndices> remote : remoteClusterIndices.entrySet()) {
                String clusterAlias = remote.getKey();
                Cluster c = new Cluster(clusterAlias, String.join((CharSequence)",", remote.getValue().indices()));
                m.put(clusterAlias, new AtomicReference<Cluster>(c));
            }
            this.clusterInfo = Collections.unmodifiableMap(m);
        }

        public Clusters(int total, int successful, int skipped) {
            assert (total >= 0 && successful >= 0 && skipped >= 0 && successful <= total) : "total: " + total + " successful: " + successful + " skipped: " + skipped;
            assert (skipped == total - successful) : "total: " + total + " successful: " + successful + " skipped: " + skipped;
            this.total = total;
            this.successful = successful;
            this.skipped = skipped;
            this.ccsMinimizeRoundtrips = false;
            this.clusterInfo = Collections.emptyMap();
        }

        public Clusters(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.successful = in.readVInt();
            this.skipped = in.readVInt();
            if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_500_053)) {
                List<Cluster> clusterList = in.readList(Cluster::new);
                if (clusterList.isEmpty()) {
                    this.clusterInfo = Collections.emptyMap();
                } else {
                    HashMap m = new HashMap();
                    clusterList.forEach(c -> m.put(c.getClusterAlias(), new AtomicReference<Cluster>((Cluster)c)));
                    this.clusterInfo = Collections.unmodifiableMap(m);
                }
            } else {
                this.clusterInfo = Collections.emptyMap();
            }
            this.ccsMinimizeRoundtrips = false;
            assert (this.total >= 0) : "total is negative: " + this.total;
            assert (this.total >= this.successful + this.skipped) : "successful + skipped is larger than total. total: " + this.total + " successful: " + this.successful + " skipped: " + this.skipped;
        }

        private Clusters(Map<String, AtomicReference<Cluster>> clusterInfoMap) {
            assert (clusterInfoMap.size() > 0) : "this constructor should not be called with an empty Cluster info map";
            this.total = clusterInfoMap.size();
            this.clusterInfo = clusterInfoMap;
            this.successful = 0;
            this.skipped = 0;
            this.ccsMinimizeRoundtrips = true;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.skipped);
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_500_053)) {
                if (this.clusterInfo != null) {
                    List<Cluster> clusterList = this.clusterInfo.values().stream().map(AtomicReference::get).toList();
                    out.writeList(clusterList);
                } else {
                    out.writeList(Collections.emptyList());
                }
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.total > 0) {
                builder.startObject(_CLUSTERS_FIELD.getPreferredName());
                builder.field(TOTAL_FIELD.getPreferredName(), this.total);
                builder.field(SUCCESSFUL_FIELD.getPreferredName(), this.getSuccessful());
                builder.field(SKIPPED_FIELD.getPreferredName(), this.getSkipped());
                if (this.clusterInfo.size() > 0) {
                    builder.startObject("details");
                    for (AtomicReference<Cluster> cluster : this.clusterInfo.values()) {
                        cluster.get().toXContent(builder, params);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            return builder;
        }

        public static Clusters fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            int successful = -1;
            int total = -1;
            int skipped = -1;
            HashMap<String, AtomicReference<Cluster>> clusterInfoMap = new HashMap<String, AtomicReference<Cluster>>();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        successful = parser.intValue();
                        continue;
                    }
                    if (TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        total = parser.intValue();
                        continue;
                    }
                    if (SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        skipped = parser.intValue();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (DETAILS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        String currentDetailsFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentDetailsFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                Cluster c = Cluster.fromXContent(currentDetailsFieldName, parser);
                                clusterInfoMap.put(currentDetailsFieldName, new AtomicReference<Cluster>(c));
                                continue;
                            }
                            parser.skipChildren();
                        }
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                parser.skipChildren();
            }
            if (clusterInfoMap.isEmpty()) {
                return new Clusters(total, successful, skipped);
            }
            return new Clusters(clusterInfoMap);
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccessful() {
            if (this.clusterInfo.isEmpty()) {
                return this.successful;
            }
            return this.determineCountFromClusterInfo(cluster -> cluster.getStatus() == Cluster.Status.SUCCESSFUL || cluster.getStatus() == Cluster.Status.PARTIAL);
        }

        private int determineCountFromClusterInfo(Predicate<Cluster> predicate) {
            return (int)this.clusterInfo.values().stream().filter(c -> predicate.test((Cluster)c.get())).count();
        }

        public int getSkipped() {
            if (this.clusterInfo.isEmpty()) {
                return this.skipped;
            }
            return this.determineCountFromClusterInfo(cluster -> cluster.getStatus() == Cluster.Status.SKIPPED || cluster.getStatus() == Cluster.Status.FAILED);
        }

        public boolean isCcsMinimizeRoundtrips() {
            return this.ccsMinimizeRoundtrips;
        }

        public AtomicReference<Cluster> getCluster(String clusterAlias) {
            return this.clusterInfo.get(clusterAlias);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Clusters clusters = (Clusters)o;
            return this.total == clusters.total && this.successful == clusters.successful && this.skipped == clusters.skipped;
        }

        public int hashCode() {
            return Objects.hash(this.total, this.successful, this.skipped);
        }

        public String toString() {
            return "Clusters{total=" + this.total + ", successful=" + this.getSuccessful() + ", skipped=" + this.getSkipped() + "}";
        }

        public boolean hasPartialResults() {
            for (AtomicReference<Cluster> cluster : this.clusterInfo.values()) {
                switch (cluster.get().getStatus()) {
                    case PARTIAL: 
                    case SKIPPED: 
                    case FAILED: 
                    case RUNNING: {
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean hasClusterObjects() {
            return this.clusterInfo.keySet().size() > 0;
        }
    }

    public static class Cluster
    implements ToXContentFragment,
    Writeable {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
        private final String clusterAlias;
        private final String indexExpression;
        private final Status status;
        private final Integer totalShards;
        private final Integer successfulShards;
        private final Integer skippedShards;
        private final Integer failedShards;
        private final List<ShardSearchFailure> failures;
        private final TimeValue took;
        private final boolean timedOut;

        public Cluster(String clusterAlias, String indexExpression) {
            this(clusterAlias, indexExpression, Status.RUNNING, null, null, null, null, null, null, false);
        }

        public Cluster(String clusterAlias, String indexExpression, Status status, List<ShardSearchFailure> failures) {
            this(clusterAlias, indexExpression, status, null, null, null, null, failures, null, false);
        }

        public Cluster(String clusterAlias, String indexExpression, Status status, Integer totalShards, Integer successfulShards, Integer skippedShards, Integer failedShards, List<ShardSearchFailure> failures, TimeValue took, boolean timedOut) {
            assert (clusterAlias != null) : "clusterAlias cannot be null";
            assert (indexExpression != null) : "indexExpression of Cluster cannot be null";
            assert (status != null) : "status of Cluster cannot be null";
            this.clusterAlias = clusterAlias;
            this.indexExpression = indexExpression;
            this.status = status;
            this.totalShards = totalShards;
            this.successfulShards = successfulShards;
            this.skippedShards = skippedShards;
            this.failedShards = failedShards;
            this.failures = failures == null ? Collections.emptyList() : Collections.unmodifiableList(failures);
            this.took = took;
            this.timedOut = timedOut;
        }

        public Cluster(StreamInput in) throws IOException {
            this.clusterAlias = in.readString();
            this.indexExpression = in.readString();
            this.status = Status.valueOf(in.readString().toUpperCase(Locale.ROOT));
            this.totalShards = in.readOptionalInt();
            this.successfulShards = in.readOptionalInt();
            this.skippedShards = in.readOptionalInt();
            this.failedShards = in.readOptionalInt();
            Long took = in.readOptionalLong();
            this.took = took == null ? null : new TimeValue(took.longValue());
            this.timedOut = in.readBoolean();
            this.failures = Collections.unmodifiableList(in.readList(ShardSearchFailure::readShardSearchFailure));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterAlias);
            out.writeString(this.indexExpression);
            out.writeString(this.status.toString());
            out.writeOptionalInt(this.totalShards);
            out.writeOptionalInt(this.successfulShards);
            out.writeOptionalInt(this.skippedShards);
            out.writeOptionalInt(this.failedShards);
            out.writeOptionalLong(this.took == null ? null : Long.valueOf(this.took.millis()));
            out.writeBoolean(this.timedOut);
            out.writeList(this.failures);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String name = this.clusterAlias;
            if (this.clusterAlias.equals("")) {
                name = "(local)";
            }
            builder.startObject(name);
            builder.field(STATUS_FIELD.getPreferredName(), this.getStatus().toString());
            builder.field(INDICES_FIELD.getPreferredName(), this.indexExpression);
            if (this.took != null) {
                builder.field(TOOK.getPreferredName(), this.took.millis());
            }
            builder.field(TIMED_OUT.getPreferredName(), this.timedOut);
            if (this.totalShards != null) {
                builder.startObject(RestActions._SHARDS_FIELD.getPreferredName());
                builder.field(RestActions.TOTAL_FIELD.getPreferredName(), this.totalShards);
                if (this.successfulShards != null) {
                    builder.field(RestActions.SUCCESSFUL_FIELD.getPreferredName(), this.successfulShards);
                }
                if (this.skippedShards != null) {
                    builder.field(RestActions.SKIPPED_FIELD.getPreferredName(), this.skippedShards);
                }
                if (this.failedShards != null) {
                    builder.field(RestActions.FAILED_FIELD.getPreferredName(), this.failedShards);
                }
                builder.endObject();
            }
            if (this.failures != null && this.failures.size() > 0) {
                builder.startArray(RestActions.FAILURES_FIELD.getPreferredName());
                for (ShardSearchFailure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public static Cluster fromXContent(String clusterAlias, XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            String clusterName = clusterAlias;
            if (clusterAlias.equals("(local)")) {
                clusterName = "";
            }
            String indexExpression = null;
            String status = "running";
            boolean timedOut = false;
            long took = -1L;
            int totalShards = -1;
            int successfulShards = -1;
            int skippedShards = -1;
            int failedShards = -1;
            ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        indexExpression = parser.text();
                        continue;
                    }
                    if (STATUS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        status = parser.text();
                        continue;
                    }
                    if (TIMED_OUT.match(currentFieldName, parser.getDeprecationHandler())) {
                        timedOut = parser.booleanValue();
                        continue;
                    }
                    if (TOOK.match(currentFieldName, parser.getDeprecationHandler())) {
                        took = parser.longValue();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (RestActions._SHARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (RestActions.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                failedShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                successfulShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                totalShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                skippedShards = parser.intValue();
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (RestActions.FAILURES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            failures.add(ShardSearchFailure.fromXContent(parser));
                        }
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                parser.skipChildren();
            }
            Integer totalShardsFinal = totalShards == -1 ? null : Integer.valueOf(totalShards);
            Integer successfulShardsFinal = successfulShards == -1 ? null : Integer.valueOf(successfulShards);
            Integer skippedShardsFinal = skippedShards == -1 ? null : Integer.valueOf(skippedShards);
            Integer failedShardsFinal = failedShards == -1 ? null : Integer.valueOf(failedShards);
            TimeValue tookTimeValue = took == -1L ? null : new TimeValue(took);
            return new Cluster(clusterName, indexExpression, Status.valueOf(status.toUpperCase(Locale.ROOT)), totalShardsFinal, successfulShardsFinal, skippedShardsFinal, failedShardsFinal, failures, tookTimeValue, timedOut);
        }

        public String getClusterAlias() {
            return this.clusterAlias;
        }

        public String getIndexExpression() {
            return this.indexExpression;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        public List<ShardSearchFailure> getFailures() {
            return this.failures;
        }

        public TimeValue getTook() {
            return this.took;
        }

        public Integer getTotalShards() {
            return this.totalShards;
        }

        public Integer getSuccessfulShards() {
            return this.successfulShards;
        }

        public Integer getSkippedShards() {
            return this.skippedShards;
        }

        public Integer getFailedShards() {
            return this.failedShards;
        }

        public String toString() {
            return "Cluster{clusterAlias='" + this.clusterAlias + "', status=" + this.status + ", failures=" + this.failures + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", skippedShards=" + this.skippedShards + ", failedShards=" + this.failedShards + ", searchLatencyMillis=" + this.took + "}";
        }

        public static enum Status {
            RUNNING,
            SUCCESSFUL,
            PARTIAL,
            SKIPPED,
            FAILED;


            public String toString() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }
    }
}

