/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetFromTranslogAction
extends HandledTransportAction<Request, Response> {
    public static final String NAME = "internal:data/read/get_from_translog";
    public static final Logger logger = LogManager.getLogger(TransportGetFromTranslogAction.class);
    private final IndicesService indicesService;

    @Inject
    public TransportGetFromTranslogAction(TransportService transportService, IndicesService indicesService, ActionFilters actionFilters) {
        super(NAME, transportService, actionFilters, Request::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        GetRequest getRequest = request.getRequest();
        ShardId shardId = request.shardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        assert (indexShard.routingEntry().isPromotableToPrimary()) : "not an indexing shard" + indexShard.routingEntry();
        assert (getRequest.realtime());
        ActionListener.completeWith(listener, () -> {
            GetResult result = indexShard.getService().getFromTranslog(getRequest.id(), getRequest.storedFields(), getRequest.realtime(), getRequest.version(), getRequest.versionType(), getRequest.fetchSourceContext(), getRequest.isForceSyntheticSource());
            long segmentGeneration = -1L;
            if (result == null) {
                Engine engine = indexShard.getEngineOrNull();
                if (engine == null) {
                    throw new AlreadyClosedException("engine closed");
                }
                segmentGeneration = ((InternalEngine)engine).getLastUnsafeSegmentGenerationForGets();
            }
            return new Response(result, segmentGeneration);
        });
    }

    public static class Request
    extends ActionRequest {
        private final GetRequest getRequest;
        private final ShardId shardId;

        public Request(GetRequest getRequest, ShardId shardId) {
            this.getRequest = Objects.requireNonNull(getRequest);
            this.shardId = Objects.requireNonNull(shardId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.getRequest = new GetRequest(in);
            this.shardId = new ShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.getRequest.writeTo(out);
            this.shardId.writeTo(out);
        }

        public GetRequest getRequest() {
            return this.getRequest;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public String toString() {
            return "GetFromTranslogRequest{getRequest=" + this.getRequest + ", shardId=" + this.shardId + "}";
        }
    }

    public static class Response
    extends ActionResponse {
        @Nullable
        private final GetResult getResult;
        private final long segmentGeneration;

        public Response(GetResult getResult, long segmentGeneration) {
            this.getResult = getResult;
            this.segmentGeneration = segmentGeneration;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.segmentGeneration = in.readZLong();
            this.getResult = in.readOptionalWriteable(GetResult::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.segmentGeneration);
            out.writeOptionalWriteable(this.getResult);
        }

        @Nullable
        public GetResult getResult() {
            return this.getResult;
        }

        public long segmentGeneration() {
            return this.segmentGeneration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            return this.segmentGeneration == other.segmentGeneration && Objects.equals(this.getResult, other.getResult);
        }

        public int hashCode() {
            return Objects.hash(this.segmentGeneration, this.getResult);
        }

        public String toString() {
            return "Response{getResult=" + this.getResult + ", segmentGeneration=" + this.segmentGeneration + "}";
        }
    }
}

