/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamAction
extends ActionType<Response> {
    public static final GetDataStreamAction INSTANCE = new GetDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamInfo> dataStreams;
        @Nullable
        private final RolloverConfiguration rolloverConfiguration;

        public Response(List<DataStreamInfo> dataStreams) {
            this(dataStreams, null);
        }

        public Response(List<DataStreamInfo> dataStreams, @Nullable RolloverConfiguration rolloverConfiguration) {
            this.dataStreams = dataStreams;
            this.rolloverConfiguration = rolloverConfiguration;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readList(DataStreamInfo::new), in.getTransportVersion().onOrAfter(TransportVersion.V_8_500_010) ? in.readOptionalWriteable(RolloverConfiguration::new) : null);
        }

        public List<DataStreamInfo> getDataStreams() {
            return this.dataStreams;
        }

        @Nullable
        public RolloverConfiguration getRolloverConfiguration() {
            return this.rolloverConfiguration;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.dataStreams);
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_500_010)) {
                out.writeOptionalWriteable(this.rolloverConfiguration);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(DATA_STREAMS_FIELD.getPreferredName());
            for (DataStreamInfo dataStream : this.dataStreams) {
                dataStream.toXContent(builder, params, this.rolloverConfiguration);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreams.equals(response.dataStreams) && Objects.equals(this.rolloverConfiguration, response.rolloverConfiguration);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams, this.rolloverConfiguration);
        }

        public static class DataStreamInfo
        implements SimpleDiffable<DataStreamInfo>,
        ToXContentObject {
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
            public static final ParseField ILM_POLICY_FIELD = new ParseField("ilm_policy", new String[0]);
            public static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);
            public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
            public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
            public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
            public static final ParseField REPLICATED = new ParseField("replicated", new String[0]);
            public static final ParseField TIME_SERIES = new ParseField("time_series", new String[0]);
            public static final ParseField TEMPORAL_RANGES = new ParseField("temporal_ranges", new String[0]);
            public static final ParseField TEMPORAL_RANGE_START = new ParseField("start", new String[0]);
            public static final ParseField TEMPORAL_RANGE_END = new ParseField("end", new String[0]);
            private final DataStream dataStream;
            private final ClusterHealthStatus dataStreamStatus;
            @Nullable
            private final String indexTemplate;
            @Nullable
            private final String ilmPolicyName;
            @Nullable
            private final TimeSeries timeSeries;

            public DataStreamInfo(DataStream dataStream, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate, @Nullable String ilmPolicyName, @Nullable TimeSeries timeSeries) {
                this.dataStream = dataStream;
                this.dataStreamStatus = dataStreamStatus;
                this.indexTemplate = indexTemplate;
                this.ilmPolicyName = ilmPolicyName;
                this.timeSeries = timeSeries;
            }

            DataStreamInfo(StreamInput in) throws IOException {
                this(new DataStream(in), ClusterHealthStatus.readFrom(in), in.readOptionalString(), in.readOptionalString(), in.getTransportVersion().onOrAfter(TransportVersion.V_8_3_0) ? in.readOptionalWriteable(TimeSeries::new) : null);
            }

            public DataStream getDataStream() {
                return this.dataStream;
            }

            public ClusterHealthStatus getDataStreamStatus() {
                return this.dataStreamStatus;
            }

            @Nullable
            public String getIndexTemplate() {
                return this.indexTemplate;
            }

            @Nullable
            public String getIlmPolicy() {
                return this.ilmPolicyName;
            }

            @Nullable
            public TimeSeries getTimeSeries() {
                return this.timeSeries;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.dataStream.writeTo(out);
                this.dataStreamStatus.writeTo(out);
                out.writeOptionalString(this.indexTemplate);
                out.writeOptionalString(this.ilmPolicyName);
                if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_3_0)) {
                    out.writeOptionalWriteable(this.timeSeries);
                }
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return this.toXContent(builder, params, null);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
                builder.startObject();
                builder.field(DataStream.NAME_FIELD.getPreferredName(), this.dataStream.getName());
                builder.field(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName()).startObject().field(DataStream.NAME_FIELD.getPreferredName(), "@timestamp").endObject();
                builder.xContentList(DataStream.INDICES_FIELD.getPreferredName(), this.dataStream.getIndices());
                builder.field(DataStream.GENERATION_FIELD.getPreferredName(), this.dataStream.getGeneration());
                if (this.dataStream.getMetadata() != null) {
                    builder.field(DataStream.METADATA_FIELD.getPreferredName(), this.dataStream.getMetadata());
                }
                builder.field(STATUS_FIELD.getPreferredName(), (Enum)this.dataStreamStatus);
                if (this.indexTemplate != null) {
                    builder.field(INDEX_TEMPLATE_FIELD.getPreferredName(), this.indexTemplate);
                }
                if (this.dataStream.getLifecycle() != null) {
                    builder.field(LIFECYCLE_FIELD.getPreferredName());
                    this.dataStream.getLifecycle().toXContent(builder, params, rolloverConfiguration);
                }
                if (this.ilmPolicyName != null) {
                    builder.field(ILM_POLICY_FIELD.getPreferredName(), this.ilmPolicyName);
                }
                builder.field(HIDDEN_FIELD.getPreferredName(), this.dataStream.isHidden());
                builder.field(SYSTEM_FIELD.getPreferredName(), this.dataStream.isSystem());
                builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.dataStream.isAllowCustomRouting());
                builder.field(REPLICATED.getPreferredName(), this.dataStream.isReplicated());
                if (this.timeSeries != null) {
                    builder.startObject(TIME_SERIES.getPreferredName());
                    builder.startArray(TEMPORAL_RANGES.getPreferredName());
                    for (Tuple<Instant, Instant> range : this.timeSeries.temporalRanges()) {
                        builder.startObject();
                        Instant start = (Instant)range.v1();
                        builder.field(TEMPORAL_RANGE_START.getPreferredName(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(start));
                        Instant end = (Instant)range.v2();
                        builder.field(TEMPORAL_RANGE_END.getPreferredName(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(end));
                        builder.endObject();
                    }
                    builder.endArray();
                    builder.endObject();
                }
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DataStreamInfo that = (DataStreamInfo)o;
                return this.dataStream.equals(that.dataStream) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate) && Objects.equals(this.ilmPolicyName, that.ilmPolicyName) && Objects.equals(this.timeSeries, that.timeSeries);
            }

            public int hashCode() {
                return Objects.hash(this.dataStream, this.dataStreamStatus, this.indexTemplate, this.ilmPolicyName, this.timeSeries);
            }
        }

        public record TimeSeries(List<Tuple<Instant, Instant>> temporalRanges) implements Writeable
        {
            TimeSeries(StreamInput in) throws IOException {
                this(in.readList(in1 -> new Tuple((Object)in1.readInstant(), (Object)in1.readInstant())));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeCollection(this.temporalRanges, (out1, value) -> {
                    out1.writeInstant((Instant)value.v1());
                    out1.writeInstant((Instant)value.v2());
                });
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TimeSeries that = (TimeSeries)o;
                return this.temporalRanges.equals(that.temporalRanges);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.temporalRanges);
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, true, true, true, false, false, true, false);
        private boolean includeDefaults = false;

        public Request(String[] names) {
            this.names = names;
        }

        public Request(String[] names, boolean includeDefaults) {
            this.names = names;
            this.includeDefaults = includeDefaults;
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.includeDefaults = in.getTransportVersion().onOrAfter(TransportVersion.V_8_500_010) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_500_010)) {
                out.writeBoolean(this.includeDefaults);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions) && this.includeDefaults == request.includeDefaults;
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.includeDefaults);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }
    }
}

