/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentEOFException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class BulkRequestParser {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(BulkRequestParser.class);
    private static final Set<String> SUPPORTED_ACTIONS = Set.of("create", "index", "update", "delete");
    private static final String STRICT_ACTION_PARSING_WARNING_KEY = "bulk_request_strict_action_parsing";
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField OP_TYPE = new ParseField("op_type", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField VERSION_TYPE = new ParseField("version_type", new String[0]);
    private static final ParseField RETRY_ON_CONFLICT = new ParseField("retry_on_conflict", new String[0]);
    private static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    private static final ParseField SOURCE = new ParseField("_source", new String[0]);
    private static final ParseField IF_SEQ_NO = new ParseField("if_seq_no", new String[0]);
    private static final ParseField IF_PRIMARY_TERM = new ParseField("if_primary_term", new String[0]);
    private static final ParseField REQUIRE_ALIAS = new ParseField("require_alias", new String[0]);
    private static final ParseField DYNAMIC_TEMPLATES = new ParseField("dynamic_templates", new String[0]);
    private final boolean deprecateOrErrorOnType;
    private final XContentParserConfiguration config;

    public BulkRequestParser(boolean deprecateOrErrorOnType, RestApiVersion restApiVersion) {
        this.deprecateOrErrorOnType = deprecateOrErrorOnType;
        this.config = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE).withRestApiVersion(restApiVersion);
    }

    private static int findNextMarker(byte marker, int from, BytesReference data) {
        int res = data.indexOf(marker, from);
        if (res != -1) {
            assert (res >= 0);
            return res;
        }
        if (from != data.length()) {
            throw new IllegalArgumentException("The bulk request must be terminated by a newline [\\n]");
        }
        return res;
    }

    private static BytesReference sliceTrimmingCarriageReturn(BytesReference bytesReference, int from, int nextMarker, XContentType xContentType) {
        int length = XContentType.JSON == xContentType && bytesReference.get(nextMarker - 1) == 13 ? nextMarker - from - 1 : nextMarker - from;
        return bytesReference.slice(from, length);
    }

    public void parse(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, boolean allowExplicitIndex, XContentType xContentType, BiConsumer<IndexRequest, String> indexRequestConsumer, Consumer<UpdateRequest> updateRequestConsumer, Consumer<DeleteRequest> deleteRequestConsumer) throws IOException {
        int nextMarker;
        XContent xContent = xContentType.xContent();
        int line = 0;
        int from = 0;
        byte marker = xContent.streamSeparator();
        HashMap stringDeduplicator = new HashMap();
        boolean typesDeprecationLogged = false;
        while ((nextMarker = BulkRequestParser.findNextMarker(marker, from, data)) != -1) {
            ++line;
            XContentParser parser = this.createParser(xContent, data, from, nextMarker);
            try {
                from = nextMarker + 1;
                XContentParser.Token token = parser.nextToken();
                if (token == null) continue;
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + XContentParser.Token.START_OBJECT + " but found [" + token + "]");
                }
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + XContentParser.Token.FIELD_NAME + " but found [" + token + "]");
                }
                String action = parser.currentName();
                if (!SUPPORTED_ACTIONS.contains(action)) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected field [create], [delete], [index] or [update] but found [" + action + "]");
                }
                String index = defaultIndex;
                String type = null;
                String id = null;
                String routing = defaultRouting;
                FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
                String opType = null;
                long version = -3L;
                VersionType versionType = VersionType.INTERNAL;
                long ifSeqNo = -2L;
                long ifPrimaryTerm = 0L;
                int retryOnConflict = 0;
                String pipeline = defaultPipeline;
                boolean requireAlias = defaultRequireAlias != null && defaultRequireAlias != false;
                Map dynamicTemplates = Map.of();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                                if (!allowExplicitIndex) {
                                    throw new IllegalArgumentException("explicit index in bulk is not allowed");
                                }
                                index = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                if (parser.getRestApiVersion().matches(RestApiVersion.equalTo((RestApiVersion)RestApiVersion.V_7))) {
                                    if (this.deprecateOrErrorOnType && !typesDeprecationLogged) {
                                        deprecationLogger.compatibleCritical("bulk_with_types", "[types removal] Specifying types in bulk requests is deprecated.", new Object[0]);
                                        typesDeprecationLogged = true;
                                    }
                                } else if (parser.getRestApiVersion().matches(RestApiVersion.onOrAfter((RestApiVersion)RestApiVersion.V_8)) && this.deprecateOrErrorOnType) {
                                    throw new IllegalArgumentException("Action/metadata line [" + line + "] contains an unknown parameter [" + currentFieldName + "]");
                                }
                                type = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                                id = parser.text();
                                continue;
                            }
                            if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                                routing = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (OP_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                opType = parser.text();
                                continue;
                            }
                            if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                                version = parser.longValue();
                                continue;
                            }
                            if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                versionType = VersionType.fromString(parser.text());
                                continue;
                            }
                            if (IF_SEQ_NO.match(currentFieldName, parser.getDeprecationHandler())) {
                                ifSeqNo = parser.longValue();
                                continue;
                            }
                            if (IF_PRIMARY_TERM.match(currentFieldName, parser.getDeprecationHandler())) {
                                ifPrimaryTerm = parser.longValue();
                                continue;
                            }
                            if (RETRY_ON_CONFLICT.match(currentFieldName, parser.getDeprecationHandler())) {
                                retryOnConflict = parser.intValue();
                                continue;
                            }
                            if (PIPELINE.match(currentFieldName, parser.getDeprecationHandler())) {
                                pipeline = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                                continue;
                            }
                            if (SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                                fetchSourceContext = FetchSourceContext.fromXContent(parser);
                                continue;
                            }
                            if (REQUIRE_ALIAS.match(currentFieldName, parser.getDeprecationHandler())) {
                                requireAlias = parser.booleanValue();
                                continue;
                            }
                            throw new IllegalArgumentException("Action/metadata line [" + line + "] contains an unknown parameter [" + currentFieldName + "]");
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + token + "]");
                        }
                        if (token == XContentParser.Token.START_OBJECT && DYNAMIC_TEMPLATES.match(currentFieldName, parser.getDeprecationHandler())) {
                            dynamicTemplates = parser.mapStrings();
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT && SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                            fetchSourceContext = FetchSourceContext.fromXContent(parser);
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NULL) continue;
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + token + "]");
                    }
                } else if (token != XContentParser.Token.END_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + XContentParser.Token.START_OBJECT + " or " + XContentParser.Token.END_OBJECT + " but found [" + token + "]");
                }
                BulkRequestParser.checkBulkActionIsProperlyClosed(parser);
                if ("delete".equals(action)) {
                    if (!dynamicTemplates.isEmpty()) {
                        throw new IllegalArgumentException("Delete request in line [" + line + "] does not accept " + DYNAMIC_TEMPLATES.getPreferredName());
                    }
                    deleteRequestConsumer.accept(new DeleteRequest(index).id(id).routing(routing).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm));
                    continue;
                }
                nextMarker = BulkRequestParser.findNextMarker(marker, from, data);
                if (nextMarker == -1) break;
                ++line;
                if ("index".equals(action)) {
                    if (opType == null) {
                        indexRequestConsumer.accept(new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType).setDynamicTemplates(dynamicTemplates).setRequireAlias(requireAlias), type);
                    } else {
                        indexRequestConsumer.accept(new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create("create".equals(opType)).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType).setDynamicTemplates(dynamicTemplates).setRequireAlias(requireAlias), type);
                    }
                } else if ("create".equals(action)) {
                    indexRequestConsumer.accept(new IndexRequest(index).id(id).routing(routing).version(version).versionType(versionType).create(true).setPipeline(pipeline).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).source(BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType).setDynamicTemplates(dynamicTemplates).setRequireAlias(requireAlias), type);
                } else if ("update".equals(action)) {
                    IndexRequest upsertRequest;
                    if (version != -3L || versionType != VersionType.INTERNAL) {
                        throw new IllegalArgumentException("Update requests do not support versioning. Please use `if_seq_no` and `if_primary_term` instead");
                    }
                    if (!dynamicTemplates.isEmpty()) {
                        throw new IllegalArgumentException("Update request in line [" + line + "] does not accept " + DYNAMIC_TEMPLATES.getPreferredName());
                    }
                    UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).routing(routing).retryOnConflict(retryOnConflict).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm).setRequireAlias(requireAlias).routing(routing);
                    try (XContentParser sliceParser = this.createParser(xContent, BulkRequestParser.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType));){
                        updateRequest.fromXContent(sliceParser);
                    }
                    if (fetchSourceContext != null) {
                        updateRequest.fetchSource(fetchSourceContext);
                    }
                    if ((upsertRequest = updateRequest.upsertRequest()) != null) {
                        upsertRequest.setPipeline(pipeline);
                    }
                    updateRequestConsumer.accept(updateRequest);
                }
                from = nextMarker + 1;
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
    }

    private static void checkBulkActionIsProperlyClosed(XContentParser parser) throws IOException {
        XContentParser.Token token;
        try {
            token = parser.nextToken();
        }
        catch (XContentEOFException ignore) {
            assert (Version.CURRENT.major == Version.V_7_17_0.major + 1);
            deprecationLogger.compatibleCritical(STRICT_ACTION_PARSING_WARNING_KEY, "A bulk action wasn't closed properly with the closing brace. Malformed objects are currently accepted but will be rejected in a future version.", new Object[0]);
            return;
        }
        if (token != XContentParser.Token.END_OBJECT) {
            assert (Version.CURRENT.major == Version.V_7_17_0.major + 1);
            deprecationLogger.compatibleCritical(STRICT_ACTION_PARSING_WARNING_KEY, "A bulk action object contained multiple keys. Additional keys are currently ignored but will be rejected in a future version.", new Object[0]);
            return;
        }
        if (parser.nextToken() != null) {
            assert (Version.CURRENT.major == Version.V_7_17_0.major + 1);
            deprecationLogger.compatibleCritical(STRICT_ACTION_PARSING_WARNING_KEY, "A bulk action contained trailing data after the closing brace. This is currently ignored but will be rejected in a future version.", new Object[0]);
        }
    }

    private XContentParser createParser(XContent xContent, BytesReference data) throws IOException {
        if (data.hasArray()) {
            return this.parseBytesArray(xContent, data, 0, data.length());
        }
        return xContent.createParser(this.config, (InputStream)data.streamInput());
    }

    private XContentParser createParser(XContent xContent, BytesReference data, int from, int nextMarker) throws IOException {
        if (data.hasArray()) {
            return this.parseBytesArray(xContent, data, from, nextMarker);
        }
        int length = nextMarker - from;
        BytesReference slice = data.slice(from, length);
        if (slice.hasArray()) {
            return this.parseBytesArray(xContent, slice, 0, length);
        }
        return xContent.createParser(this.config, (InputStream)slice.streamInput());
    }

    private XContentParser parseBytesArray(XContent xContent, BytesReference array, int from, int nextMarker) throws IOException {
        assert (array.hasArray());
        int offset = array.arrayOffset();
        return xContent.createParser(this.config, array.array(), offset + from, nextMarker - from);
    }
}

