/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportSimulateIndexTemplateAction
extends TransportMasterNodeReadAction<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private final SystemIndices systemIndices;
    private final Set<IndexSettingProvider> indexSettingProviders;
    private final ClusterSettings clusterSettings;

    @Inject
    public TransportSimulateIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService, SystemIndices systemIndices, IndexSettingProviders indexSettingProviders) {
        super("indices:admin/index_template/simulate_index", transportService, clusterService, threadPool, actionFilters, SimulateIndexTemplateRequest::new, indexNameExpressionResolver, SimulateIndexTemplateResponse::new, "same");
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.systemIndices = systemIndices;
        this.indexSettingProviders = indexSettingProviders.getIndexSettingProviders();
        this.clusterSettings = clusterService.getClusterSettings();
    }

    @Override
    protected void masterOperation(Task task, SimulateIndexTemplateRequest request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        if (request.getIndexTemplateRequest() != null) {
            String simulateTemplateToAdd = "simulate_index_template_" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = TransportSimulateIndexTemplateAction.removeExistingAbstractions(this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate()), request.getIndexName());
        } else {
            stateWithTemplate = TransportSimulateIndexTemplateAction.removeExistingAbstractions(state, request.getIndexName());
        }
        String matchingTemplate = MetadataIndexTemplateService.findV2Template(stateWithTemplate.metadata(), request.getIndexName(), false);
        if (matchingTemplate == null) {
            listener.onResponse(new SimulateIndexTemplateResponse(null, null));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState(matchingTemplate, request.getIndexName(), stateWithTemplate);
        ComposableIndexTemplate templateV2 = tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, request.getIndexName(), stateWithTemplate, this.xContentRegistry, this.indicesService, this.systemIndices, this.indexSettingProviders);
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        if (request.includeDefaults() && DataStreamLifecycle.isFeatureEnabled()) {
            listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping, this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING)));
        } else {
            listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
        }
    }

    private static ClusterState removeExistingAbstractions(ClusterState state, String indexName) {
        Metadata metadata = state.metadata();
        return ClusterState.builder(state).metadata(Metadata.builder(metadata).removeDataStream(indexName).removeAllIndices().build()).build();
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static ClusterState resolveTemporaryState(String matchingTemplate, String indexName, ClusterState simulatedState) {
        Settings settings = MetadataIndexTemplateService.resolveSettings(simulatedState.metadata(), matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder(indexName).settings(dummySettings).build();
        return ClusterState.builder(simulatedState).metadata(Metadata.builder(simulatedState.metadata()).put(indexMetadata, true).build()).build();
    }

    public static Template resolveTemplate(String matchingTemplate, String indexName, ClusterState simulatedState, NamedXContentRegistry xContentRegistry, IndicesService indicesService, SystemIndices systemIndices, Set<IndexSettingProvider> indexSettingProviders) throws Exception {
        Metadata metadata = simulatedState.getMetadata();
        Settings templateSettings = MetadataIndexTemplateService.resolveSettings(simulatedState.metadata(), matchingTemplate);
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(simulatedState.metadata(), matchingTemplate);
        ComposableIndexTemplate template = simulatedState.metadata().templatesV2().get(matchingTemplate);
        Settings.Builder dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID());
        List<CompressedXContent> mappings = MetadataCreateIndexService.collectV2Mappings(null, simulatedState, matchingTemplate, xContentRegistry, indexName);
        Instant now = Instant.now();
        Settings.Builder additionalSettings = Settings.builder();
        for (IndexSettingProvider provider : indexSettingProviders) {
            Settings result = provider.getAdditionalIndexSettings(indexName, template.getDataStreamTemplate() != null ? indexName : null, template.getDataStreamTemplate() != null && metadata.isTimeSeriesTemplate(template), simulatedState.getMetadata(), now, templateSettings, mappings);
            dummySettings.put(result);
            additionalSettings.put(result);
        }
        dummySettings.put(templateSettings);
        IndexMetadata indexMetadata = IndexMetadata.builder(indexName).settings(dummySettings).build();
        ClusterState tempClusterState = ClusterState.builder(simulatedState).metadata(Metadata.builder(simulatedState.metadata()).put(indexMetadata, true).build()).build();
        List aliases = (List)indicesService.withTempIndexService(indexMetadata, tempIndexService -> MetadataCreateIndexService.resolveAndValidateAliases(indexName, Set.of(), resolvedAliases, tempClusterState.metadata(), xContentRegistry, tempIndexService.newSearchExecutionContext(0, 0, null, () -> 0L, null, Collections.emptyMap()), IndexService.dateMathExpressionResolverAt(), systemIndices::isSystemName));
        Map<String, AliasMetadata> aliasesByName = aliases.stream().collect(Collectors.toMap(AliasMetadata::getAlias, Function.identity()));
        CompressedXContent mergedMapping = (CompressedXContent)indicesService.withTempIndexService(indexMetadata, tempIndexService -> {
            MapperService mapperService = tempIndexService.mapperService();
            for (CompressedXContent mapping : mappings) {
                mapperService.merge("_doc", mapping, MapperService.MergeReason.INDEX_TEMPLATE);
            }
            DocumentMapper documentMapper = mapperService.documentMapper();
            return documentMapper != null ? documentMapper.mappingSource() : null;
        });
        Settings settings = Settings.builder().put(templateSettings).put(additionalSettings.build()).build();
        DataStreamLifecycle lifecycle = MetadataIndexTemplateService.resolveLifecycle(simulatedState.metadata(), matchingTemplate);
        if (DataStreamLifecycle.isFeatureEnabled() && template.getDataStreamTemplate() != null && lifecycle == null) {
            lifecycle = DataStreamLifecycle.DEFAULT;
        }
        return new Template(settings, mergedMapping, aliasesByName, lifecycle);
    }
}

