/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.ChunkedBroadcastResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndicesSegmentResponse
extends ChunkedBroadcastResponse {
    private final ShardSegments[] shards;
    private volatile Map<String, IndexSegments> indicesSegments;

    IndicesSegmentResponse(StreamInput in) throws IOException {
        super(in);
        this.shards = in.readArray(ShardSegments::new, ShardSegments[]::new);
    }

    IndicesSegmentResponse(ShardSegments[] shards, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public Map<String, IndexSegments> getIndices() {
        if (this.indicesSegments != null) {
            return this.indicesSegments;
        }
        HashMap<String, IndexSegments> indicesSegments = new HashMap<String, IndexSegments>();
        HashMap<String, List> segmentsByIndex = new HashMap<String, List>();
        for (ShardSegments shard : this.shards) {
            segmentsByIndex.computeIfAbsent(shard.getShardRouting().getIndexName(), k -> new ArrayList()).add(shard);
        }
        for (Map.Entry entry : segmentsByIndex.entrySet()) {
            indicesSegments.put((String)entry.getKey(), new IndexSegments((String)entry.getKey(), (List)entry.getValue()));
        }
        this.indicesSegments = indicesSegments;
        return indicesSegments;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(this.shards);
    }

    @Override
    protected Iterator<ToXContent> customXContentChunks(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((builder, p) -> builder.startObject("indices")), Iterators.map(this.getIndices().values().iterator(), indexSegments -> (builder, p) -> {
            builder.startObject(indexSegments.getIndex());
            builder.startObject("shards");
            for (IndexShardSegments indexSegment : indexSegments) {
                builder.startArray(Integer.toString(indexSegment.shardId().id()));
                for (ShardSegments shardSegments : indexSegment) {
                    builder.startObject();
                    builder.startObject("routing");
                    builder.field("state", (Enum)shardSegments.getShardRouting().state());
                    builder.field("primary", shardSegments.getShardRouting().primary());
                    builder.field("node", shardSegments.getShardRouting().currentNodeId());
                    if (shardSegments.getShardRouting().relocatingNodeId() != null) {
                        builder.field("relocating_node", shardSegments.getShardRouting().relocatingNodeId());
                    }
                    builder.endObject();
                    builder.field("num_committed_segments", shardSegments.getNumberOfCommitted());
                    builder.field("num_search_segments", shardSegments.getNumberOfSearch());
                    builder.startObject("segments");
                    for (Segment segment : shardSegments) {
                        builder.startObject(segment.getName());
                        builder.field("generation", segment.getGeneration());
                        builder.field("num_docs", segment.getNumDocs());
                        builder.field("deleted_docs", segment.getDeletedDocs());
                        builder.humanReadableField("size_in_bytes", "size", (Object)segment.getSize());
                        if (builder.getRestApiVersion() == RestApiVersion.V_7) {
                            builder.humanReadableField("memory_in_bytes", "memory", (Object)ByteSizeValue.ZERO);
                        }
                        builder.field("committed", segment.isCommitted());
                        builder.field("search", segment.isSearch());
                        if (segment.getVersion() != null) {
                            builder.field("version", (Object)segment.getVersion());
                        }
                        if (segment.isCompound() != null) {
                            builder.field("compound", segment.isCompound());
                        }
                        if (segment.getMergeId() != null) {
                            builder.field("merge_id", segment.getMergeId());
                        }
                        if (segment.getSegmentSort() != null) {
                            IndicesSegmentResponse.toXContent(builder, segment.getSegmentSort());
                        }
                        if (segment.attributes != null && !segment.attributes.isEmpty()) {
                            builder.field("attributes", segment.attributes);
                        }
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }), Iterators.single((builder, p) -> builder.endObject()));
    }

    private static void toXContent(XContentBuilder builder, Sort sort) throws IOException {
        builder.startArray("sort");
        for (SortField field : sort.getSort()) {
            builder.startObject();
            builder.field("field", field.getField());
            if (field instanceof SortedNumericSortField) {
                builder.field("mode", ((SortedNumericSortField)field).getSelector().toString().toLowerCase(Locale.ROOT));
            } else if (field instanceof SortedSetSortField) {
                builder.field("mode", ((SortedSetSortField)field).getSelector().toString().toLowerCase(Locale.ROOT));
            }
            if (field.getMissingValue() != null) {
                builder.field("missing", field.getMissingValue().toString());
            }
            builder.field("reverse", field.getReverse());
            builder.endObject();
        }
        builder.endArray();
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";
        static final String SEGMENTS = "segments";
        static final String GENERATION = "generation";
        static final String NUM_COMMITTED_SEGMENTS = "num_committed_segments";
        static final String NUM_SEARCH_SEGMENTS = "num_search_segments";
        static final String NUM_DOCS = "num_docs";
        static final String DELETED_DOCS = "deleted_docs";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String COMMITTED = "committed";
        static final String SEARCH = "search";
        static final String VERSION = "version";
        static final String COMPOUND = "compound";
        static final String MERGE_ID = "merge_id";
        static final String MEMORY = "memory";
        static final String MEMORY_IN_BYTES = "memory_in_bytes";
        static final String RAM_TREE = "ram_tree";
        static final String DESCRIPTION = "description";
        static final String CHILDREN = "children";

        Fields() {
        }
    }
}

