/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexAliasesService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesAliasesAction
extends AcknowledgedTransportMasterNodeAction<IndicesAliasesRequest> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesAliasesAction.class);
    private final MetadataIndexAliasesService indexAliasesService;
    private final RequestValidators<IndicesAliasesRequest> requestValidators;
    private final SystemIndices systemIndices;

    @Inject
    public TransportIndicesAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexAliasesService indexAliasesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<IndicesAliasesRequest> requestValidators, SystemIndices systemIndices) {
        super("indices:admin/aliases", transportService, clusterService, threadPool, actionFilters, IndicesAliasesRequest::new, indexNameExpressionResolver, "same");
        this.indexAliasesService = indexAliasesService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet indices = new HashSet();
        for (IndicesAliasesRequest.AliasActions aliasAction : request.aliasActions()) {
            Collections.addAll(indices, aliasAction.indices());
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices.toArray(new String[indices.size()]));
    }

    @Override
    protected void masterOperation(Task task, IndicesAliasesRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        List<IndicesAliasesRequest.AliasActions> actions = request.aliasActions();
        ArrayList<AliasAction> finalActions = new ArrayList<AliasAction>();
        HashSet aliases = new HashSet();
        block9: for (IndicesAliasesRequest.AliasActions action : actions) {
            Index[] concreteIndices;
            List<String> concreteDataStreams = this.indexNameExpressionResolver.dataStreamNames(state, request.indicesOptions(), action.indices());
            if (concreteDataStreams.size() != 0) {
                Index[] unprocessedConcreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), true, action.indices());
                List<Index> nonBackingIndices = Arrays.stream(unprocessedConcreteIndices).filter(index -> {
                    IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(index.getName());
                    return ia.getParentDataStream() == null;
                }).toList();
                concreteIndices = (Index[])nonBackingIndices.toArray(Index[]::new);
                switch (action.actionType()) {
                    case ADD: {
                        String alias;
                        int n;
                        int n2;
                        if (action.routing() != null) {
                            throw new IllegalArgumentException("aliases that point to data streams don't support routing");
                        }
                        if (action.indexRouting() != null) {
                            throw new IllegalArgumentException("aliases that point to data streams don't support index_routing");
                        }
                        if (action.searchRouting() != null) {
                            throw new IllegalArgumentException("aliases that point to data streams don't support search_routing");
                        }
                        if (action.isHidden() != null) {
                            throw new IllegalArgumentException("aliases that point to data streams don't support is_hidden");
                        }
                        if (!nonBackingIndices.isEmpty()) {
                            throw new IllegalArgumentException("expressions " + Arrays.toString(action.indices()) + " that match with both data streams and regular indices are disallowed");
                        }
                        for (String dataStreamName : concreteDataStreams) {
                            String[] stringArray = TransportIndicesAliasesAction.concreteDataStreamAliases(action, state.metadata(), dataStreamName);
                            n2 = stringArray.length;
                            for (n = 0; n < n2; ++n) {
                                alias = stringArray[n];
                                finalActions.add(new AliasAction.AddDataStreamAlias(alias, dataStreamName, action.writeIndex(), action.filter()));
                            }
                        }
                        continue block9;
                    }
                    case REMOVE: {
                        String alias;
                        int n;
                        int n2;
                        for (String dataStreamName : concreteDataStreams) {
                            String[] stringArray = TransportIndicesAliasesAction.concreteDataStreamAliases(action, state.metadata(), dataStreamName);
                            n2 = stringArray.length;
                            for (n = 0; n < n2; ++n) {
                                alias = stringArray[n];
                                finalActions.add(new AliasAction.RemoveDataStreamAlias(alias, dataStreamName, action.mustExist()));
                            }
                        }
                        if (nonBackingIndices.isEmpty()) continue block9;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + action.actionType() + "]");
                    }
                }
            } else {
                concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), false, action.indices());
            }
            for (Index concreteIndex : concreteIndices) {
                IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(concreteIndex.getName());
                assert (indexAbstraction != null) : "invalid cluster metadata. index [" + concreteIndex.getName() + "] was not found";
                if (indexAbstraction.getParentDataStream() == null) continue;
                throw new IllegalArgumentException("The provided expressions [" + String.join((CharSequence)",", action.indices()) + "] match a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data stream backing indices don't support aliases.");
            }
            Optional<Exception> maybeException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeException.isPresent()) {
                listener.onFailure(maybeException.get());
                return;
            }
            Collections.addAll(aliases, action.getOriginalAliases());
            long now = System.currentTimeMillis();
            block15: for (Index index2 : concreteIndices) {
                switch (action.actionType()) {
                    case ADD: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index2.getName())) {
                            String resolvedName = IndexNameExpressionResolver.resolveDateMathExpression(alias, now);
                            finalActions.add(new AliasAction.Add(index2.getName(), resolvedName, action.filter(), action.indexRouting(), action.searchRouting(), action.writeIndex(), this.systemIndices.isSystemName(resolvedName) ? Boolean.TRUE : action.isHidden()));
                        }
                        continue block15;
                    }
                    case REMOVE: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index2.getName())) {
                            finalActions.add(new AliasAction.Remove(index2.getName(), alias, action.mustExist()));
                        }
                        continue block15;
                    }
                    case REMOVE_INDEX: {
                        finalActions.add(new AliasAction.RemoveIndex(index2.getName()));
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + action.actionType() + "]");
                    }
                }
            }
        }
        if (finalActions.isEmpty() && !actions.isEmpty()) {
            throw new AliasesNotFoundException(aliases.toArray(new String[aliases.size()]));
        }
        request.aliasActions().clear();
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(Collections.unmodifiableList(finalActions)).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        this.indexAliasesService.indicesAliases(updateRequest, listener.delegateResponse((l, e) -> {
            logger.debug("failed to perform aliases", (Throwable)e);
            l.onFailure((Exception)e);
        }));
    }

    private static String[] concreteAliases(IndicesAliasesRequest.AliasActions action, Metadata metadata, String concreteIndex) {
        if (action.expandAliasesWildcards()) {
            String[] concreteIndices = new String[]{concreteIndex};
            Map<String, List<AliasMetadata>> aliasMetadata = metadata.findAliases(action.aliases(), concreteIndices);
            ArrayList<String> finalAliases = new ArrayList<String>();
            for (List<AliasMetadata> aliases : aliasMetadata.values()) {
                for (AliasMetadata aliasMeta : aliases) {
                    finalAliases.add(aliasMeta.alias());
                }
            }
            if (finalAliases.isEmpty() && action.mustExist() != null && action.mustExist().booleanValue()) {
                return action.aliases();
            }
            return finalAliases.toArray(new String[finalAliases.size()]);
        }
        return action.aliases();
    }

    private static String[] concreteDataStreamAliases(IndicesAliasesRequest.AliasActions action, Metadata metadata, String concreteDataStreamName) {
        if (action.expandAliasesWildcards()) {
            Stream<String> stream = metadata.dataStreamAliases().values().stream().filter(alias -> alias.getDataStreams().contains(concreteDataStreamName)).map(DataStreamAlias::getName);
            String[] aliasPatterns = action.aliases();
            if (!Strings.isAllOrWildcard(aliasPatterns)) {
                stream = stream.filter(alias -> Regex.simpleMatch(aliasPatterns, alias));
            }
            return (String[])stream.toArray(String[]::new);
        }
        return action.aliases();
    }
}

