/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class ClusterStatsNodeResponse
extends BaseNodeResponse {
    private final NodeInfo nodeInfo;
    private final NodeStats nodeStats;
    private final ShardStats[] shardsStats;
    private ClusterHealthStatus clusterStatus;
    private final SearchUsageStats searchUsageStats;

    public ClusterStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterStatus = null;
        if (in.readBoolean()) {
            this.clusterStatus = ClusterHealthStatus.readFrom(in);
        }
        this.nodeInfo = new NodeInfo(in);
        this.nodeStats = new NodeStats(in);
        this.shardsStats = in.readArray(ShardStats::new, ShardStats[]::new);
        this.searchUsageStats = in.getTransportVersion().onOrAfter(TransportVersion.V_8_6_0) ? new SearchUsageStats(in) : new SearchUsageStats();
    }

    public ClusterStatsNodeResponse(DiscoveryNode node, @Nullable ClusterHealthStatus clusterStatus, NodeInfo nodeInfo, NodeStats nodeStats, ShardStats[] shardsStats, SearchUsageStats searchUsageStats) {
        super(node);
        this.nodeInfo = nodeInfo;
        this.nodeStats = nodeStats;
        this.shardsStats = shardsStats;
        this.clusterStatus = clusterStatus;
        this.searchUsageStats = searchUsageStats;
    }

    public NodeInfo nodeInfo() {
        return this.nodeInfo;
    }

    public NodeStats nodeStats() {
        return this.nodeStats;
    }

    @Nullable
    public ClusterHealthStatus clusterStatus() {
        return this.clusterStatus;
    }

    public ShardStats[] shardsStats() {
        return this.shardsStats;
    }

    public SearchUsageStats searchUsageStats() {
        return this.searchUsageStats;
    }

    public static ClusterStatsNodeResponse readNodeResponse(StreamInput in) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.clusterStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.clusterStatus.value());
        }
        this.nodeInfo.writeTo(out);
        this.nodeStats.writeTo(out);
        out.writeArray(this.shardsStats);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_6_0)) {
            this.searchUsageStats.writeTo(out);
        }
    }
}

