/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotsStatusResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final List<SnapshotStatus> snapshots;
    private static final ConstructingObjectParser<SnapshotsStatusResponse, Void> PARSER = new ConstructingObjectParser("snapshots_status_response", true, parsedObjects -> {
        List snapshots = (List)parsedObjects[0];
        return new SnapshotsStatusResponse(snapshots);
    });

    public SnapshotsStatusResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshots = in.readImmutableList(SnapshotStatus::new);
    }

    SnapshotsStatusResponse(List<SnapshotStatus> snapshots) {
        this.snapshots = snapshots;
    }

    public List<SnapshotStatus> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshots);
    }

    public static SnapshotsStatusResponse fromXContent(XContentParser parser) throws IOException {
        return (SnapshotsStatusResponse)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.snapshots, ((SnapshotsStatusResponse)o).snapshots);
    }

    public int hashCode() {
        return this.snapshots != null ? this.snapshots.hashCode() : 0;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((b, p) -> b.startObject().startArray("snapshots")), Iterators.flatMap(this.snapshots.iterator(), s -> s.toXContentChunked(params)), Iterators.single((b, p) -> b.endArray().endObject()));
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshotStatus.PARSER, new ParseField("snapshots", new String[0]));
    }
}

