/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.RestoreService;

public class RestoreClusterStateListener {
    private static final Logger logger = LogManager.getLogger(RestoreClusterStateListener.class);

    private RestoreClusterStateListener() {
    }

    public static void createAndRegisterListener(final ClusterService clusterService, final RestoreService.RestoreCompletionResponse response, ActionListener<RestoreSnapshotResponse> listener, final ThreadContext threadContext) {
        final String uuid = response.getUuid();
        final DiscoveryNode localNode = clusterService.localNode();
        ClusterStateObserver.waitForState(clusterService, threadContext, new RestoreListener(listener, localNode){

            @Override
            public void onNewClusterState(ClusterState state) {
                RestoreInProgress.Entry restoreState = RestoreService.restoreInProgress(state, uuid);
                if (restoreState == null) {
                    this.listener.onResponse(new RestoreSnapshotResponse((RestoreInfo)null));
                    return;
                }
                Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = restoreState.shards();
                assert (restoreState.state().completed()) : "expected completed snapshot state but was " + restoreState.state();
                assert (RestoreService.completed(shards)) : "expected all restore entries to be completed";
                final RestoreInfo restoreInfo = new RestoreInfo(restoreState.snapshot().getSnapshotId().getName(), restoreState.indices(), shards.size(), shards.size() - RestoreService.failedShards(shards));
                ClusterStateObserver.waitForState(clusterService, threadContext, new RestoreListener(this.listener, localNode){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        logger.debug("restore of [{}] completed", (Object)response.getSnapshot().getSnapshotId());
                        this.listener.onResponse(new RestoreSnapshotResponse(restoreInfo));
                    }
                }, clusterState -> RestoreService.restoreInProgress(clusterState, uuid) == null, null, logger);
            }
        }, clusterState -> {
            RestoreInProgress.Entry restoreState = RestoreService.restoreInProgress(clusterState, uuid);
            return restoreState == null || RestoreService.completed(restoreState.shards());
        }, null, logger);
    }

    private static abstract class RestoreListener
    implements ClusterStateObserver.Listener {
        protected final ActionListener<RestoreSnapshotResponse> listener;
        private final DiscoveryNode localNode;

        protected RestoreListener(ActionListener<RestoreSnapshotResponse> listener, DiscoveryNode localNode) {
            this.listener = listener;
            this.localNode = localNode;
        }

        @Override
        public void onClusterServiceClose() {
            this.listener.onFailure(new NodeClosedException(this.localNode));
        }

        @Override
        public void onTimeout(TimeValue timeout) {
            assert (false) : "impossible, no timeout set";
        }
    }
}

