/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterSearchShardsResponse
extends ActionResponse
implements ToXContentObject {
    private final ClusterSearchShardsGroup[] groups;
    private final DiscoveryNode[] nodes;
    private final Map<String, AliasFilter> indicesAndFilters;

    public ClusterSearchShardsResponse(StreamInput in) throws IOException {
        super(in);
        this.groups = in.readArray(ClusterSearchShardsGroup::new, ClusterSearchShardsGroup[]::new);
        this.nodes = in.readArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.indicesAndFilters = in.readMap(AliasFilter::readFrom);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.groups);
        out.writeArray(this.nodes);
        out.writeMap(this.indicesAndFilters, StreamOutput::writeString, (o, s) -> s.writeTo(o));
    }

    public ClusterSearchShardsResponse(ClusterSearchShardsGroup[] groups, DiscoveryNode[] nodes, Map<String, AliasFilter> indicesAndFilters) {
        this.groups = groups;
        this.nodes = nodes;
        this.indicesAndFilters = indicesAndFilters;
    }

    public ClusterSearchShardsGroup[] getGroups() {
        return this.groups;
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public Map<String, AliasFilter> getIndicesAndFilters() {
        return this.indicesAndFilters;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("nodes");
        for (DiscoveryNode node : this.nodes) {
            node.toXContent(builder, params);
        }
        builder.endObject();
        if (this.indicesAndFilters != null) {
            builder.startObject("indices");
            for (Map.Entry entry : this.indicesAndFilters.entrySet()) {
                String index = (String)entry.getKey();
                builder.startObject(index);
                AliasFilter aliasFilter = (AliasFilter)entry.getValue();
                Object[] aliases = aliasFilter.getAliases();
                if (aliases.length > 0) {
                    Arrays.sort(aliases);
                    builder.array("aliases", (String[])aliases);
                    if (aliasFilter.getQueryBuilder() != null) {
                        builder.field("filter");
                        aliasFilter.getQueryBuilder().toXContent(builder, params);
                    }
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.startArray("shards");
        for (ClusterSearchShardsGroup group : this.groups) {
            group.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

