/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ClusterUpdateSettingsResponse
extends AcknowledgedResponse {
    private static final ParseField PERSISTENT = new ParseField("persistent", new String[0]);
    private static final ParseField TRANSIENT = new ParseField("transient", new String[0]);
    private static final ConstructingObjectParser<ClusterUpdateSettingsResponse, Void> PARSER = new ConstructingObjectParser("cluster_update_settings_response", true, args -> new ClusterUpdateSettingsResponse((Boolean)args[0], (Settings)args[1], (Settings)args[2]));
    final Settings transientSettings;
    final Settings persistentSettings;

    ClusterUpdateSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.transientSettings = Settings.readSettingsFromStream(in);
        this.persistentSettings = Settings.readSettingsFromStream(in);
    }

    ClusterUpdateSettingsResponse(boolean acknowledged, Settings transientSettings, Settings persistentSettings) {
        super(acknowledged);
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.transientSettings.writeTo(out);
        this.persistentSettings.writeTo(out);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PERSISTENT.getPreferredName());
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT.getPreferredName());
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
    }

    public static ClusterUpdateSettingsResponse fromXContent(XContentParser parser) {
        return (ClusterUpdateSettingsResponse)PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ClusterUpdateSettingsResponse that = (ClusterUpdateSettingsResponse)o;
            return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transientSettings, this.persistentSettings);
    }

    static {
        ClusterUpdateSettingsResponse.declareAcknowledgedField(PARSER);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), TRANSIENT);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), PERSISTENT);
    }
}

