/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.delete;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteRepositoryAction
extends AcknowledgedTransportMasterNodeAction<DeleteRepositoryRequest> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportDeleteRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/delete", transportService, clusterService, threadPool, actionFilters, DeleteRepositoryRequest::new, indexNameExpressionResolver, "same");
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, DeleteRepositoryRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.repositoriesService.unregisterRepository(request, listener);
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("snapshot_repositories");
    }

    @Override
    public Set<String> modifiedKeys(DeleteRepositoryRequest request) {
        return Set.of(request.name());
    }
}

