/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public class NodePrevalidateShardPathRequest
extends TransportRequest {
    private final Set<ShardId> shardIds;

    public NodePrevalidateShardPathRequest(Collection<ShardId> shardIds) {
        this.shardIds = Set.copyOf(Objects.requireNonNull(shardIds));
    }

    public NodePrevalidateShardPathRequest(StreamInput in) throws IOException {
        super(in);
        this.shardIds = in.readImmutableSet(ShardId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.shardIds, (o, value) -> value.writeTo(o));
    }

    public Set<ShardId> getShardIds() {
        return this.shardIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodePrevalidateShardPathRequest)) {
            return false;
        }
        NodePrevalidateShardPathRequest other = (NodePrevalidateShardPathRequest)o;
        return Objects.equals(this.shardIds, other.shardIds);
    }

    public int hashCode() {
        return Objects.hash(this.shardIds);
    }
}

