/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.TransportRequest;

public class NodesReloadSecureSettingsRequest
extends BaseNodesRequest<NodesReloadSecureSettingsRequest>
implements Releasable {
    @Nullable
    private SecureString secureSettingsPassword;
    private final Set<NodeRequest> nodeRequests = ConcurrentHashMap.newKeySet();

    public NodesReloadSecureSettingsRequest() {
        super((String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodesReloadSecureSettingsRequest(StreamInput in) throws IOException {
        super(in);
        BytesReference bytesRef = in.readOptionalBytesReference();
        if (bytesRef != null) {
            byte[] bytes = BytesReference.toBytes(bytesRef);
            try {
                this.secureSettingsPassword = new SecureString(CharArrays.utf8BytesToChars((byte[])bytes));
            }
            finally {
                Arrays.fill(bytes, (byte)0);
            }
        } else {
            this.secureSettingsPassword = null;
        }
    }

    public NodesReloadSecureSettingsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    @Nullable
    public SecureString getSecureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    public void setSecureStorePassword(SecureString secureStorePassword) {
        this.secureSettingsPassword = secureStorePassword;
    }

    boolean hasPassword() {
        return this.secureSettingsPassword != null && this.secureSettingsPassword.length() > 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.secureSettingsPassword == null) {
            out.writeOptionalBytesReference(null);
        } else {
            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])this.secureSettingsPassword.getChars());
            try {
                out.writeOptionalBytesReference(new BytesArray(passwordBytes));
            }
            finally {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
    }

    NodeRequest newNodeRequest() {
        NodesReloadSecureSettingsRequest clone = new NodesReloadSecureSettingsRequest(this.nodesIds());
        if (this.hasPassword()) {
            clone.setSecureStorePassword(this.getSecureSettingsPassword().clone());
        }
        NodeRequest nodeRequest = new NodeRequest(clone);
        this.nodeRequests.add(nodeRequest);
        return nodeRequest;
    }

    public void close() {
        if (this.secureSettingsPassword != null) {
            this.secureSettingsPassword.close();
        }
        this.nodeRequests.forEach(NodeRequest::close);
    }

    public static class NodeRequest
    extends TransportRequest
    implements Releasable {
        NodesReloadSecureSettingsRequest request;

        NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesReloadSecureSettingsRequest(in);
        }

        NodeRequest(NodesReloadSecureSettingsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }

        public void close() {
            assert (this.request.nodeRequests.isEmpty()) : "potential circular reference";
            this.request.close();
        }
    }
}

