/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.support.nodes.NodesOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;

public class NodesInfoRequestBuilder
extends NodesOperationRequestBuilder<NodesInfoRequest, NodesInfoResponse, NodesInfoRequestBuilder> {
    public NodesInfoRequestBuilder(ElasticsearchClient client, NodesInfoAction action) {
        super(client, action, new NodesInfoRequest(new String[0]));
    }

    public NodesInfoRequestBuilder clear() {
        ((NodesInfoRequest)this.request).clear();
        return this;
    }

    public NodesInfoRequestBuilder all() {
        ((NodesInfoRequest)this.request).all();
        return this;
    }

    public NodesInfoRequestBuilder setSettings(boolean settings) {
        this.addOrRemoveMetric(settings, NodesInfoRequest.Metric.SETTINGS);
        return this;
    }

    public NodesInfoRequestBuilder setOs(boolean os) {
        this.addOrRemoveMetric(os, NodesInfoRequest.Metric.OS);
        return this;
    }

    public NodesInfoRequestBuilder setProcess(boolean process) {
        this.addOrRemoveMetric(process, NodesInfoRequest.Metric.PROCESS);
        return this;
    }

    public NodesInfoRequestBuilder setJvm(boolean jvm) {
        this.addOrRemoveMetric(jvm, NodesInfoRequest.Metric.JVM);
        return this;
    }

    public NodesInfoRequestBuilder setThreadPool(boolean threadPool) {
        this.addOrRemoveMetric(threadPool, NodesInfoRequest.Metric.THREAD_POOL);
        return this;
    }

    public NodesInfoRequestBuilder setTransport(boolean transport) {
        this.addOrRemoveMetric(transport, NodesInfoRequest.Metric.TRANSPORT);
        return this;
    }

    public NodesInfoRequestBuilder setHttp(boolean http) {
        this.addOrRemoveMetric(http, NodesInfoRequest.Metric.HTTP);
        return this;
    }

    public NodesInfoRequestBuilder setPlugins(boolean plugins) {
        this.addOrRemoveMetric(plugins, NodesInfoRequest.Metric.PLUGINS);
        return this;
    }

    public NodesInfoRequestBuilder setIngest(boolean ingest) {
        this.addOrRemoveMetric(ingest, NodesInfoRequest.Metric.INGEST);
        return this;
    }

    public NodesInfoRequestBuilder setIndices(boolean indices) {
        this.addOrRemoveMetric(indices, NodesInfoRequest.Metric.INDICES);
        return this;
    }

    private void addOrRemoveMetric(boolean includeMetric, NodesInfoRequest.Metric metric) {
        if (includeMetric) {
            ((NodesInfoRequest)this.request).addMetric(metric.metricName());
        } else {
            ((NodesInfoRequest)this.request).removeMetric(metric.metricName());
        }
    }
}

