/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.allocation.DesiredBalanceRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteDesiredBalanceAction
extends TransportMasterNodeAction<DesiredBalanceRequest, ActionResponse.Empty> {
    @Nullable
    private final MasterServiceTaskQueue<ResetDesiredBalanceTask> resetDesiredBalanceTaskQueue;

    @Inject
    public TransportDeleteDesiredBalanceAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, ShardsAllocator shardsAllocator) {
        super("cluster:admin/desired_balance/reset", transportService, clusterService, threadPool, actionFilters, DesiredBalanceRequest::new, indexNameExpressionResolver, in -> ActionResponse.Empty.INSTANCE, "management");
        MasterServiceTaskQueue<ResetDesiredBalanceTask> masterServiceTaskQueue;
        if (shardsAllocator instanceof DesiredBalanceShardsAllocator) {
            DesiredBalanceShardsAllocator allocator = (DesiredBalanceShardsAllocator)shardsAllocator;
            masterServiceTaskQueue = clusterService.createTaskQueue("reset-desired-balance", Priority.NORMAL, new ResetDesiredBalanceClusterExecutor(threadPool, allocationService, allocator));
        } else {
            masterServiceTaskQueue = null;
        }
        this.resetDesiredBalanceTaskQueue = masterServiceTaskQueue;
    }

    @Override
    protected void masterOperation(Task task, DesiredBalanceRequest request, ClusterState state, ActionListener<ActionResponse.Empty> listener) throws Exception {
        if (this.resetDesiredBalanceTaskQueue == null) {
            listener.onFailure(new ResourceNotFoundException("Desired balance allocator is not in use, no desired balance found", new Object[0]));
            return;
        }
        this.resetDesiredBalanceTaskQueue.submitTask("reset-desired-balance", new ResetDesiredBalanceTask(listener.map(ignored -> ActionResponse.Empty.INSTANCE)), null);
    }

    @Override
    protected ClusterBlockException checkBlock(DesiredBalanceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private static final class ResetDesiredBalanceClusterExecutor
    implements ClusterStateTaskExecutor<ResetDesiredBalanceTask> {
        private final ThreadPool threadPool;
        private final AllocationService allocationService;
        private final DesiredBalanceShardsAllocator desiredBalanceShardsAllocator;

        ResetDesiredBalanceClusterExecutor(ThreadPool threadPool, AllocationService allocationService, DesiredBalanceShardsAllocator desiredBalanceShardsAllocator) {
            this.threadPool = threadPool;
            this.allocationService = allocationService;
            this.desiredBalanceShardsAllocator = desiredBalanceShardsAllocator;
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<ResetDesiredBalanceTask> batchExecutionContext) throws InterruptedException {
            AllocationActionMultiListener listener = new AllocationActionMultiListener(this.threadPool.getThreadContext());
            ClusterState state = batchExecutionContext.initialState();
            this.desiredBalanceShardsAllocator.resetDesiredBalance();
            for (ClusterStateTaskExecutor.TaskContext<ResetDesiredBalanceTask> taskContext : batchExecutionContext.taskContexts()) {
                taskContext.success(() -> listener.delay(((ResetDesiredBalanceTask)taskContext.getTask()).listener()).onResponse(null));
            }
            return this.allocationService.reroute(state, "reset-desired-balance", listener.reroute());
        }
    }

    public record ResetDesiredBalanceTask(ActionListener<Void> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

