/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListenerImplementations;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Releasable;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    public static <T> ActionListener<T> noop() {
        return ActionListenerImplementations.NOOP;
    }

    default public <T> ActionListener<T> map(CheckedFunction<T, Response, Exception> fn) {
        return new ActionListenerImplementations.MappedActionListener<T, Response>(fn, this);
    }

    default public <T> ActionListener<T> safeMap(Function<T, Response> fn) {
        return new ActionListenerImplementations.SafeMappedActionListener<T, Response>(fn, this);
    }

    default public ActionListener<Response> delegateResponse(BiConsumer<ActionListener<Response>, Exception> bc) {
        return new ActionListenerImplementations.DelegatingResponseActionListener(this, bc);
    }

    default public <T> ActionListener<T> delegateFailure(BiConsumer<ActionListener<Response>, T> bc) {
        return new ActionListenerImplementations.DelegatingFailureActionListener<T, Response>(this, bc);
    }

    default public <T> ActionListener<T> delegateFailureAndWrap(CheckedBiConsumer<ActionListener<Response>, T, ? extends Exception> bc) {
        return new ActionListenerImplementations.ResponseWrappingActionListener<T, Response>(this, bc);
    }

    public static <Response> ActionListener<Response> releasing(Releasable releasable) {
        return ActionListener.assertOnce(ActionListener.running(ActionListenerImplementations.runnableFromReleasable(releasable)));
    }

    public static <Response> ActionListener<Response> running(final Runnable runnable) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    runnable.run();
                }
                catch (RuntimeException e) {
                    assert (false) : e;
                    throw e;
                }
            }

            @Override
            public void onFailure(Exception e) {
                ActionListenerImplementations.safeAcceptException(ignored -> runnable.run(), e);
            }

            public String toString() {
                return "RunnableWrappingActionListener{" + runnable + "}";
            }
        };
    }

    @Deprecated(forRemoval=true)
    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return ActionListener.running(runnable);
    }

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                ActionListenerImplementations.safeAcceptException(onFailure, e);
            }

            public String toString() {
                return "WrappedActionListener{" + onResponse + "}{" + onFailure + "}";
            }
        };
    }

    public static <DelegateResponse, Response extends DelegateResponse> ActionListener<Response> wrap(final ActionListener<DelegateResponse> delegate) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                ActionListener.run(delegate, l -> l.onResponse(response));
            }

            @Override
            public void onFailure(Exception e) {
                ActionListenerImplementations.safeOnFailure(delegate, e);
            }

            public String toString() {
                return "wrapped{" + delegate + "}";
            }
        };
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    ActionListenerImplementations.safeOnFailure(listener, ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> ActionListener<Response> runAfter(ActionListener<Response> delegate, Runnable runAfter) {
        return ActionListener.assertOnce(new ActionListenerImplementations.RunAfterActionListener<Response>(delegate, runAfter));
    }

    public static <Response> ActionListener<Response> releaseAfter(ActionListener<Response> delegate, Releasable releaseAfter) {
        return ActionListener.assertOnce(new ActionListenerImplementations.RunAfterActionListener<Response>(delegate, ActionListenerImplementations.runnableFromReleasable(releaseAfter)));
    }

    public static <Response> ActionListener<Response> runBefore(ActionListener<Response> delegate, CheckedRunnable<?> runBefore) {
        return ActionListener.assertOnce(new ActionListenerImplementations.RunBeforeActionListener<Response>(delegate, runBefore));
    }

    public static <Response> ActionListener<Response> notifyOnce(ActionListener<Response> delegate) {
        return new ActionListenerImplementations.NotifyOnceActionListener<Response>(delegate);
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        Response response;
        try {
            response = supplier.get();
        }
        catch (Exception e) {
            ActionListenerImplementations.safeOnFailure(listener, e);
            return;
        }
        try {
            listener.onResponse(response);
        }
        catch (RuntimeException ex) {
            if (!5.$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            throw ex;
        }
    }

    public static <Response> ActionListener<Response> assertOnce(final ActionListener<Response> delegate) {
        if (Assertions.ENABLED) {
            return new ActionListener<Response>(){
                private final AtomicReference<ElasticsearchException> firstCompletion = new AtomicReference();

                private void assertFirstRun() {
                    ElasticsearchException previousRun = this.firstCompletion.compareAndExchange(null, new ElasticsearchException(delegate.toString(), new Object[0]));
                    assert (previousRun == null) : previousRun;
                }

                @Override
                public void onResponse(Response response) {
                    this.assertFirstRun();
                    delegate.onResponse(response);
                }

                @Override
                public void onFailure(Exception e) {
                    this.assertFirstRun();
                    ActionListenerImplementations.safeOnFailure(delegate, e);
                }

                public String toString() {
                    return delegate.toString();
                }

                public int hashCode() {
                    throw new AssertionError((Object)"almost certainly a mistake to need the hashCode() of a one-shot ActionListener");
                }

                public boolean equals(Object obj) {
                    throw new AssertionError((Object)"almost certainly a mistake to compare a one-shot ActionListener for equality");
                }
            };
        }
        return delegate;
    }

    public static <T, L extends ActionListener<T>> void run(L listener, CheckedConsumer<L, Exception> action) {
        try {
            action.accept(listener);
        }
        catch (Exception e) {
            ActionListenerImplementations.safeOnFailure(listener, e);
        }
    }

    static {
        if (5.$assertionsDisabled) {
            // empty if block
        }
    }
}

