/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.internal.VersionExtension;

public record TransportVersion(int id) implements VersionId<TransportVersion>
{
    private static Map<String, Integer> IDS = new HashMap<String, Integer>();
    public static final TransportVersion ZERO = TransportVersion.registerTransportVersion(0, "00000000-0000-0000-0000-000000000000");
    public static final TransportVersion V_7_0_0 = TransportVersion.registerTransportVersion(7000099, "7505fd05-d982-43ce-a63f-ff4c6c8bdeec");
    public static final TransportVersion V_7_0_1 = TransportVersion.registerTransportVersion(7000199, "ae772780-e6f9-46a1-b0a0-20ed0cae37f7");
    public static final TransportVersion V_7_1_0 = TransportVersion.registerTransportVersion(7010099, "fd09007c-1c54-450a-af99-9f941e1a53c2");
    public static final TransportVersion V_7_2_0 = TransportVersion.registerTransportVersion(7020099, "b74dbc52-e727-472c-af21-2156482e8796");
    public static final TransportVersion V_7_2_1 = TransportVersion.registerTransportVersion(7020199, "a3217b94-f436-4aab-a020-162c83ba18f2");
    public static final TransportVersion V_7_3_0 = TransportVersion.registerTransportVersion(7030099, "4f04e4c9-c5aa-49e4-8b99-abeb4e284a5a");
    public static final TransportVersion V_7_3_2 = TransportVersion.registerTransportVersion(7030299, "60da3953-8415-4d4f-a18d-853c3e68ebd6");
    public static final TransportVersion V_7_4_0 = TransportVersion.registerTransportVersion(7040099, "ec7e58aa-55b4-4064-a9dd-fd723a2ba7a8");
    public static final TransportVersion V_7_5_0 = TransportVersion.registerTransportVersion(7050099, "cc6e14dc-9dc7-4b74-8e15-1f99a6cfbe03");
    public static final TransportVersion V_7_6_0 = TransportVersion.registerTransportVersion(7060099, "4637b8ae-f3df-43ae-a065-ad4c29f3373a");
    public static final TransportVersion V_7_7_0 = TransportVersion.registerTransportVersion(7070099, "7bb73c48-ddb8-4437-b184-30371c35dd4b");
    public static final TransportVersion V_7_8_0 = TransportVersion.registerTransportVersion(7080099, "c3cc74af-d15e-494b-a907-6ad6dd2f4660");
    public static final TransportVersion V_7_8_1 = TransportVersion.registerTransportVersion(7080199, "7acb9f6e-32f2-45ce-b87d-ca1f165b8e7a");
    public static final TransportVersion V_7_9_0 = TransportVersion.registerTransportVersion(7090099, "9388fe76-192a-4053-b51c-d2a7b8eae545");
    public static final TransportVersion V_7_10_0 = TransportVersion.registerTransportVersion(7100099, "4efca195-38e4-4f74-b877-c26fb2a40733");
    public static final TransportVersion V_7_10_1 = TransportVersion.registerTransportVersion(7100199, "0070260c-aa0b-4fc2-9c87-5cd5f23b005f");
    public static final TransportVersion V_7_11_0 = TransportVersion.registerTransportVersion(7110099, "3b43bcbc-1c5e-4cc2-a3b4-8ac8b64239e8");
    public static final TransportVersion V_7_12_0 = TransportVersion.registerTransportVersion(7120099, "3be9ff6f-2d9f-4fc2-ba91-394dd5ebcf33");
    public static final TransportVersion V_7_13_0 = TransportVersion.registerTransportVersion(7130099, "e1fe494a-7c66-4571-8f8f-1d7e6d8df1b3");
    public static final TransportVersion V_7_14_0 = TransportVersion.registerTransportVersion(7140099, "8cf0954c-b085-467f-b20b-3cb4b2e69e3e");
    public static final TransportVersion V_7_15_0 = TransportVersion.registerTransportVersion(7150099, "2273ac0e-00bb-4024-9e2e-ab78981623c6");
    public static final TransportVersion V_7_15_1 = TransportVersion.registerTransportVersion(7150199, "a8c3503d-3452-45cf-b385-e855e16547fe");
    public static final TransportVersion V_7_16_0 = TransportVersion.registerTransportVersion(7160099, "59abadd2-25db-4547-a991-c92306a3934e");
    public static final TransportVersion V_7_17_0 = TransportVersion.registerTransportVersion(7170099, "322efe93-4c73-4e15-9274-bb76836c8fa8");
    public static final TransportVersion V_7_17_1 = TransportVersion.registerTransportVersion(7170199, "51c72842-7974-4669-ad25-bf13ba307307");
    public static final TransportVersion V_7_17_8 = TransportVersion.registerTransportVersion(7170899, "82a3e70d-cf0e-4efb-ad16-6077ab9fe19f");
    public static final TransportVersion V_8_0_0 = TransportVersion.registerTransportVersion(8000099, "c7d2372c-9f01-4a79-8b11-227d862dfe4f");
    public static final TransportVersion V_8_1_0 = TransportVersion.registerTransportVersion(8010099, "3dc49dce-9cef-492a-ac8d-3cc79f6b4280");
    public static final TransportVersion V_8_2_0 = TransportVersion.registerTransportVersion(8020099, "8ce6d555-202e-47db-ab7d-ade9dda1b7e8");
    public static final TransportVersion V_8_3_0 = TransportVersion.registerTransportVersion(8030099, "559ddb66-d857-4208-bed5-a995ccf478ea");
    public static final TransportVersion V_8_4_0 = TransportVersion.registerTransportVersion(8040099, "c0d12906-aa5b-45d4-94c7-cbcf4d9818ca");
    public static final TransportVersion V_8_5_0 = TransportVersion.registerTransportVersion(8050099, "be3d7f23-7240-4904-9d7f-e25a0f766eca");
    public static final TransportVersion V_8_6_0 = TransportVersion.registerTransportVersion(8060099, "e209c5ed-3488-4415-b561-33492ca3b789");
    public static final TransportVersion V_8_6_1 = TransportVersion.registerTransportVersion(8060199, "9f113acb-1b21-4fda-bef9-2a3e669b5c7b");
    public static final TransportVersion V_8_7_0 = TransportVersion.registerTransportVersion(8070099, "f1ee7a85-4fa6-43f5-8679-33e2b750448b");
    public static final TransportVersion V_8_7_1 = TransportVersion.registerTransportVersion(8070199, "018de9d8-9e8b-4ac7-8f4b-3a6fbd0487fb");
    public static final TransportVersion V_8_8_0 = TransportVersion.registerTransportVersion(8080099, "f64fe576-0767-4ec3-984e-3e30b33b6c46");
    public static final TransportVersion V_8_8_1 = TransportVersion.registerTransportVersion(0x7B4B47, "291c71bb-5b0a-4b7e-a407-6e53bc128d0f");
    public static final TransportVersion V_8_500_010 = TransportVersion.registerTransportVersion(8500010, "9818C628-1EEC-439B-B943-468F61460675");
    public static final TransportVersion V_8_500_011 = TransportVersion.registerTransportVersion(8500011, "2209F28D-B52E-4BC4-9889-E780F291C32E");
    public static final TransportVersion V_8_500_012 = TransportVersion.registerTransportVersion(8500012, "BB6F4AF1-A860-4FD4-A138-8150FFBE0ABD");
    public static final TransportVersion V_8_500_013 = TransportVersion.registerTransportVersion(8500013, "f65b85ac-db5e-4558-a487-a1dde4f6a33a");
    public static final TransportVersion V_8_500_014 = TransportVersion.registerTransportVersion(8500014, "D115A2E1-1739-4A02-AB7B-64F6EA157EFB");
    public static final TransportVersion V_8_500_015 = TransportVersion.registerTransportVersion(8500015, "651216c9-d54f-4189-9fe1-48d82d276863");
    public static final TransportVersion V_8_500_016 = TransportVersion.registerTransportVersion(8500016, "492C94FB-AAEA-4C9E-8375-BDB67A398584");
    public static final TransportVersion V_8_500_017 = TransportVersion.registerTransportVersion(8500017, "0EDCB5BA-049C-443C-8AB1-5FA58FB996FB");
    public static final TransportVersion V_8_500_018 = TransportVersion.registerTransportVersion(8500018, "827C32CE-33D9-4AC3-A773-8FB768F59EAF");
    public static final TransportVersion V_8_500_019 = TransportVersion.registerTransportVersion(8500019, "09bae57f-cab8-423c-aab3-c9778509ffe3");
    public static final TransportVersion V_8_500_020 = TransportVersion.registerTransportVersion(8500020, "ECB42C26-B258-42E5-A835-E31AF84A76DE");
    public static final TransportVersion V_8_500_021 = TransportVersion.registerTransportVersion(8500021, "102e0d84-0c08-402c-a696-935f3a3da873");
    public static final TransportVersion V_8_500_022 = TransportVersion.registerTransportVersion(8500022, "4993c724-7a81-4955-84e7-403484610091");
    public static final TransportVersion V_8_500_023 = TransportVersion.registerTransportVersion(8500023, "01b06435-5d73-42ff-a121-3b36b771375e");
    public static final TransportVersion V_8_500_024 = TransportVersion.registerTransportVersion(8500024, "db337007-f823-4dbd-968e-375383814c17");
    public static final TransportVersion V_8_500_025 = TransportVersion.registerTransportVersion(8500025, "b2ab7b75-5ac2-4a3b-bbb6-8789ca66722d");
    public static final TransportVersion V_8_500_026 = TransportVersion.registerTransportVersion(8500026, "965d294b-14aa-4abb-bcfc-34631187941d");
    public static final TransportVersion V_8_500_027 = TransportVersion.registerTransportVersion(8500027, "B151D967-8E7C-401C-8275-0ABC06335F2D");
    public static final TransportVersion V_8_500_028 = TransportVersion.registerTransportVersion(8500028, "a6592d08-15cb-4e1a-b9b4-b2ba24058444");
    public static final TransportVersion V_8_500_029 = TransportVersion.registerTransportVersion(8500029, "f3bd98af-6187-e161-e315-718a2fecc2db");
    public static final TransportVersion V_8_500_030 = TransportVersion.registerTransportVersion(8500030, "b72d7f12-8ed3-4a5b-8e6a-4910ea10e0d7");
    public static final TransportVersion V_8_500_031 = TransportVersion.registerTransportVersion(8500031, "e7aa7e95-37e7-46a3-aad1-90a21c0769e7");
    public static final TransportVersion V_8_500_032 = TransportVersion.registerTransportVersion(8500032, "a9a14bc6-c3f2-41d9-a3d8-c686bf2c901d");
    public static final TransportVersion V_8_500_033 = TransportVersion.registerTransportVersion(8500033, "193ab7c4-a751-4cbd-a66a-2d7d56ccbc10");
    public static final TransportVersion V_8_500_034 = TransportVersion.registerTransportVersion(8500034, "16871c8b-88ba-4432-980a-10fd9ecad2dc");
    public static final TransportVersion V_8_500_035 = TransportVersion.registerTransportVersion(8500035, "664dd6ce-3487-4fbd-81a9-af778b28be45");
    public static final TransportVersion V_8_500_036 = TransportVersion.registerTransportVersion(8500036, "3343c64f-d7ac-4f02-9262-3e1acfc56f89");
    public static final TransportVersion V_8_500_037 = TransportVersion.registerTransportVersion(8500037, "d76a4f22-8878-43e0-acfa-15e452195fa7");
    public static final TransportVersion V_8_500_038 = TransportVersion.registerTransportVersion(8500038, "9ef93580-feae-409f-9989-b49e411ca7a9");
    public static final TransportVersion V_8_500_039 = TransportVersion.registerTransportVersion(8500039, "c23722d7-6139-4cf2-b8a1-600fbd4ec359");
    public static final TransportVersion V_8_500_040 = TransportVersion.registerTransportVersion(8500040, "8F3AA068-A608-4A16-9683-2412A75BF2DD");
    public static final TransportVersion V_8_500_041 = TransportVersion.registerTransportVersion(8500041, "5b6a0fd0-ac0b-443f-baae-cffec140905c");
    public static final TransportVersion V_8_500_042 = TransportVersion.registerTransportVersion(8500042, "763b4801-a4fc-47c4-aff5-7f5a757b8a07");
    public static final TransportVersion V_8_500_043 = TransportVersion.registerTransportVersion(8500043, "50babd14-7f5c-4f8c-9351-94e0d397aabc");
    public static final TransportVersion V_8_500_044 = TransportVersion.registerTransportVersion(8500044, "96b83320-2317-4e9d-b735-356f18c1d76a");
    public static final TransportVersion V_8_500_045 = TransportVersion.registerTransportVersion(8500045, "24a596dd-c843-4c0a-90b3-759697d74026");
    public static final TransportVersion V_8_500_046 = TransportVersion.registerTransportVersion(8500046, "61666d4c-a4f0-40db-8a3d-4806718247c5");
    public static final TransportVersion V_8_500_047 = TransportVersion.registerTransportVersion(8500047, "4b1682fe-c37e-4184-80f6-7d57fcba9b3d");
    public static final TransportVersion V_8_500_048 = TransportVersion.registerTransportVersion(8500048, "f9658aa5-f066-4edb-bcb9-40bf256c9294");
    public static final TransportVersion V_8_500_049 = TransportVersion.registerTransportVersion(8500049, "828bb6ce-2fbb-11ee-be56-0242ac120002");
    public static final TransportVersion V_8_500_050 = TransportVersion.registerTransportVersion(8500050, "69722fa2-7c0a-4227-86fb-6d6a9a0a0321");
    public static final TransportVersion V_8_500_051 = TransportVersion.registerTransportVersion(8500051, "a28b43bc-bb5f-4406-afcf-26900aa98a71");
    public static final TransportVersion V_8_500_052 = TransportVersion.registerTransportVersion(8500052, "2d382b3d-9838-4cce-84c8-4142113e5c2b");
    public static final TransportVersion V_8_500_053 = TransportVersion.registerTransportVersion(8500053, "aa603bae-01e2-380a-8950-6604468e8c6d");
    public static final TransportVersion V_8_500_054 = TransportVersion.registerTransportVersion(8500054, "b76ef950-af03-4dda-85c2-6400ec442e7e");
    public static final TransportVersion V_8_500_055 = TransportVersion.registerTransportVersion(8500055, "7831c609-0df1-42d6-aa97-8a346c389ef");
    public static final TransportVersion V_8_500_056 = TransportVersion.registerTransportVersion(8500056, "afa8c4be-29c9-48ab-b1ed-7182415c1b71");
    public static final TransportVersion V_8_500_057 = TransportVersion.registerTransportVersion(8500057, "80c088c6-358d-43b2-8d9c-1ea3c6c2b9fd");
    public static final TransportVersion V_8_500_058 = TransportVersion.registerTransportVersion(8500058, "41d9c98a-1de2-4dc1-86f1-abd4cc1bef57");
    public static final TransportVersion V_8_500_059 = TransportVersion.registerTransportVersion(8500059, "2f2090c0-7cd0-4a10-8f02-63d26073604f");
    public static final TransportVersion V_8_500_060 = TransportVersion.registerTransportVersion(8500060, "ec065a44-b468-4f8a-aded-7b90ca8d792b");
    public static final TransportVersion V_8_500_061 = TransportVersion.registerTransportVersion(8500061, "4e07f830-8be4-448c-851e-62b3d2f0bf0a");
    public static final TransportVersion MINIMUM_COMPATIBLE = V_7_17_0;
    public static final TransportVersion MINIMUM_CCS_VERSION = V_8_500_020;
    private static final NavigableMap<Integer, TransportVersion> VERSION_IDS;

    private static TransportVersion registerTransportVersion(int id, String uniqueId) {
        if (IDS == null) {
            throw new IllegalStateException("The IDS map needs to be present to call this method");
        }
        Strings.requireNonEmpty(uniqueId, "Each TransportVersion needs a unique string id");
        Integer existing = IDS.put(uniqueId, id);
        if (existing != null) {
            throw new IllegalArgumentException("Versions " + id + " and " + existing + " have the same unique id");
        }
        return new TransportVersion(id);
    }

    static NavigableMap<Integer, TransportVersion> getAllVersionIds(Class<?> cls) {
        HashMap<Integer, String> versionIdFields = new HashMap<Integer, String>();
        TreeMap<Integer, TransportVersion> builder = new TreeMap<Integer, TransportVersion>();
        Set<String> ignore = Set.of("ZERO", "CURRENT", "MINIMUM_COMPATIBLE", "MINIMUM_CCS_VERSION");
        for (Field declaredField : cls.getFields()) {
            TransportVersion version;
            String fieldName;
            if (!declaredField.getType().equals(TransportVersion.class) || ignore.contains(fieldName = declaredField.getName())) continue;
            try {
                version = (TransportVersion)declaredField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            builder.put(version.id, version);
            if (!Assertions.ENABLED) continue;
            String sameVersionNumber = versionIdFields.put(version.id, fieldName);
            assert (sameVersionNumber == null) : "Versions [" + sameVersionNumber + "] and [" + fieldName + "] have the same version number [" + version.id + "]. Each TransportVersion should have a different version number";
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    static Collection<TransportVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    public static TransportVersion readVersion(StreamInput in) throws IOException {
        return TransportVersion.fromId(in.readVInt());
    }

    public static TransportVersion fromId(int id) {
        TransportVersion known = (TransportVersion)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        return new TransportVersion(id);
    }

    public static void writeVersion(TransportVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransportVersion min(TransportVersion version1, TransportVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransportVersion max(TransportVersion version1, TransportVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static boolean isCompatible(TransportVersion version) {
        return version.onOrAfter(MINIMUM_COMPATIBLE);
    }

    public static TransportVersion current() {
        return CurrentHolder.CURRENT;
    }

    public static TransportVersion fromString(String str) {
        return TransportVersion.fromId(Integer.parseInt(str));
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    static {
        IDS = null;
        VERSION_IDS = TransportVersion.getAllVersionIds(TransportVersion.class);
    }

    private static class CurrentHolder {
        private static final TransportVersion CURRENT = CurrentHolder.findCurrent(V_8_500_061);

        private CurrentHolder() {
        }

        private static TransportVersion findCurrent(TransportVersion fallback) {
            VersionExtension versionExtension = VersionExtension.load();
            if (versionExtension == null) {
                return fallback;
            }
            TransportVersion version = versionExtension.getCurrentTransportVersion();
            assert (version.onOrAfter(fallback));
            return version;
        }
    }
}

