/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.plugins.cli.PluginDescriptor;
import org.elasticsearch.plugins.cli.PluginSyncException;
import org.elasticsearch.plugins.cli.ProxyUtils;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class PluginsConfig {
    private List<PluginDescriptor> plugins = List.of();
    private String proxy = null;

    public void setPlugins(List<PluginDescriptor> plugins) {
        this.plugins = plugins == null ? List.of() : plugins;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void validate(Set<String> officialPlugins, Set<String> migratedPlugins) throws PluginSyncException {
        if (this.plugins.stream().anyMatch(each -> each == null || Strings.isNullOrBlank((String)each.getId()))) {
            throw new RuntimeException("Cannot have null or empty IDs in [elasticsearch-plugins.yml]");
        }
        HashSet<String> uniquePluginIds = new HashSet<String>();
        for (PluginDescriptor plugin : this.plugins) {
            if (uniquePluginIds.add(plugin.getId())) continue;
            throw new PluginSyncException("Duplicate plugin ID [" + plugin.getId() + "] found in [elasticsearch-plugins.yml]");
        }
        for (PluginDescriptor plugin : this.plugins) {
            if (officialPlugins.contains(plugin.getId()) || migratedPlugins.contains(plugin.getId()) || plugin.getLocation() != null) continue;
            throw new PluginSyncException("Must specify location for non-official plugin [" + plugin.getId() + "] in [elasticsearch-plugins.yml]");
        }
        if (this.proxy != null) {
            String[] parts = this.proxy.split(":");
            if (parts.length != 2) {
                throw new PluginSyncException("Malformed [proxy], expected [host:port] in [elasticsearch-plugins.yml]");
            }
            if (!ProxyUtils.validateProxy(parts[0], parts[1])) {
                throw new PluginSyncException("Malformed [proxy], expected [host:port] in [elasticsearch-plugins.yml]");
            }
        }
        for (PluginDescriptor p : this.plugins) {
            if (p.getLocation() == null) continue;
            if (p.getLocation().isBlank()) {
                throw new PluginSyncException("Empty location for plugin [" + p.getId() + "]");
            }
            try {
                new URI(p.getLocation());
            }
            catch (URISyntaxException e) {
                throw new PluginSyncException("Malformed location for plugin [" + p.getId() + "]");
            }
        }
    }

    public List<PluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public String getProxy() {
        return this.proxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginsConfig that = (PluginsConfig)o;
        return this.plugins.equals(that.plugins) && Objects.equals(this.proxy, that.proxy);
    }

    public int hashCode() {
        return Objects.hash(this.plugins, this.proxy);
    }

    public String toString() {
        return "PluginsConfig{plugins=" + this.plugins + ", proxy='" + this.proxy + "'}";
    }

    static PluginsConfig parseConfig(Path configPath, XContent xContent) throws IOException {
        ObjectParser descriptorParser = new ObjectParser("descriptor parser", PluginDescriptor::new);
        descriptorParser.declareString(PluginDescriptor::setId, new ParseField("id", new String[0]));
        descriptorParser.declareStringOrNull(PluginDescriptor::setLocation, new ParseField("location", new String[0]));
        ObjectParser parser = new ObjectParser("plugins parser", PluginsConfig::new);
        parser.declareStringOrNull(PluginsConfig::setProxy, new ParseField("proxy", new String[0]));
        parser.declareObjectArrayOrNull(PluginsConfig::setPlugins, (ContextParser)descriptorParser, new ParseField("plugins", new String[0]));
        XContentParser yamlXContentParser = xContent.createParser(XContentParserConfiguration.EMPTY, Files.newInputStream(configPath, new OpenOption[0]));
        return (PluginsConfig)parser.parse(yamlXContentParser, null);
    }

    static void writeConfig(XContent xContent, PluginsConfig config, Path configPath) throws IOException {
        OutputStream outputStream = Files.newOutputStream(configPath, new OpenOption[0]);
        XContentBuilder builder = new XContentBuilder(xContent, outputStream);
        builder.startObject();
        builder.startArray("plugins");
        for (PluginDescriptor p : config.getPlugins()) {
            builder.startObject();
            builder.field("id", p.getId());
            builder.field("location", p.getLocation());
            builder.endObject();
        }
        builder.endArray();
        builder.field("proxy", config.getProxy());
        builder.endObject();
        builder.close();
        outputStream.close();
    }
}

