/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.cli.LoggingAwareMultiCommand;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.plugins.cli.InstallPluginCommand;
import org.elasticsearch.plugins.cli.ListPluginsCommand;
import org.elasticsearch.plugins.cli.RemovePluginCommand;

public class PluginCli
extends LoggingAwareMultiCommand {
    private final Collection<Command> commands;

    private PluginCli() {
        super("A tool for managing installed elasticsearch plugins");
        this.subcommands.put("list", new ListPluginsCommand());
        this.subcommands.put("install", new InstallPluginCommand());
        this.subcommands.put("remove", new RemovePluginCommand());
        this.commands = Collections.unmodifiableCollection(this.subcommands.values());
    }

    public static void main(String[] args) throws Exception {
        PluginCli.exit((int)new PluginCli().main(args, Terminal.DEFAULT));
    }

    public void close() throws IOException {
        IOUtils.close(this.commands);
    }
}

