/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.feature;

import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.UserDataIgnoreConverter;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class FeatureFactory {
    private final IUserDataConverter userDataIgnoreConverter = new UserDataIgnoreConverter();
    private final MvtLayerProps layerProps = new MvtLayerProps();
    private final JTSGeometryBuilder builder;
    private final org.locationtech.jts.geom.Geometry clipTile;
    private final CoordinateSequenceFilter sequenceFilter;
    private final double pixelPrecision;
    private static final int BUFFER_SIZE_PIXELS = 5;

    public FeatureFactory(int z, int x, int y, int extent) {
        this.pixelPrecision = 4.007501668E7 / (double)((1L << z) * (long)extent);
        Rectangle r = SphericalMercatorUtils.recToSphericalMercator((Rectangle)GeoTileUtils.toBoundingBox((int)x, (int)y, (int)z));
        Envelope tileEnvelope = new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY());
        Envelope clipEnvelope = new Envelope(tileEnvelope);
        clipEnvelope.expandBy(5.0 * this.pixelPrecision, 5.0 * this.pixelPrecision);
        GeometryFactory geomFactory = new GeometryFactory();
        this.builder = new JTSGeometryBuilder(geomFactory);
        this.clipTile = geomFactory.toGeometry(clipEnvelope);
        this.sequenceFilter = new MvtCoordinateSequenceFilter(tileEnvelope, extent);
    }

    public List<byte[]> getFeatures(Geometry geometry) {
        org.locationtech.jts.geom.Geometry jtsGeometry = (org.locationtech.jts.geom.Geometry)geometry.visit((GeometryVisitor)this.builder);
        List<org.locationtech.jts.geom.Geometry> flatGeometries = FeatureFactory.clipGeometries(this.clipTile.copy(), JtsAdapter.flatFeatureList((org.locationtech.jts.geom.Geometry)jtsGeometry));
        FeatureFactory.simplifyGeometry(flatGeometries, this.pixelPrecision);
        FeatureFactory.convertToMvtGeometry(flatGeometries, this.sequenceFilter);
        List features = JtsAdapter.toFeatures(flatGeometries, (MvtLayerProps)this.layerProps, (IUserDataConverter)this.userDataIgnoreConverter);
        ArrayList<byte[]> byteFeatures = new ArrayList<byte[]>(features.size());
        features.forEach(f -> byteFeatures.add(f.toByteArray()));
        return byteFeatures;
    }

    private static List<org.locationtech.jts.geom.Geometry> clipGeometries(org.locationtech.jts.geom.Geometry envelope, List<org.locationtech.jts.geom.Geometry> geometries) {
        ArrayList<org.locationtech.jts.geom.Geometry> intersected = new ArrayList<org.locationtech.jts.geom.Geometry>(geometries.size());
        for (org.locationtech.jts.geom.Geometry geometry : geometries) {
            try {
                IntersectionMatrix matrix = envelope.relate(geometry);
                if (matrix.isContains()) {
                    intersected.add(geometry);
                    continue;
                }
                if (matrix.isWithin()) {
                    intersected.add(envelope);
                    continue;
                }
                if (matrix.isIntersects()) {
                    intersected.add(envelope.intersection(geometry));
                    continue;
                }
                assert (envelope.intersection(geometry).isEmpty());
            }
            catch (TopologyException topologyException) {
            }
        }
        return intersected;
    }

    private static void simplifyGeometry(List<org.locationtech.jts.geom.Geometry> geometries, double precision) {
        for (int i = 0; i < geometries.size(); ++i) {
            geometries.set(i, TopologyPreservingSimplifier.simplify((org.locationtech.jts.geom.Geometry)geometries.get(i), (double)precision));
        }
    }

    private static void convertToMvtGeometry(List<org.locationtech.jts.geom.Geometry> geometries, CoordinateSequenceFilter sequenceFilter) {
        for (org.locationtech.jts.geom.Geometry geometry : geometries) {
            geometry.apply(sequenceFilter);
        }
    }

    private static class JTSGeometryBuilder
    implements GeometryVisitor<org.locationtech.jts.geom.Geometry, IllegalArgumentException> {
        private final GeometryFactory geomFactory;

        JTSGeometryBuilder(GeometryFactory geomFactory) {
            this.geomFactory = geomFactory;
        }

        public org.locationtech.jts.geom.Geometry visit(Circle circle) {
            throw new IllegalArgumentException("Circle is not supported");
        }

        public org.locationtech.jts.geom.Geometry visit(GeometryCollection<?> collection) {
            org.locationtech.jts.geom.Geometry[] geometries = new org.locationtech.jts.geom.Geometry[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                geometries[i] = (org.locationtech.jts.geom.Geometry)collection.get(i).visit((GeometryVisitor)this);
            }
            return this.geomFactory.createGeometryCollection(geometries);
        }

        public org.locationtech.jts.geom.Geometry visit(LinearRing ring) throws RuntimeException {
            throw new IllegalArgumentException("LinearRing is not supported");
        }

        public org.locationtech.jts.geom.Geometry visit(org.elasticsearch.geometry.Point point) throws RuntimeException {
            return this.buildPoint(point);
        }

        public org.locationtech.jts.geom.Geometry visit(MultiPoint multiPoint) throws RuntimeException {
            Point[] points = new Point[multiPoint.size()];
            for (int i = 0; i < multiPoint.size(); ++i) {
                points[i] = this.buildPoint((org.elasticsearch.geometry.Point)multiPoint.get(i));
            }
            Arrays.sort(points, Comparator.comparingDouble(Point::getX).thenComparingDouble(Point::getY));
            return this.geomFactory.createMultiPoint(points);
        }

        private Point buildPoint(org.elasticsearch.geometry.Point point) {
            double x = SphericalMercatorUtils.lonToSphericalMercator((double)point.getX());
            double y = SphericalMercatorUtils.latToSphericalMercator((double)point.getY());
            return this.geomFactory.createPoint(new Coordinate(x, y));
        }

        public org.locationtech.jts.geom.Geometry visit(Line line) {
            return this.buildLine(line);
        }

        public org.locationtech.jts.geom.Geometry visit(MultiLine multiLine) throws RuntimeException {
            LineString[] lineStrings = new LineString[multiLine.size()];
            for (int i = 0; i < multiLine.size(); ++i) {
                lineStrings[i] = this.buildLine((Line)multiLine.get(i));
            }
            return this.geomFactory.createMultiLineString(lineStrings);
        }

        private LineString buildLine(Line line) {
            Coordinate[] coordinates = new Coordinate[line.length()];
            for (int i = 0; i < line.length(); ++i) {
                double x = SphericalMercatorUtils.lonToSphericalMercator((double)line.getX(i));
                double y = SphericalMercatorUtils.latToSphericalMercator((double)line.getY(i));
                coordinates[i] = new Coordinate(x, y);
            }
            return this.geomFactory.createLineString(coordinates);
        }

        public org.locationtech.jts.geom.Geometry visit(org.elasticsearch.geometry.Polygon polygon) throws RuntimeException {
            return this.buildPolygon(polygon);
        }

        public org.locationtech.jts.geom.Geometry visit(MultiPolygon multiPolygon) throws RuntimeException {
            Polygon[] polygons = new Polygon[multiPolygon.size()];
            for (int i = 0; i < multiPolygon.size(); ++i) {
                polygons[i] = this.buildPolygon((org.elasticsearch.geometry.Polygon)multiPolygon.get(i));
            }
            return this.geomFactory.createMultiPolygon(polygons);
        }

        private Polygon buildPolygon(org.elasticsearch.geometry.Polygon polygon) {
            org.locationtech.jts.geom.LinearRing outerShell = this.buildLinearRing(polygon.getPolygon());
            if (polygon.getNumberOfHoles() == 0) {
                return this.geomFactory.createPolygon(outerShell);
            }
            org.locationtech.jts.geom.LinearRing[] holes = new org.locationtech.jts.geom.LinearRing[polygon.getNumberOfHoles()];
            for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                holes[i] = this.buildLinearRing(polygon.getHole(i));
            }
            return this.geomFactory.createPolygon(outerShell, holes);
        }

        private org.locationtech.jts.geom.LinearRing buildLinearRing(LinearRing ring) throws RuntimeException {
            Coordinate[] coordinates = new Coordinate[ring.length()];
            for (int i = 0; i < ring.length(); ++i) {
                double x = SphericalMercatorUtils.lonToSphericalMercator((double)ring.getX(i));
                double y = SphericalMercatorUtils.latToSphericalMercator((double)ring.getY(i));
                coordinates[i] = new Coordinate(x, y);
            }
            return this.geomFactory.createLinearRing(coordinates);
        }

        public org.locationtech.jts.geom.Geometry visit(Rectangle rectangle) throws RuntimeException {
            double xMin = SphericalMercatorUtils.lonToSphericalMercator((double)rectangle.getMinX());
            double yMin = SphericalMercatorUtils.latToSphericalMercator((double)rectangle.getMinY());
            double xMax = SphericalMercatorUtils.lonToSphericalMercator((double)rectangle.getMaxX());
            double yMax = SphericalMercatorUtils.latToSphericalMercator((double)rectangle.getMaxY());
            Envelope envelope = new Envelope(xMin, xMax, yMin, yMax);
            return this.geomFactory.toGeometry(envelope);
        }
    }

    private static class MvtCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private final int extent;
        private final double pointXScale;
        private final double pointYScale;
        private final double pointXTranslate;
        private final double pointYTranslate;

        private MvtCoordinateSequenceFilter(Envelope tileEnvelope, int extent) {
            this.extent = extent;
            this.pointXScale = (double)extent / tileEnvelope.getWidth();
            this.pointYScale = (double)(-extent) / tileEnvelope.getHeight();
            this.pointXTranslate = -this.pointXScale * tileEnvelope.getMinX();
            this.pointYTranslate = -this.pointYScale * tileEnvelope.getMinY();
        }

        public void filter(CoordinateSequence seq, int i) {
            seq.setOrdinate(i, 0, (double)this.lon(seq.getOrdinate(i, 0)));
            seq.setOrdinate(i, 1, (double)this.lat(seq.getOrdinate(i, 1)));
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        private int lat(double lat) {
            return (int)Math.round(this.pointYScale * lat + this.pointYTranslate) + this.extent;
        }

        private int lon(double lon) {
            return (int)Math.round(this.pointXScale * lon + this.pointXTranslate);
        }
    }
}

