/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequestBuilder;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.TimeoutUtils;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryMonitoringDoc;

public class IndexRecoveryCollector
extends Collector {
    public static final Setting<TimeValue> INDEX_RECOVERY_TIMEOUT = IndexRecoveryCollector.collectionTimeoutSetting("index.recovery.timeout");
    public static final Setting<Boolean> INDEX_RECOVERY_ACTIVE_ONLY = Setting.boolSetting((String)IndexRecoveryCollector.collectionSetting("index.recovery.active_only"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});
    private final Client client;

    public IndexRecoveryCollector(ClusterService clusterService, XPackLicenseState licenseState, Client client) {
        super("index_recovery", clusterService, INDEX_RECOVERY_TIMEOUT, licenseState);
        this.client = Objects.requireNonNull(client);
    }

    boolean getActiveRecoveriesOnly() {
        return (Boolean)this.clusterService.getClusterSettings().get(INDEX_RECOVERY_ACTIVE_ONLY);
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) {
        ArrayList<IndexRecoveryMonitoringDoc> results = new ArrayList<IndexRecoveryMonitoringDoc>(1);
        RecoveryResponse recoveryResponse = (RecoveryResponse)((RecoveryRequestBuilder)((RecoveryRequestBuilder)((RecoveryRequestBuilder)this.client.admin().indices().prepareRecoveries(new String[0]).setIndices(this.getCollectionIndices())).setIndicesOptions(IndicesOptions.lenientExpandOpen())).setActiveOnly(this.getActiveRecoveriesOnly()).setTimeout(this.getCollectionTimeout())).get();
        TimeoutUtils.ensureNoTimeouts(this.getCollectionTimeout(), (BroadcastResponse)recoveryResponse);
        if (recoveryResponse.hasRecoveries()) {
            String clusterUuid = IndexRecoveryCollector.clusterUuid(clusterState);
            results.add(new IndexRecoveryMonitoringDoc(clusterUuid, IndexRecoveryCollector.timestamp(), interval, node, recoveryResponse));
        }
        return Collections.unmodifiableCollection(results);
    }
}

