/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.v2;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.RollupIndexerAction;
import org.elasticsearch.xpack.rollup.v2.RollupShardIndexer;

public class TransportRollupIndexerAction
extends TransportBroadcastAction<RollupIndexerAction.Request, RollupIndexerAction.Response, RollupIndexerAction.ShardRequest, RollupIndexerAction.ShardResponse> {
    private static final int SORTER_RAM_SIZE_MB = 100;
    private final Client client;
    private final ClusterService clusterService;
    private final IndicesService indicesService;

    @Inject
    public TransportRollupIndexerAction(Client client, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/xpack/rollup_indexer", clusterService, transportService, actionFilters, indexNameExpressionResolver, RollupIndexerAction.Request::new, RollupIndexerAction.ShardRequest::new, "rollup_indexing");
        this.client = new OriginSettingClient(client, "rollup");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    protected GroupShardsIterator<ShardIterator> shards(ClusterState clusterState, RollupIndexerAction.Request request, String[] concreteIndices) {
        if (concreteIndices.length > 1) {
            throw new IllegalArgumentException("multiple indices: " + Arrays.toString(concreteIndices));
        }
        String routing = Integer.toString(Randomness.get().nextInt(1000));
        Map routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, routing, request.indices());
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, null);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, RollupIndexerAction.Request request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, RollupIndexerAction.Request request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    protected void doExecute(Task task, RollupIndexerAction.Request request, ActionListener<RollupIndexerAction.Response> listener) {
        new Async(task, request, listener).start();
    }

    protected RollupIndexerAction.ShardRequest newShardRequest(int numShards, ShardRouting shard, RollupIndexerAction.Request request) {
        return new RollupIndexerAction.ShardRequest(shard.shardId(), request);
    }

    protected RollupIndexerAction.ShardResponse shardOperation(RollupIndexerAction.ShardRequest request, Task task) throws IOException {
        IndexService indexService = this.indicesService.indexService(request.shardId().getIndex());
        String tmpIndexName = ".rolluptmp-" + request.getRollupIndex();
        RollupShardIndexer indexer = new RollupShardIndexer(this.client, indexService, request.shardId(), request.getRollupConfig(), tmpIndexName, 100);
        indexer.execute();
        return new RollupIndexerAction.ShardResponse(request.shardId());
    }

    protected RollupIndexerAction.ShardResponse readShardResponse(StreamInput in) throws IOException {
        return new RollupIndexerAction.ShardResponse(in);
    }

    protected RollupIndexerAction.Response newResponse(RollupIndexerAction.Request request, AtomicReferenceArray<?> shardsResponses, ClusterState clusterState) {
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                throw new ElasticsearchException("missing shard", new Object[0]);
            }
            if (!(shardResponse instanceof Exception)) continue;
            throw new ElasticsearchException((Throwable)((Exception)shardResponse));
        }
        return new RollupIndexerAction.Response(true);
    }

    private class Async
    extends TransportBroadcastAction.AsyncBroadcastAction {
        private final RollupIndexerAction.Request request;
        private final ActionListener<RollupIndexerAction.Response> listener;

        protected Async(Task task, RollupIndexerAction.Request request, ActionListener<RollupIndexerAction.Response> listener) {
            super((TransportBroadcastAction)TransportRollupIndexerAction.this, task, (BroadcastRequest)request, listener);
            this.request = request;
            this.listener = listener;
        }

        protected void finishHim() {
            try {
                RollupIndexerAction.Response resp = TransportRollupIndexerAction.this.newResponse(this.request, this.shardsResponses, TransportRollupIndexerAction.this.clusterService.state());
                this.listener.onResponse((Object)resp);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }
    }
}

