/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.rollup.RollupActionConfig;
import org.elasticsearch.xpack.core.rollup.RollupActionDateHistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.RollupActionGroupConfig;
import org.elasticsearch.xpack.core.rollup.action.RollupAction;
import org.elasticsearch.xpack.core.rollup.action.RollupActionRequestValidationException;
import org.elasticsearch.xpack.core.rollup.action.RollupIndexerAction;
import org.elasticsearch.xpack.core.rollup.job.HistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;
import org.elasticsearch.xpack.rollup.v2.FieldMetricsProducer;

public class TransportRollupAction
extends AcknowledgedTransportMasterNodeAction<RollupAction.Request> {
    private static final Settings VISIBLE_INDEX_SETTINGS = Settings.builder().put("index.hidden", false).build();
    private static final Settings WRITE_BLOCKED_SETTINGS = Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true).build();
    private final Client client;
    private final ClusterService clusterService;
    private final MetadataCreateIndexService metadataCreateIndexService;

    @Inject
    public TransportRollupAction(Client client, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, MetadataCreateIndexService metadataCreateIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/xpack/rollup", transportService, clusterService, threadPool, actionFilters, RollupAction.Request::new, indexNameExpressionResolver, "same");
        this.client = new OriginSettingClient(client, "rollup");
        this.clusterService = clusterService;
        this.metadataCreateIndexService = metadataCreateIndexService;
    }

    protected void masterOperation(Task task, RollupAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws IOException {
        XContentBuilder mapping;
        String originalIndexName = request.getSourceIndex();
        Object rollupIndexName = request.getRollupIndex() == null ? "rollup-" + originalIndexName + "-" + UUIDs.randomBase64UUID((Random)Randomness.get()) : request.getRollupIndex();
        String tmpIndexName = ".rolluptmp-" + (String)rollupIndexName;
        try {
            mapping = this.getMapping(request.getRollupConfig());
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        FieldCapabilitiesRequest fieldCapsRequest = new FieldCapabilitiesRequest().indices(new String[]{originalIndexName}).fields(request.getRollupConfig().getAllFields().toArray(new String[0]));
        fieldCapsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        IndexMetadata originalIndexMetadata = state.getMetadata().index(originalIndexName);
        String sourceIndexName = IndexMetadata.INDEX_ROLLUP_SOURCE_NAME.exists(originalIndexMetadata.getSettings()) ? (String)IndexMetadata.INDEX_ROLLUP_SOURCE_NAME.get(originalIndexMetadata.getSettings()) : originalIndexName;
        String sourceIndexUuid = IndexMetadata.INDEX_ROLLUP_SOURCE_UUID.exists(originalIndexMetadata.getSettings()) ? (String)IndexMetadata.INDEX_ROLLUP_SOURCE_UUID.get(originalIndexMetadata.getSettings()) : originalIndexMetadata.getIndexUUID();
        CreateIndexClusterStateUpdateRequest createIndexClusterStateUpdateRequest = new CreateIndexClusterStateUpdateRequest("rollup", tmpIndexName, tmpIndexName).settings(MetadataRolloverService.HIDDEN_INDEX_SETTINGS).mappings(XContentHelper.convertToJson((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)XContentType.JSON));
        RollupIndexerAction.Request rollupIndexerRequest = new RollupIndexerAction.Request(request);
        ResizeRequest resizeRequest = new ResizeRequest(request.getRollupIndex(), tmpIndexName);
        resizeRequest.setResizeType(ResizeType.CLONE);
        resizeRequest.getTargetIndexRequest().settings(VISIBLE_INDEX_SETTINGS);
        UpdateSettingsRequest updateSettingsReq = new UpdateSettingsRequest(WRITE_BLOCKED_SETTINGS, new String[]{tmpIndexName});
        this.client.fieldCaps(fieldCapsRequest, ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(originalIndexName, listener, request, createIndexClusterStateUpdateRequest, sourceIndexName, sourceIndexUuid, rollupIndexerRequest, updateSettingsReq, resizeRequest, tmpIndexName, (String)rollupIndexName, arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(RollupAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private XContentBuilder getMapping(RollupActionConfig config) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder = TransportRollupAction.getDynamicTemplates(builder);
        builder = TransportRollupAction.getProperties(builder, config);
        return builder.endObject();
    }

    private static XContentBuilder getDynamicTemplates(XContentBuilder builder) throws IOException {
        return builder.startArray("dynamic_templates").startObject().startObject("strings").field("match_mapping_type", "string").startObject("mapping").field("type", "keyword").endObject().endObject().endObject().endArray();
    }

    private static XContentBuilder getProperties(XContentBuilder builder, RollupActionConfig config) throws IOException {
        builder.startObject("properties");
        RollupActionGroupConfig groupConfig = config.getGroupConfig();
        RollupActionDateHistogramGroupConfig dateHistogramConfig = groupConfig.getDateHistogram();
        String dateField = dateHistogramConfig.getField();
        String dateIntervalType = dateHistogramConfig.getIntervalTypeName();
        String dateInterval = dateHistogramConfig.getInterval().toString();
        String tz = dateHistogramConfig.getTimeZone() != null ? dateHistogramConfig.getTimeZone() : RollupActionDateHistogramGroupConfig.DEFAULT_TIMEZONE;
        builder.startObject(dateField).field("type", "date").startObject("meta").field(dateIntervalType, dateInterval).field("time_zone", tz).endObject().endObject();
        HistogramGroupConfig histogramGroupConfig = groupConfig.getHistogram();
        if (histogramGroupConfig != null) {
            for (String field : histogramGroupConfig.getFields()) {
                builder.startObject(field).field("type", NumberFieldMapper.NumberType.DOUBLE.typeName()).startObject("meta").field("interval", String.valueOf(histogramGroupConfig.getInterval())).endObject().endObject();
            }
        }
        List metricConfigs = config.getMetricsConfig();
        for (MetricConfig metricConfig : metricConfigs) {
            List<String> metrics = FieldMetricsProducer.normalizeMetrics(metricConfig.getMetrics());
            String defaultMetric = metrics.contains("value_count") ? "value_count" : metrics.get(0);
            builder.startObject(metricConfig.getField()).field("type", "aggregate_metric_double").stringListField("metrics", metrics).field("default_metric", defaultMetric).endObject();
        }
        return builder.endObject();
    }

    private void publishMetadata(final String originalIndexName, final String tmpIndexName, final String rollupIndexName, final ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-rollup-metadata", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, null);
            }

            public ClusterState execute(ClusterState currentState) {
                IndexMetadata rollupIndexMetadata = currentState.getMetadata().index(rollupIndexName);
                Index rollupIndex = rollupIndexMetadata.getIndex();
                IndexAbstraction originalIndex = (IndexAbstraction)currentState.getMetadata().getIndicesLookup().get(originalIndexName);
                Metadata.Builder metadataBuilder = Metadata.builder((Metadata)currentState.metadata());
                if (originalIndex.getParentDataStream() != null) {
                    DataStream originalDataStream = originalIndex.getParentDataStream().getDataStream();
                    ArrayList<Index> backingIndices = new ArrayList<Index>(originalDataStream.getIndices().size() + 1);
                    backingIndices.add(rollupIndex);
                    backingIndices.addAll(originalDataStream.getIndices());
                    DataStream dataStream = new DataStream(originalDataStream.getName(), originalDataStream.getTimeStampField(), backingIndices, originalDataStream.getGeneration(), originalDataStream.getMetadata(), originalDataStream.isHidden(), originalDataStream.isReplicated(), originalDataStream.isSystem(), originalDataStream.isAllowCustomRouting(), originalDataStream.getIndexMode());
                    metadataBuilder.put(dataStream);
                }
                return ClusterState.builder((ClusterState)currentState).metadata(metadataBuilder.build()).build();
            }

            public void onFailure(Exception e) {
                TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)new ElasticsearchException("failed to publish new cluster state with rollup metadata", (Throwable)e, new Object[0]));
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    private void deleteTmpIndex(final String originalIndex, final String tmpIndex, final ActionListener<AcknowledgedResponse> listener, final Exception e) {
        this.client.admin().indices().delete(new DeleteIndexRequest(tmpIndex), (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                if (e == null && acknowledgedResponse.isAcknowledged()) {
                    listener.onResponse((Object)acknowledgedResponse);
                } else {
                    listener.onFailure((Exception)new ElasticsearchException("Unable to rollup index [" + originalIndex + "]", (Throwable)e, new Object[0]));
                }
            }

            public void onFailure(Exception deleteException) {
                listener.onFailure((Exception)new ElasticsearchException("Unable to delete temp rollup index [" + tmpIndex + "]", (Throwable)e, new Object[0]));
            }
        });
    }

    private /* synthetic */ void lambda$masterOperation$0(final String originalIndexName, final ActionListener listener, RollupAction.Request request, final CreateIndexClusterStateUpdateRequest createIndexClusterStateUpdateRequest, final String sourceIndexName, final String sourceIndexUuid, final RollupIndexerAction.Request rollupIndexerRequest, final UpdateSettingsRequest updateSettingsReq, final ResizeRequest resizeRequest, final String tmpIndexName, final String rollupIndexName, FieldCapabilitiesResponse fieldCapsResponse) throws Exception {
        RollupActionRequestValidationException validationException = new RollupActionRequestValidationException();
        if (fieldCapsResponse.get().size() == 0) {
            validationException.addValidationError("Could not find any fields in the index [" + originalIndexName + "] that were configured in job");
            listener.onFailure((Exception)validationException);
            return;
        }
        request.getRollupConfig().validateMappings(fieldCapsResponse.get(), (ActionRequestValidationException)validationException);
        if (validationException.validationErrors().size() > 0) {
            listener.onFailure((Exception)validationException);
            return;
        }
        this.clusterService.submitStateUpdateTask("rollup create index", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                return TransportRollupAction.this.metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexClusterStateUpdateRequest, true, (builder, indexMetadata) -> builder.put(IndexMetadata.builder((IndexMetadata)indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put(IndexMetadata.INDEX_ROLLUP_SOURCE_NAME.getKey(), sourceIndexName).put(IndexMetadata.INDEX_ROLLUP_SOURCE_UUID.getKey(), sourceIndexUuid))));
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                TransportRollupAction.this.client.execute((ActionType)RollupIndexerAction.INSTANCE, (ActionRequest)rollupIndexerRequest, ActionListener.wrap(indexerResp -> {
                    if (indexerResp.isCreated()) {
                        TransportRollupAction.this.client.admin().indices().updateSettings(updateSettingsReq, ActionListener.wrap(updateSettingsResponse -> {
                            if (updateSettingsResponse.isAcknowledged()) {
                                TransportRollupAction.this.client.admin().indices().resizeIndex(resizeRequest, ActionListener.wrap(resizeResponse -> {
                                    if (resizeResponse.isAcknowledged()) {
                                        TransportRollupAction.this.publishMetadata(originalIndexName, tmpIndexName, rollupIndexName, (ActionListener<AcknowledgedResponse>)listener);
                                    } else {
                                        TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)new ElasticsearchException("Unable to resize temp rollup index [" + tmpIndexName + "]", new Object[0]));
                                    }
                                }, e -> TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)e)));
                            } else {
                                TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)new ElasticsearchException("Unable to update settings of temp rollup index [" + tmpIndexName + "]", new Object[0]));
                            }
                        }, e -> TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)e)));
                    } else {
                        TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)new ElasticsearchException("Unable to index into temp rollup index [" + tmpIndexName + "]", new Object[0]));
                    }
                }, e -> TransportRollupAction.this.deleteTmpIndex(originalIndexName, tmpIndexName, (ActionListener<AcknowledgedResponse>)listener, (Exception)e)));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, ClusterStateTaskExecutor.unbatched());
    }
}

