/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.rest;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.action.RollupSearchAction;

public class RestRollupSearchAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Set.of("typed_keys", "rest_total_hits_as_int");

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_rollup_search"), new RestHandler.Route(RestRequest.Method.POST, "_rollup_search"), new RestHandler.Route(RestRequest.Method.GET, "{index}/_rollup_search"), new RestHandler.Route(RestRequest.Method.POST, "{index}/_rollup_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        restRequest.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)restRequest, (XContentParser)parser, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), size -> searchRequest.source().size(size)));
        RestSearchAction.checkRestTotalHits((RestRequest)restRequest, (SearchRequest)searchRequest);
        return channel -> client.execute((ActionType)RollupSearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "rollup_search_action";
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

