/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.idp.action.PutSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.action.PutSamlServiceProviderRequest;
import org.elasticsearch.xpack.idp.action.PutSamlServiceProviderResponse;
import org.elasticsearch.xpack.idp.saml.rest.action.IdpBaseRestHandler;

public class RestPutSamlServiceProviderAction
extends IdpBaseRestHandler {
    public RestPutSamlServiceProviderAction(XPackLicenseState licenseState) {
        super(licenseState);
    }

    public String getName() {
        return "idp_put_saml_sp_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_idp/saml/sp/{sp_entity_id}"), new RestHandler.Route(RestRequest.Method.POST, "/_idp/saml/sp/{sp_entity_id}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(final RestRequest restRequest, NodeClient client) throws IOException {
        String entityId = restRequest.param("sp_entity_id");
        WriteRequest.RefreshPolicy refreshPolicy = restRequest.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)restRequest.param("refresh")) : PutSamlServiceProviderRequest.DEFAULT_REFRESH_POLICY;
        try (XContentParser parser = restRequest.contentParser();){
            PutSamlServiceProviderRequest request = PutSamlServiceProviderRequest.fromXContent(entityId, refreshPolicy, parser);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)PutSamlServiceProviderAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestBuilderListener<PutSamlServiceProviderResponse>(channel){

                public RestResponse buildResponse(PutSamlServiceProviderResponse response, XContentBuilder builder) throws Exception {
                    response.toXContent(builder, (ToXContent.Params)restRequest);
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }
}

