/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.authn;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.idp.authc.AuthenticationMethod;
import org.elasticsearch.xpack.idp.authc.NetworkControl;
import org.elasticsearch.xpack.idp.saml.authn.UserServiceAuthentication;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;
import org.elasticsearch.xpack.idp.saml.support.SamlObjectSigner;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.xmlsec.signature.SignableXMLObject;

public class SuccessfulAuthenticationResponseMessageBuilder {
    private final Logger logger = LogManager.getLogger();
    private final Clock clock;
    private final SamlIdentityProvider idp;
    private final SamlFactory samlFactory;

    public SuccessfulAuthenticationResponseMessageBuilder(SamlFactory samlFactory, Clock clock, SamlIdentityProvider idp) {
        SamlInit.initialize();
        this.samlFactory = samlFactory;
        this.clock = clock;
        this.idp = idp;
    }

    public Response build(UserServiceAuthentication user, @Nullable SamlAuthenticationState authnState) {
        this.logger.debug("Building success response for [{}] from [{}]", (Object)user, (Object)authnState);
        Instant now = this.clock.instant();
        SamlServiceProvider serviceProvider = user.getServiceProvider();
        Response response = this.samlFactory.object(Response.class, Response.DEFAULT_ELEMENT_NAME);
        response.setID(this.samlFactory.secureIdentifier());
        if (authnState != null && authnState.getAuthnRequestId() != null) {
            response.setInResponseTo(authnState.getAuthnRequestId());
        }
        response.setIssuer(this.buildIssuer());
        response.setIssueInstant(now);
        response.setStatus(this.buildStatus());
        response.setDestination(serviceProvider.getAssertionConsumerService().toString());
        Assertion assertion = this.samlFactory.object(Assertion.class, Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setID(this.samlFactory.secureIdentifier());
        assertion.setIssuer(this.buildIssuer());
        assertion.setIssueInstant(now);
        assertion.setConditions(this.buildConditions(now, serviceProvider));
        assertion.setSubject(this.buildSubject(now, user, authnState));
        assertion.getAuthnStatements().add(this.buildAuthnStatement(now, user));
        AttributeStatement attributes = this.buildAttributes(user);
        if (attributes != null) {
            assertion.getAttributeStatements().add(attributes);
        }
        response.getAssertions().add(assertion);
        return this.sign(response);
    }

    private Response sign(Response response) {
        SamlObjectSigner signer = new SamlObjectSigner(this.samlFactory, this.idp);
        return this.samlFactory.buildXmlObject(signer.sign((SignableXMLObject)response), Response.class);
    }

    private Conditions buildConditions(Instant now, SamlServiceProvider serviceProvider) {
        Audience spAudience = this.samlFactory.object(Audience.class, Audience.DEFAULT_ELEMENT_NAME);
        spAudience.setURI(serviceProvider.getEntityId());
        AudienceRestriction restriction = this.samlFactory.object(AudienceRestriction.class, AudienceRestriction.DEFAULT_ELEMENT_NAME);
        restriction.getAudiences().add(spAudience);
        Conditions conditions = this.samlFactory.object(Conditions.class, Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(now);
        conditions.setNotOnOrAfter(now.plus(serviceProvider.getAuthnExpiry()));
        conditions.getAudienceRestrictions().add(restriction);
        return conditions;
    }

    private Subject buildSubject(Instant now, UserServiceAuthentication user, SamlAuthenticationState authnState) {
        SamlServiceProvider serviceProvider = user.getServiceProvider();
        NameID nameID = this.buildNameId(user, authnState);
        Subject subject = this.samlFactory.object(Subject.class, Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameID(nameID);
        SubjectConfirmationData data = this.samlFactory.object(SubjectConfirmationData.class, SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        if (authnState != null && authnState.getAuthnRequestId() != null) {
            data.setInResponseTo(authnState.getAuthnRequestId());
        }
        data.setNotBefore(now);
        data.setNotOnOrAfter(now.plus(serviceProvider.getAuthnExpiry()));
        data.setRecipient(serviceProvider.getAssertionConsumerService().toString());
        SubjectConfirmation confirmation = this.samlFactory.object(SubjectConfirmation.class, SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        confirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        confirmation.setSubjectConfirmationData(data);
        subject.getSubjectConfirmations().add(confirmation);
        return subject;
    }

    private AuthnStatement buildAuthnStatement(Instant now, UserServiceAuthentication user) {
        SamlServiceProvider serviceProvider = user.getServiceProvider();
        AuthnStatement statement = this.samlFactory.object(AuthnStatement.class, AuthnStatement.DEFAULT_ELEMENT_NAME);
        statement.setAuthnInstant(now);
        statement.setSessionNotOnOrAfter(now.plus(serviceProvider.getAuthnExpiry()));
        AuthnContext context = this.samlFactory.object(AuthnContext.class, AuthnContext.DEFAULT_ELEMENT_NAME);
        AuthnContextClassRef classRef = this.samlFactory.object(AuthnContextClassRef.class, AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        classRef.setURI(this.resolveAuthnClass(user.getAuthenticationMethods(), user.getNetworkControls()));
        context.setAuthnContextClassRef(classRef);
        statement.setAuthnContext(context);
        return statement;
    }

    private String resolveAuthnClass(Set<AuthenticationMethod> authenticationMethods, Set<NetworkControl> networkControls) {
        if (authenticationMethods.contains((Object)AuthenticationMethod.PASSWORD)) {
            if (networkControls.contains((Object)NetworkControl.IP_FILTER)) {
                return "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocolPassword";
            }
            if (networkControls.contains((Object)NetworkControl.TLS)) {
                return "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            }
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
        }
        if (authenticationMethods.contains((Object)AuthenticationMethod.KERBEROS)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos";
        }
        if (authenticationMethods.contains((Object)AuthenticationMethod.TLS_CLIENT_AUTH) && networkControls.contains((Object)NetworkControl.TLS)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient";
        }
        if (authenticationMethods.contains((Object)AuthenticationMethod.PRIOR_SESSION)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession";
        }
        if (networkControls.contains((Object)NetworkControl.IP_FILTER)) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol";
        }
        return "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified";
    }

    private AttributeStatement buildAttributes(UserServiceAuthentication user) {
        Attribute name;
        Attribute email;
        Attribute principal;
        SamlServiceProvider serviceProvider = user.getServiceProvider();
        AttributeStatement statement = this.samlFactory.object(AttributeStatement.class, AttributeStatement.DEFAULT_ELEMENT_NAME);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute roles = this.buildAttribute(serviceProvider.getAttributeNames().roles, "roles", user.getRoles());
        if (roles != null) {
            attributes.add(roles);
        }
        if ((principal = this.buildAttribute(serviceProvider.getAttributeNames().principal, "principal", user.getPrincipal())) != null) {
            attributes.add(principal);
        }
        if ((email = this.buildAttribute(serviceProvider.getAttributeNames().email, "email", user.getEmail())) != null) {
            attributes.add(email);
        }
        if ((name = this.buildAttribute(serviceProvider.getAttributeNames().name, "name", user.getName())) != null) {
            attributes.add(name);
        }
        if (attributes.isEmpty()) {
            return null;
        }
        statement.getAttributes().addAll(attributes);
        return statement;
    }

    private Attribute buildAttribute(String formalName, String friendlyName, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return this.buildAttribute(formalName, friendlyName, List.of(value));
    }

    private Attribute buildAttribute(String formalName, String friendlyName, Collection<String> values) {
        if (values.isEmpty() || Strings.isNullOrEmpty((String)formalName)) {
            return null;
        }
        Attribute attribute = this.samlFactory.object(Attribute.class, Attribute.DEFAULT_ELEMENT_NAME);
        attribute.setName(formalName);
        attribute.setFriendlyName(friendlyName);
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        for (String val : values) {
            XSString string = this.samlFactory.object(XSString.class, AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            string.setValue(val);
            attribute.getAttributeValues().add(string);
        }
        return attribute;
    }

    private Issuer buildIssuer() {
        Issuer issuer = this.samlFactory.object(Issuer.class, Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.idp.getEntityId());
        return issuer;
    }

    private Status buildStatus() {
        StatusCode code = this.samlFactory.object(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        code.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        Status status = this.samlFactory.object(Status.class, Status.DEFAULT_ELEMENT_NAME);
        status.setStatusCode(code);
        return status;
    }

    private NameID buildNameId(UserServiceAuthentication user, @Nullable SamlAuthenticationState authnState) {
        SamlServiceProvider serviceProvider = user.getServiceProvider();
        NameID nameID = this.samlFactory.object(NameID.class, NameID.DEFAULT_ELEMENT_NAME);
        String nameIdFormat = authnState != null && authnState.getRequestedNameidFormat() != null ? authnState.getRequestedNameidFormat() : (serviceProvider.getAllowedNameIdFormat() != null ? serviceProvider.getAllowedNameIdFormat() : this.idp.getServiceProviderDefaults().nameIdFormat);
        nameID.setFormat(nameIdFormat);
        nameID.setValue(this.getNameIdValueForFormat(nameIdFormat, user));
        return nameID;
    }

    private String getNameIdValueForFormat(String format, UserServiceAuthentication user) {
        switch (format) {
            case "urn:oasis:names:tc:SAML:2.0:nameid-format:transient": {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported NameID Format: " + format);
            }
        }
        return this.samlFactory.secureIdentifier();
    }
}

