/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ql.tree.Location;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.sql.SqlClientException;

public class FoldingException
extends SqlClientException {
    private final int line;
    private final int column;

    public FoldingException(Node<?> source, String message, Object ... args) {
        super(message, args);
        Location loc = Location.EMPTY;
        if (source != null && source.source() != null) {
            loc = source.source().source();
        }
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public FoldingException(Node<?> source, String message, Throwable cause) {
        super(message, cause);
        Location loc = Location.EMPTY;
        if (source != null && source.source() != null) {
            loc = source.source().source();
        }
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public String getMessage() {
        return LoggerMessageFormat.format((String)"line {}:{}: {}", (Object[])new Object[]{this.getLineNumber(), this.getColumnNumber(), super.getMessage()});
    }
}

