/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.UnresolvedAlias;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Range;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.ql.expression.predicate.regex.Like;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RLike;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.expression.Exists;
import org.elasticsearch.xpack.sql.expression.ScalarSubquery;
import org.elasticsearch.xpack.sql.expression.function.SqlFunctionResolution;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.literal.interval.Interval;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalYearMonth;
import org.elasticsearch.xpack.sql.expression.literal.interval.Intervals;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.sql.parser.IdentifierBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

abstract class ExpressionBuilder
extends IdentifierBuilder {
    private final Map<Token, SqlTypedParamValue> params;
    private final ZoneId zoneId;

    ExpressionBuilder(Map<Token, SqlTypedParamValue> params, ZoneId zoneId) {
        this.params = params;
        this.zoneId = zoneId;
    }

    protected Expression expression(ParseTree ctx) {
        return (Expression)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx, Expression.class);
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return ParserUtils.visitList((ParseTreeVisitor)this, contexts, Expression.class);
    }

    @Override
    public Expression visitSingleExpression(SqlBaseParser.SingleExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Expression visitSelectExpression(SqlBaseParser.SelectExpressionContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.expression());
        String alias = this.visitIdentifier(ctx.identifier());
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return alias != null ? new Alias(source, alias, exp) : new UnresolvedAlias(source, exp);
    }

    @Override
    public Expression visitStar(SqlBaseParser.StarContext ctx) {
        return new UnresolvedStar(ParserUtils.source((ParserRuleContext)ctx), ctx.qualifiedName() != null ? new UnresolvedAttribute(ParserUtils.source((ParserRuleContext)ctx.qualifiedName()), this.visitQualifiedName(ctx.qualifiedName())) : null);
    }

    @Override
    public Object visitDereference(SqlBaseParser.DereferenceContext ctx) {
        return new UnresolvedAttribute(ParserUtils.source((ParserRuleContext)ctx), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Expression visitExists(SqlBaseParser.ExistsContext ctx) {
        return new Exists(ParserUtils.source((ParserRuleContext)ctx), this.plan((ParseTree)ctx.query()));
    }

    @Override
    public Expression visitComparison(SqlBaseParser.ComparisonContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        TerminalNode op = (TerminalNode)ctx.comparisonOperator().getChild(0);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return switch (op.getSymbol().getType()) {
            case 112 -> new Equals(source, left, right, this.zoneId);
            case 113 -> new NullEquals(source, left, right, this.zoneId);
            case 114 -> new NotEquals(source, left, right, this.zoneId);
            case 115 -> new LessThan(source, left, right, this.zoneId);
            case 116 -> new LessThanOrEqual(source, left, right, this.zoneId);
            case 117 -> new GreaterThan(source, left, right, this.zoneId);
            case 118 -> new GreaterThanOrEqual(source, left, right, this.zoneId);
            default -> throw new ParsingException(source, "Unknown operator {}", source.text());
        };
    }

    @Override
    public Expression visitPredicated(SqlBaseParser.PredicatedContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.valueExpression());
        if (ctx.predicate() == null) {
            return exp;
        }
        SqlBaseParser.PredicateContext pCtx = ctx.predicate();
        Source source = ParserUtils.source((ParserRuleContext)ctx.valueExpression(), (ParserRuleContext)ctx);
        Object e = null;
        switch (pCtx.kind.getType()) {
            case 12: {
                e = new Range(source, exp, this.expression((ParseTree)pCtx.lower), true, this.expression((ParseTree)pCtx.upper), true, this.zoneId);
                break;
            }
            case 49: {
                if (pCtx.query() != null) {
                    throw new ParsingException(source, "IN query not supported yet", new Object[0]);
                }
                e = new In(source, exp, this.expressions(pCtx.valueExpression()), this.zoneId);
                break;
            }
            case 57: {
                e = new Like(source, exp, this.visitPattern(pCtx.pattern()));
                break;
            }
            case 79: {
                e = new RLike(source, exp, new RLikePattern(this.string(pCtx.regex)));
                break;
            }
            case 67: {
                if (pCtx.NOT() != null) {
                    return new IsNotNull(source, exp);
                }
                return new IsNull(source, exp);
            }
            default: {
                throw new ParsingException(source, "Unknown predicate {}", source.text());
            }
        }
        return pCtx.NOT() != null ? new Not(source, (Expression)e) : e;
    }

    @Override
    public LikePattern visitLikePattern(SqlBaseParser.LikePatternContext ctx) {
        return ctx == null ? null : this.visitPattern(ctx.pattern());
    }

    @Override
    public LikePattern visitPattern(SqlBaseParser.PatternContext ctx) {
        String escapeString;
        if (ctx == null) {
            return null;
        }
        String pattern = this.string(ctx.value);
        if (pattern == null) {
            throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx.value), "Pattern must not be [null]", new Object[0]);
        }
        char escape = '\u0000';
        SqlBaseParser.PatternEscapeContext escapeCtx = ctx.patternEscape();
        String string = escapeString = escapeCtx == null ? null : this.string(escapeCtx.escape);
        if (Strings.hasText((String)escapeString)) {
            if (escapeString.length() > 1) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)escapeCtx), "A character not a string required for escaping; found [{}]", escapeString);
            }
            if (escapeString.length() == 1) {
                escape = escapeString.charAt(0);
                if (escape == '%' || escape == '_') {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)escapeCtx.escape), "Char [{}] cannot be used for escaping as it's one of the wildcard chars [%_]", Character.valueOf(escape));
                }
                for (int i = 0; i < pattern.length(); ++i) {
                    char current = pattern.charAt(i);
                    if (current != escape) continue;
                    if (i + 1 == pattern.length()) {
                        throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx.value), "Pattern [{}] is invalid as escape char [{}] at position {} does not escape anything", pattern, Character.valueOf(escape), i);
                    }
                    char next = pattern.charAt(i + 1);
                    if (next == '%' || next == '_') continue;
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx.value), "Pattern [{}] is invalid as escape char [{}] at position {} can only escape wildcard chars [%_]; found [{}]", pattern, Character.valueOf(escape), i, Character.valueOf(next));
                }
            }
        }
        return new LikePattern(pattern, escape);
    }

    @Override
    public Object visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext ctx) {
        Expression value = this.expression((ParseTree)ctx.valueExpression());
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        switch (ctx.operator.getType()) {
            case 119: {
                return value;
            }
            case 120: {
                if (value instanceof Literal) {
                    return value;
                }
                return new Neg(ParserUtils.source((ParserRuleContext)ctx), value);
            }
        }
        throw new ParsingException(source, "Unknown arithmetic {}", source.text());
    }

    @Override
    public Object visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return switch (ctx.operator.getType()) {
            case 121 -> new Mul(source, left, right);
            case 122 -> new Div(source, left, right);
            case 123 -> new Mod(source, left, right);
            case 119 -> new Add(source, left, right);
            case 120 -> new Sub(source, left, right);
            default -> throw new ParsingException(source, "Unknown arithmetic {}", source.text());
        };
    }

    @Override
    public Object visitStringQuery(SqlBaseParser.StringQueryContext ctx) {
        return new StringQueryPredicate(ParserUtils.source((ParserRuleContext)ctx), this.string(ctx.queryString), this.getQueryOptions(ctx.matchQueryOptions()));
    }

    @Override
    public Object visitMatchQuery(SqlBaseParser.MatchQueryContext ctx) {
        return new MatchQueryPredicate(ParserUtils.source((ParserRuleContext)ctx), (Expression)new UnresolvedAttribute(ParserUtils.source((ParserRuleContext)ctx.singleField), this.visitQualifiedName(ctx.singleField)), this.string(ctx.queryString), this.getQueryOptions(ctx.matchQueryOptions()));
    }

    @Override
    public Object visitMultiMatchQuery(SqlBaseParser.MultiMatchQueryContext ctx) {
        return new MultiMatchQueryPredicate(ParserUtils.source((ParserRuleContext)ctx), this.string(ctx.multiFields), this.string(ctx.queryString), this.getQueryOptions(ctx.matchQueryOptions()));
    }

    private String getQueryOptions(SqlBaseParser.MatchQueryOptionsContext optionsCtx) {
        StringJoiner sj = new StringJoiner(";");
        for (SqlBaseParser.StringContext sc : optionsCtx.string()) {
            sj.add(this.string(sc));
        }
        return sj.toString();
    }

    @Override
    public Order visitOrderBy(SqlBaseParser.OrderByContext ctx) {
        return new Order(ParserUtils.source((ParserRuleContext)ctx), this.expression((ParseTree)ctx.expression()), ctx.DESC() != null ? Order.OrderDirection.DESC : Order.OrderDirection.ASC, ctx.NULLS() != null ? (ctx.FIRST() != null ? Order.NullsPosition.FIRST : Order.NullsPosition.LAST) : null);
    }

    @Override
    public DataType visitPrimitiveDataType(SqlBaseParser.PrimitiveDataTypeContext ctx) {
        return ExpressionBuilder.dataType(ParserUtils.source((ParserRuleContext)ctx), this.visitIdentifier(ctx.identifier()));
    }

    @Override
    public Cast visitCastExpression(SqlBaseParser.CastExpressionContext ctx) {
        SqlBaseParser.CastTemplateContext castTc = ctx.castTemplate();
        if (castTc != null) {
            return new Cast(ParserUtils.source((ParserRuleContext)castTc), this.expression((ParseTree)castTc.expression()), (DataType)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)castTc.dataType(), DataType.class));
        }
        SqlBaseParser.ConvertTemplateContext convertTc = ctx.convertTemplate();
        DataType dataType = ExpressionBuilder.dataType(ParserUtils.source((ParserRuleContext)convertTc.dataType()), convertTc.dataType().getText());
        return new Cast(ParserUtils.source((ParserRuleContext)convertTc), this.expression((ParseTree)convertTc.expression()), dataType);
    }

    private static DataType dataType(Source ctx, String string) {
        DataType dataType;
        String type = string.toUpperCase(Locale.ROOT);
        DataType dataType2 = dataType = type.startsWith("SQL_") ? SqlDataTypes.fromOdbcType(type) : SqlDataTypes.fromSqlOrEsType(type);
        if (dataType == null) {
            throw new ParsingException(ctx, "Does not recognize type [{}]", string);
        }
        return dataType;
    }

    @Override
    public Object visitCastOperatorExpression(SqlBaseParser.CastOperatorExpressionContext ctx) {
        return new Cast(ParserUtils.source((ParserRuleContext)ctx), this.expression((ParseTree)ctx.primaryExpression()), (DataType)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx.dataType(), DataType.class));
    }

    @Override
    public Function visitExtractExpression(SqlBaseParser.ExtractExpressionContext ctx) {
        SqlBaseParser.ExtractTemplateContext template = ctx.extractTemplate();
        String fieldString = this.visitIdentifier(template.field);
        return new UnresolvedFunction(ParserUtils.source((ParserRuleContext)template), fieldString, (FunctionResolutionStrategy)SqlFunctionResolution.EXTRACT, Collections.singletonList(this.expression((ParseTree)template.valueExpression())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visitBuiltinDateTimeFunction(SqlBaseParser.BuiltinDateTimeFunctionContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        String functionName = ctx.name.getText();
        switch (ctx.name.getType()) {
            case 20: 
            case 21: 
            case 22: {
                return new UnresolvedFunction(source, functionName, FunctionResolutionStrategy.DEFAULT, Collections.emptyList());
            }
            default: {
                throw new ParsingException(source, "Unknown function [{}]", functionName);
            }
        }
    }

    @Override
    public Function visitFunctionExpression(SqlBaseParser.FunctionExpressionContext ctx) {
        SqlBaseParser.FunctionTemplateContext template = ctx.functionTemplate();
        String name = template.functionName().getText();
        boolean isDistinct = template.setQuantifier() != null && template.setQuantifier().DISTINCT() != null;
        SqlFunctionResolution resolutionStrategy = isDistinct ? SqlFunctionResolution.DISTINCT : FunctionResolutionStrategy.DEFAULT;
        return new UnresolvedFunction(ParserUtils.source((ParserRuleContext)ctx), name, (FunctionResolutionStrategy)resolutionStrategy, this.expressions(template.expression()));
    }

    @Override
    public Expression visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext ctx) {
        return new ScalarSubquery(ParserUtils.source((ParserRuleContext)ctx), this.plan((ParseTree)ctx.query()));
    }

    @Override
    public Object visitCase(SqlBaseParser.CaseContext ctx) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(ctx.whenClause().size());
        for (SqlBaseParser.WhenClauseContext when : ctx.whenClause()) {
            if (ctx.operand != null) {
                expressions.add(new IfConditional(ParserUtils.source((ParserRuleContext)when), (Expression)new Equals(ParserUtils.source((ParserRuleContext)when), this.expression((ParseTree)ctx.operand), this.expression((ParseTree)when.condition), this.zoneId), this.expression((ParseTree)when.result)));
                continue;
            }
            expressions.add(new IfConditional(ParserUtils.source((ParserRuleContext)when), this.expression((ParseTree)when.condition), this.expression((ParseTree)when.result)));
        }
        if (ctx.elseClause != null) {
            expressions.add(this.expression((ParseTree)ctx.elseClause));
        } else {
            expressions.add((Expression)Literal.NULL);
        }
        return new Case(ParserUtils.source((ParserRuleContext)ctx), expressions);
    }

    @Override
    public Expression visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Object visitLogicalNot(SqlBaseParser.LogicalNotContext ctx) {
        return new Not(ParserUtils.source((ParserRuleContext)ctx), this.expression((ParseTree)ctx.booleanExpression()));
    }

    @Override
    public Object visitLogicalBinary(SqlBaseParser.LogicalBinaryContext ctx) {
        int type = ctx.operator.getType();
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        if (type == 8) {
            return new And(source, left, right);
        }
        if (type == 71) {
            return new Or(source, left, right);
        }
        throw new ParsingException(source, "Don't know how to parse {}", new Object[]{ctx});
    }

    @Override
    public Expression visitNullLiteral(SqlBaseParser.NullLiteralContext ctx) {
        return new Literal(ParserUtils.source((ParserRuleContext)ctx), null, DataTypes.NULL);
    }

    @Override
    public Literal visitInterval(SqlBaseParser.IntervalContext interval) {
        Intervals.TimeUnit leading = this.visitIntervalField(interval.leading);
        Intervals.TimeUnit trailing = this.visitIntervalField(interval.trailing);
        if (trailing != null) {
            if (leading == Intervals.TimeUnit.YEAR && trailing != Intervals.TimeUnit.MONTH) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)interval.trailing), "Invalid interval declaration; YEAR trailing unit required to be MONTH, received {}", new Object[]{trailing});
            }
            if (trailing.ordinal() <= leading.ordinal()) {
                EnumSet<Intervals.TimeUnit> range = EnumSet.range(leading, Intervals.TimeUnit.SECOND);
                range.remove((Object)leading);
                throw new ParsingException(ParserUtils.source((ParserRuleContext)interval.trailing), "Invalid interval declaration; trailing unit [{}] needs to be smaller than leading unit[{}], expected one of {}", new Object[]{trailing, leading, range});
            }
        }
        DataType intervalType = Intervals.intervalType(ParserUtils.source((ParserRuleContext)interval), leading, trailing);
        boolean negative = false;
        ParserRuleContext parentCtx = interval.getParent();
        if (parentCtx != null && parentCtx instanceof SqlBaseParser.IntervalLiteralContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ConstantDefaultContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ValueExpressionDefaultContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ArithmeticUnaryContext) {
            SqlBaseParser.ArithmeticUnaryContext auc = (SqlBaseParser.ArithmeticUnaryContext)parentCtx;
            negative = auc.MINUS() != null;
        }
        negative ^= interval.sign != null && interval.sign.getType() == 120;
        TemporalAmount value = null;
        if (interval.valueNumeric != null) {
            if (trailing != null) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)interval.trailing), "Invalid interval declaration; trailing unit [{}] specified but the value is with numeric (single unit), use the string notation instead", new Object[]{trailing});
            }
            value = this.of(interval.valueNumeric, leading);
        } else {
            value = this.of(interval.valuePattern, negative, intervalType);
        }
        Interval timeInterval = value instanceof Period ? new IntervalYearMonth((Period)value, intervalType) : new IntervalDayTime((Duration)value, intervalType);
        return new Literal(ParserUtils.source((ParserRuleContext)interval), (Object)timeInterval, timeInterval.dataType());
    }

    private TemporalAmount of(SqlBaseParser.NumberContext valueNumeric, Intervals.TimeUnit unit) {
        Literal value = (Literal)this.visit((ParseTree)valueNumeric);
        Number numeric = (Number)value.fold();
        if (Math.rint(numeric.doubleValue()) != (double)numeric.longValue()) {
            throw new ParsingException(ParserUtils.source((ParserRuleContext)valueNumeric), "Fractional values are not supported for intervals", new Object[0]);
        }
        return Intervals.of(ParserUtils.source((ParserRuleContext)valueNumeric), numeric.longValue(), unit);
    }

    private TemporalAmount of(SqlBaseParser.StringContext valuePattern, boolean negative, DataType intervalType) {
        String valueString = this.string(valuePattern);
        Source source = ParserUtils.source((ParserRuleContext)valuePattern);
        TemporalAmount interval = Intervals.parseInterval(source, valueString, intervalType);
        if (negative) {
            interval = Intervals.negate(interval);
        }
        return interval;
    }

    @Override
    public Intervals.TimeUnit visitIntervalField(SqlBaseParser.IntervalFieldContext ctx) {
        if (ctx == null) {
            return null;
        }
        switch (((TerminalNode)ctx.getChild(TerminalNode.class, 0)).getSymbol().getType()) {
            case 101: 
            case 102: {
                return Intervals.TimeUnit.YEAR;
            }
            case 63: 
            case 64: {
                return Intervals.TimeUnit.MONTH;
            }
            case 23: 
            case 24: {
                return Intervals.TimeUnit.DAY;
            }
            case 47: 
            case 48: {
                return Intervals.TimeUnit.HOUR;
            }
            case 61: 
            case 62: {
                return Intervals.TimeUnit.MINUTE;
            }
            case 82: 
            case 83: {
                return Intervals.TimeUnit.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + ctx.getText());
    }

    @Override
    public Expression visitBooleanLiteral(SqlBaseParser.BooleanLiteralContext ctx) {
        boolean value;
        try {
            value = Booleans.parseBoolean((String)ctx.getText().toLowerCase(Locale.ROOT), (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), iae.getMessage(), new Object[0]);
        }
        return new Literal(ParserUtils.source((ParserRuleContext)ctx), (Object)value, DataTypes.BOOLEAN);
    }

    @Override
    public Expression visitStringLiteral(SqlBaseParser.StringLiteralContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (TerminalNode node : ctx.STRING()) {
            sb.append(ExpressionBuilder.unquoteString(ParserUtils.text((ParseTree)node)));
        }
        return new Literal(ParserUtils.source((ParserRuleContext)ctx), (Object)sb.toString(), DataTypes.KEYWORD);
    }

    @Override
    public Literal visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext ctx) {
        Tuple<Source, String> tuple = ExpressionBuilder.withMinus(ctx);
        try {
            return new Literal((Source)tuple.v1(), (Object)StringUtils.parseDouble((String)((String)tuple.v2())), DataTypes.DOUBLE);
        }
        catch (QlIllegalArgumentException siae) {
            throw new ParsingException((Source)tuple.v1(), siae.getMessage(), new Object[0]);
        }
    }

    @Override
    public Literal visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext ctx) {
        long value;
        Tuple<Source, String> tuple = ExpressionBuilder.withMinus(ctx);
        try {
            value = StringUtils.parseLong((String)((String)tuple.v2()));
        }
        catch (QlIllegalArgumentException siae) {
            throw new ParsingException((Source)tuple.v1(), siae.getMessage(), new Object[0]);
        }
        Number val = value;
        DataType type = DataTypes.LONG;
        if ((long)((int)value) == value) {
            type = DataTypes.INTEGER;
            val = (int)value;
        }
        return new Literal((Source)tuple.v1(), (Object)val, type);
    }

    @Override
    public Literal visitParamLiteral(SqlBaseParser.ParamLiteralContext ctx) {
        DataType sourceType;
        SqlTypedParamValue param = this.param(ctx.PARAM());
        DataType dataType = SqlDataTypes.fromTypeName(param.type);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        if (dataType == null) {
            throw new ParsingException(source, "Invalid parameter data type [{}]", param.type);
        }
        if (param.value == null) {
            return new Literal(source, null, dataType);
        }
        try {
            sourceType = DataTypes.fromJava((Object)param.value);
        }
        catch (QlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), source, "Unexpected actual parameter type [{}] for type [{}]", param.value.getClass().getName(), param.type);
        }
        if (sourceType == dataType) {
            return new Literal(source, param.value, dataType);
        }
        try {
            if (!SqlDataTypeConverter.canConvert(sourceType, dataType)) {
                throw new ParsingException(source, "Cannot cast value [{}] of type [{}] to parameter type [{}]", param.value, sourceType, dataType);
            }
            return new Literal(source, SqlDataTypeConverter.converterFor(sourceType, dataType).convert(param.value), dataType);
        }
        catch (QlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), source, "Unexpected actual parameter type [{}] for type [{}]", sourceType, param.type);
        }
    }

    @Override
    public String visitString(SqlBaseParser.StringContext ctx) {
        return this.string(ctx);
    }

    String string(SqlBaseParser.StringContext ctx) {
        if (ctx == null) {
            return null;
        }
        SqlTypedParamValue param = this.param(ctx.PARAM());
        if (param != null) {
            return param.value != null ? param.value.toString() : null;
        }
        return ExpressionBuilder.unquoteString(ctx.getText());
    }

    private SqlTypedParamValue param(TerminalNode node) {
        if (node == null) {
            return null;
        }
        Token token = node.getSymbol();
        if (!this.params.containsKey(token)) {
            throw new ParsingException(ParserUtils.source((TerminalNode)node), "Unexpected parameter", new Object[0]);
        }
        return this.params.get(token);
    }

    @Override
    public Literal visitDateEscapedLiteral(SqlBaseParser.DateEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        try {
            return new Literal(source, (Object)DateUtils.asDateOnly(string), SqlDataTypes.DATE);
        }
        catch (DateTimeParseException ex) {
            throw new ParsingException(source, "Invalid date received; {}", ex.getMessage());
        }
    }

    @Override
    public Literal visitTimeEscapedLiteral(SqlBaseParser.TimeEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        try {
            return new Literal(source, (Object)DateUtils.asTimeOnly(string), SqlDataTypes.TIME);
        }
        catch (DateTimeParseException ex) {
            throw new ParsingException(source, "Invalid time received; {}", ex.getMessage());
        }
    }

    @Override
    public Literal visitTimestampEscapedLiteral(SqlBaseParser.TimestampEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        try {
            return new Literal(source, (Object)DateUtils.dateTimeOfEscapedLiteral(string), DataTypes.DATETIME);
        }
        catch (DateTimeParseException ex) {
            throw new ParsingException(source, "Invalid timestamp received; {}", ex.getMessage());
        }
    }

    @Override
    public Literal visitGuidEscapedLiteral(SqlBaseParser.GuidEscapedLiteralContext ctx) {
        int[] separatorPos;
        String string = this.string(ctx.string());
        Source source = ParserUtils.source((ParserRuleContext)ctx.string());
        String lowerCase = string.toLowerCase(Locale.ROOT);
        String errorPrefix = "Invalid GUID, ";
        if (lowerCase.length() != 36) {
            throw new ParsingException(source, "{}too {}", errorPrefix, lowerCase.length() > 36 ? "long" : "short");
        }
        for (int pos : separatorPos = new int[]{8, 13, 18, 23}) {
            if (lowerCase.charAt(pos) == '-') continue;
            throw new ParsingException(source, "{}expected group separator at offset [{}], found [{}]", errorPrefix, pos, Character.valueOf(string.charAt(pos)));
        }
        String HEXA = "0123456789abcdef";
        for (int i = 0; i < lowerCase.length(); ++i) {
            boolean inspect = true;
            for (int pos : separatorPos) {
                if (i == pos) {
                    inspect = false;
                    break;
                }
                if (pos > i) break;
            }
            if (!inspect || HEXA.indexOf(lowerCase.charAt(i)) >= 0) continue;
            throw new ParsingException(source, "{}expected hexadecimal at offset[{}], found [{}]", errorPrefix, i, Character.valueOf(string.charAt(i)));
        }
        return new Literal(ParserUtils.source((ParserRuleContext)ctx), (Object)string, DataTypes.KEYWORD);
    }

    private static Tuple<Source, String> withMinus(SqlBaseParser.NumberContext ctx) {
        String string = ctx.getText();
        Tuple<Source, Boolean> tuple = ExpressionBuilder.minusAwareSource(ctx);
        return new Tuple((Object)((Source)tuple.v1()), (Object)(((Boolean)tuple.v2() != false ? "-" : "") + string));
    }

    private static Tuple<Source, Boolean> minusAwareSource(SqlBaseParser.NumberContext ctx) {
        ParserRuleContext parentCtx = ctx.getParent();
        if (parentCtx != null) {
            if (parentCtx instanceof SqlBaseParser.NumericLiteralContext) {
                if ((parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ConstantDefaultContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ValueExpressionDefaultContext) {
                    ParserRuleContext returnCtx = null;
                    boolean minus = false;
                    for (parentCtx = parentCtx.getParent(); !(parentCtx == null || parentCtx instanceof SqlBaseParser.ArithmeticBinaryContext || parentCtx instanceof SqlBaseParser.ExtractTemplateContext || parentCtx instanceof SqlBaseParser.NamedValueExpressionContext || parentCtx instanceof SqlBaseParser.PredicateContext || parentCtx instanceof SqlBaseParser.ComparisonContext); parentCtx = parentCtx.getParent()) {
                        if (!(parentCtx instanceof SqlBaseParser.ArithmeticUnaryContext)) continue;
                        returnCtx = parentCtx;
                        if (((SqlBaseParser.ArithmeticUnaryContext)parentCtx).MINUS() == null) continue;
                        minus ^= true;
                    }
                    if (returnCtx != null) {
                        return new Tuple((Object)ParserUtils.source(returnCtx), (Object)minus);
                    }
                }
            } else if (parentCtx instanceof SqlBaseParser.IntervalContext) {
                SqlBaseParser.IntervalContext ic = (SqlBaseParser.IntervalContext)parentCtx;
                if (ic.sign != null && ic.sign.getType() == 120) {
                    return new Tuple((Object)ParserUtils.source((ParserRuleContext)ic), (Object)true);
                }
            } else if (parentCtx instanceof SqlBaseParser.SysTypesContext && ((SqlBaseParser.SysTypesContext)parentCtx).MINUS() != null) {
                return new Tuple((Object)ParserUtils.source((ParserRuleContext)parentCtx), (Object)true);
            }
        }
        return new Tuple((Object)ParserUtils.source((ParserRuleContext)ctx), (Object)false);
    }
}

