/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.optimizer;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.ExpressionSet;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.CompoundAggregate;
import org.elasticsearch.xpack.ql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.ql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.analysis.analyzer.Analyzer;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStatsEnclosed;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStatsEnclosed;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRank;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRanks;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentiles;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Stats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ArbitraryConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Coalesce;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Iif;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.NullIf;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.session.SingletonExecutable;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class Optimizer
extends RuleExecutor<LogicalPlan> {
    public RuleExecutor.ExecutionInfo debugOptimize(LogicalPlan verified) {
        return verified.optimized() ? null : this.executeWithInfo((Node)verified);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        return verified.optimized() ? verified : (LogicalPlan)this.execute((Node)verified);
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch substitutions = new RuleExecutor.Batch((RuleExecutor)this, "Substitutions", RuleExecutor.Limiter.ONCE, new Rule[]{new RewritePivot(), new OptimizerRules.ReplaceRegexMatch(), new ReplaceAggregatesWithLiterals()});
        RuleExecutor.Batch refs = new RuleExecutor.Batch((RuleExecutor)this, "Replace References", RuleExecutor.Limiter.ONCE, new Rule[]{new ReplaceReferenceAttributeWithSource()});
        RuleExecutor.Batch operators = new RuleExecutor.Batch((RuleExecutor)this, "Operator Optimization", new Rule[]{new CombineProjections(), new ReplaceFoldableAttributes(), new FoldNull(), new ReplaceAggregationsInLocalRelations(), new OptimizerRules.ConstantFolding(), new SimplifyConditional(), new SimplifyCase(), new OptimizerRules.BooleanSimplification(), new OptimizerRules.LiteralsOnTheRight(), new OptimizerRules.BinaryComparisonSimplification(), new OptimizerRules.PropagateEquals(), new PropagateNullable(), new OptimizerRules.CombineBinaryComparisons(), new CombineDisjunctionsToIn(), new OptimizerRules.SimplifyComparisonsArithmetics(SqlDataTypes::areCompatible), new PruneDuplicatesInGroupBy(), new PruneFilters(), new PruneOrderByForImplicitGrouping(), new OptimizerRules.PruneLiteralsInOrderBy(), new PruneOrderByNestedFields(), new PruneCast(), new SortAggregateOnOrderBy(), new OptimizerRules.PushDownAndCombineFilters()});
        RuleExecutor.Batch aggregate = new RuleExecutor.Batch((RuleExecutor)this, "Aggregation Rewrite", new Rule[]{new ReplaceMinMaxWithTopHits(), new ReplaceAggsWithMatrixStats(), new ReplaceAggsWithExtendedStats(), new ReplaceAggsWithStats(), new ReplaceSumWithStats(), new PromoteStatsToExtendedStats(), new ReplaceAggsWithPercentiles(), new ReplaceAggsWithPercentileRanks()});
        RuleExecutor.Batch local = new RuleExecutor.Batch((RuleExecutor)this, "Skip Elasticsearch", new Rule[]{new SkipQueryOnLimitZero(), new SkipQueryForLiteralAggregations(), new PushProjectionsIntoLocalRelation(), new PruneLiteralsInGroupBy()});
        RuleExecutor.Batch label = new RuleExecutor.Batch((RuleExecutor)this, "Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{Analyzer.CleanAliases.INSTANCE, new OptimizerRules.SetAsOptimized()});
        return Arrays.asList(substitutions, refs, operators, aggregate, local, label);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), new EmptyExecutable(plan.output()));
    }

    static class RewritePivot
    extends OptimizerRules.OptimizerRule<Pivot> {
        RewritePivot() {
        }

        protected LogicalPlan rule(Pivot plan) {
            ArrayList<Expression> rawValues = new ArrayList<Expression>(plan.values().size());
            for (NamedExpression namedExpression : plan.values()) {
                if (namedExpression instanceof Alias) {
                    rawValues.add((Expression)Literal.of((Expression)((Alias)namedExpression).child()));
                    continue;
                }
                UnresolvedAttribute attr = new UnresolvedAttribute(namedExpression.source(), namedExpression.name(), null, "Unexpected alias");
                return new Pivot(plan.source(), plan.child(), plan.column(), Collections.singletonList(attr), plan.aggregates());
            }
            Filter filter = new Filter(plan.source(), plan.child(), (Expression)new In(plan.source(), plan.column(), rawValues));
            return new Pivot(plan.source(), (LogicalPlan)filter, plan.column(), plan.values(), plan.aggregates(), plan.groupings());
        }
    }

    private static class ReplaceAggregatesWithLiterals
    extends OptimizerBasicRule {
        private ReplaceAggregatesWithLiterals() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            return (LogicalPlan)p.transformExpressionsDown(AggregateFunction.class, a -> {
                if ((Stats.isTypeCompatible((Expression)a) || a instanceof Count && ((Count)a).distinct()) && a.field().foldable()) {
                    Count countOne = new Count(a.source(), (Expression)new Literal(Source.EMPTY, (Object)1, a.dataType()), false);
                    Equals countEqZero = new Equals(a.source(), (Expression)countOne, (Expression)new Literal(Source.EMPTY, (Object)0, a.dataType()));
                    Expression argument = a.field();
                    Literal foldedArgument = new Literal(argument.source(), argument.fold(), a.dataType());
                    Literal iifResult = Literal.NULL;
                    Object iifElseResult = foldedArgument;
                    if (a instanceof Sum) {
                        iifElseResult = new Mul(a.source(), (Expression)countOne, (Expression)foldedArgument);
                    } else if (a instanceof Count) {
                        iifResult = new Literal(Source.EMPTY, (Object)0, a.dataType());
                        iifElseResult = new Literal(Source.EMPTY, (Object)1, a.dataType());
                    }
                    return new Iif(a.source(), (Expression)countEqZero, (Expression)iifResult, (Expression)iifElseResult);
                }
                return a;
            });
        }
    }

    static class ReplaceReferenceAttributeWithSource
    extends OptimizerBasicRule {
        ReplaceReferenceAttributeWithSource() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            AttributeMap.Builder builder = AttributeMap.builder();
            plan.forEachExpressionUp(Alias.class, a -> builder.put(a.toAttribute(), (Object)a.child()));
            AttributeMap collectRefs = builder.build();
            java.util.function.Function<ReferenceAttribute, Expression> replaceReference = r -> (Expression)collectRefs.resolve(r, r);
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (!(p instanceof Pivot || p instanceof Project) || p.children().isEmpty()) {
                    if (p instanceof Aggregate) {
                        Aggregate agg = (Aggregate)p;
                        ArrayList newGrouping = new ArrayList(agg.groupings().size());
                        agg.groupings().forEach(e -> newGrouping.add((Expression)e.transformUp(ReferenceAttribute.class, replaceReference)));
                        if (!agg.groupings().equals(newGrouping)) {
                            p = new Aggregate(agg.source(), agg.child(), newGrouping, agg.aggregates());
                        }
                    } else {
                        p = (LogicalPlan)p.transformExpressionsOnly(ReferenceAttribute.class, replaceReference);
                    }
                }
                return p;
            });
            return plan;
        }
    }

    static class CombineProjections
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        CombineProjections() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            Object p;
            LogicalPlan child = plan.child();
            if (plan instanceof Project) {
                Project project = (Project)plan;
                if (child instanceof Project) {
                    Project p2 = (Project)child;
                    return new Project(p2.source(), p2.child(), this.combineProjections(project.projections(), p2.projections()));
                }
                if (child instanceof Aggregate) {
                    Aggregate a = (Aggregate)child;
                    return new Aggregate(a.source(), a.child(), a.groupings(), this.combineProjections(project.projections(), a.aggregates()));
                }
                if (child instanceof Pivot) {
                    p = (Pivot)child;
                    if (project.outputSet().subsetOf(((Pivot)((Object)p)).groupingSet())) {
                        return new Aggregate(p.source(), p.child(), new ArrayList(project.projections()), project.projections());
                    }
                }
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (child instanceof Project) {
                    p = (Project)child;
                    return new Aggregate(a.source(), p.child(), a.groupings(), this.combineProjections(a.aggregates(), p.projections()));
                }
            }
            return plan;
        }

        private List<NamedExpression> combineProjections(List<? extends NamedExpression> upper, List<? extends NamedExpression> lower) {
            AttributeMap.Builder aliasesBuilder = AttributeMap.builder();
            for (NamedExpression namedExpression : lower) {
                if (namedExpression instanceof Attribute) continue;
                aliasesBuilder.put(namedExpression.toAttribute(), (Object)namedExpression);
            }
            AttributeMap aliases = aliasesBuilder.build();
            ArrayList<NamedExpression> arrayList = new ArrayList<NamedExpression>();
            for (NamedExpression namedExpression : upper) {
                NamedExpression replacedExp = (NamedExpression)namedExpression.transformUp(Attribute.class, a -> (Expression)aliases.resolve(a, a));
                arrayList.add((NamedExpression)Analyzer.CleanAliases.trimNonTopLevelAliases((Expression)replacedExp));
            }
            return arrayList;
        }
    }

    static class ReplaceFoldableAttributes
    extends Rule<LogicalPlan, LogicalPlan> {
        ReplaceFoldableAttributes() {
        }

        public LogicalPlan apply(LogicalPlan plan) {
            return this.rule(plan);
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            LinkedHashMap aliases = new LinkedHashMap();
            ArrayList attrs = new ArrayList();
            plan.forEachDown(Project.class, p -> {
                for (NamedExpression ne : p.projections()) {
                    if (!(ne instanceof Alias) || !((Alias)ne).child().foldable()) continue;
                    Attribute attr = ne.toAttribute();
                    attrs.add(attr);
                    aliases.put(attr, (Alias)ne);
                }
            });
            if (attrs.isEmpty()) {
                return plan;
            }
            Holder stop = new Holder((Object)Boolean.FALSE);
            plan = (LogicalPlan)plan.transformUp(p -> {
                if (stop.get() == Boolean.FALSE && this.canPropagateFoldable((LogicalPlan)p)) {
                    return (LogicalPlan)p.transformExpressionsDown(Attribute.class, e -> {
                        if (attrs.contains(e)) {
                            Alias as = (Alias)aliases.get(e);
                            if (as == null) {
                                throw new SqlIllegalArgumentException("unsupported");
                            }
                            return as;
                        }
                        return e;
                    });
                }
                if (p.children().size() > 1) {
                    stop.set((Object)Boolean.TRUE);
                }
                return p;
            });
            return Analyzer.CleanAliases.INSTANCE.apply(plan);
        }

        private boolean canPropagateFoldable(LogicalPlan p) {
            return p instanceof Project || p instanceof Filter || p instanceof SubQueryAlias || p instanceof Aggregate || p instanceof Limit || p instanceof OrderBy;
        }
    }

    static class FoldNull
    extends OptimizerRules.OptimizerExpressionRule<Expression> {
        FoldNull() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected Expression rule(Expression e) {
            if (e instanceof IsNotNull) {
                if (((IsNotNull)e).field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), (Object)Boolean.TRUE, DataTypes.BOOLEAN);
                }
            } else if (e instanceof IsNull) {
                if (((IsNull)e).field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), (Object)Boolean.FALSE, DataTypes.BOOLEAN);
                }
            } else if (e instanceof In) {
                In in = (In)e;
                if (Expressions.isNull((Expression)in.value())) {
                    return Literal.of((Expression)in, null);
                }
            } else if (!(e instanceof Alias) && e.nullable() == Nullability.TRUE && Expressions.anyMatch((List)e.children(), Expressions::isNull)) {
                return Literal.of((Expression)e, null);
            }
            return e;
        }
    }

    static class ReplaceAggregationsInLocalRelations
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        ReplaceAggregationsInLocalRelations() {
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            LocalRelation relation;
            if ((plan instanceof Aggregate || plan instanceof Filter || plan instanceof OrderBy) && (relation = this.unfilteredLocalRelation(plan.child())) != null) {
                long count = relation.executable() instanceof EmptyExecutable ? 0L : 1L;
                return (LogicalPlan)plan.transformExpressionsDown(AggregateFunction.class, aggregateFunction -> {
                    if (aggregateFunction instanceof Count) {
                        return Literal.of((Expression)aggregateFunction, (Object)count);
                    }
                    if (count == 0L) {
                        return Literal.of((Expression)aggregateFunction, null);
                    }
                    return aggregateFunction;
                });
            }
            return plan;
        }

        private LocalRelation unfilteredLocalRelation(LogicalPlan plan) {
            LogicalPlan filterOrLeaf;
            List filterOrLeaves = plan.collectFirstChildren(p -> p instanceof Filter || p instanceof LeafPlan);
            if (filterOrLeaves.size() == 1 && (filterOrLeaf = (LogicalPlan)filterOrLeaves.get(0)) instanceof LocalRelation) {
                return (LocalRelation)filterOrLeaf;
            }
            return null;
        }
    }

    static class SimplifyConditional
    extends OptimizerRules.OptimizerExpressionRule<ConditionalFunction> {
        SimplifyConditional() {
            super(OptimizerRules.TransformDirection.DOWN);
        }

        protected Expression rule(ConditionalFunction cf) {
            NullIf nullIf;
            ConditionalFunction e = cf;
            List children = e.children();
            if (e instanceof NullIf && (Expressions.isNull((Expression)(nullIf = (NullIf)e).left()) || Expressions.isNull((Expression)nullIf.right()))) {
                return nullIf.left();
            }
            if (e instanceof ArbitraryConditionalFunction) {
                ArbitraryConditionalFunction c = (ArbitraryConditionalFunction)e;
                ArrayList<Expression> newChildren = new ArrayList<Expression>();
                for (Expression child : children) {
                    if (Expressions.isNull((Expression)child)) continue;
                    newChildren.add(child);
                    if (!(e instanceof Coalesce) || !child.foldable()) continue;
                    break;
                }
                if (newChildren.size() < children.size()) {
                    e = (Expression)c.replaceChildren(newChildren);
                }
                if (e instanceof Coalesce && children.size() > 0) {
                    Expression firstChild = (Expression)children.get(0);
                    boolean sameChild = true;
                    for (int i = 1; i < children.size(); ++i) {
                        Expression child = (Expression)children.get(i);
                        if (firstChild.semanticEquals(child)) continue;
                        sameChild = false;
                        break;
                    }
                    if (sameChild) {
                        return firstChild;
                    }
                }
            }
            return e;
        }
    }

    static class SimplifyCase
    extends OptimizerRules.OptimizerExpressionRule<Case> {
        SimplifyCase() {
            super(OptimizerRules.TransformDirection.DOWN);
        }

        protected Expression rule(Case c) {
            Case e = c;
            ArrayList<IfConditional> newConditions = new ArrayList<IfConditional>();
            for (IfConditional conditional : c.conditions()) {
                if (conditional.condition().foldable()) {
                    Boolean res = (Boolean)conditional.condition().fold();
                    if (res != Boolean.TRUE) continue;
                    newConditions.add(conditional);
                    break;
                }
                newConditions.add(conditional);
            }
            if (newConditions.size() < c.children().size()) {
                e = c.replaceChildren((List<Expression>)CollectionUtils.combine(newConditions, (Object[])new Expression[]{c.elseResult()}));
            }
            return e;
        }
    }

    static class PropagateNullable
    extends OptimizerRules.PropagateNullable {
        PropagateNullable() {
        }

        protected Expression nullify(Expression exp, Expression nullExp) {
            if (exp instanceof Coalesce) {
                ArrayList<Expression> newChildren = new ArrayList<Expression>(exp.children());
                newChildren.removeIf(e -> e.semanticEquals(nullExp));
                if (newChildren.size() != exp.children().size()) {
                    return (Expression)exp.replaceChildren(newChildren);
                }
            }
            return super.nullify(exp, nullExp);
        }

        protected Expression nonNullify(Expression exp, Expression nonNullExp) {
            if (exp instanceof Coalesce) {
                List children = exp.children();
                for (int i = 0; i < children.size(); ++i) {
                    if (!nonNullExp.semanticEquals((Expression)children.get(i))) continue;
                    return (Expression)exp.replaceChildren(children.subList(0, i + 1));
                }
            }
            return super.nonNullify(exp, nonNullExp);
        }
    }

    static class CombineDisjunctionsToIn
    extends OptimizerRules.CombineDisjunctionsToIn {
        CombineDisjunctionsToIn() {
        }

        protected In createIn(Expression key, List<Expression> values, ZoneId zoneId) {
            return new In(key.source(), key, values, zoneId);
        }
    }

    static class PruneDuplicatesInGroupBy
    extends OptimizerRules.OptimizerRule<Aggregate> {
        PruneDuplicatesInGroupBy() {
        }

        protected LogicalPlan rule(Aggregate agg) {
            List groupings = agg.groupings();
            if (groupings.isEmpty()) {
                return agg;
            }
            ExpressionSet unique = new ExpressionSet((Collection)groupings);
            if (unique.size() != groupings.size()) {
                return new Aggregate(agg.source(), agg.child(), new ArrayList(unique), agg.aggregates());
            }
            return agg;
        }
    }

    static class PruneFilters
    extends OptimizerRules.PruneFilters {
        PruneFilters() {
        }

        protected LogicalPlan skipPlan(Filter filter) {
            return Optimizer.skipPlan((UnaryPlan)filter);
        }
    }

    static class PruneOrderByForImplicitGrouping
    extends OptimizerRules.OptimizerRule<OrderBy> {
        PruneOrderByForImplicitGrouping() {
        }

        protected LogicalPlan rule(OrderBy ob) {
            Holder foundAggregate = new Holder((Object)Boolean.FALSE);
            Holder foundImplicitGroupBy = new Holder((Object)Boolean.FALSE);
            ob.forEachDown(Aggregate.class, a -> {
                if (foundAggregate.get() == Boolean.TRUE) {
                    return;
                }
                foundAggregate.set((Object)Boolean.TRUE);
                if (a.groupings().isEmpty()) {
                    foundImplicitGroupBy.set((Object)Boolean.TRUE);
                }
            });
            if (foundImplicitGroupBy.get() == Boolean.TRUE) {
                return ob.child();
            }
            return ob;
        }
    }

    static class PruneOrderByNestedFields
    extends OptimizerRules.OptimizerRule<Project> {
        PruneOrderByNestedFields() {
        }

        private void findNested(Expression exp, AttributeMap<Function> functions, Consumer<FieldAttribute> onFind) {
            exp.forEachUp(e -> {
                FieldAttribute fa;
                Function f;
                if (e instanceof ReferenceAttribute && (f = (Function)functions.resolve(e)) != null) {
                    this.findNested((Expression)f, functions, onFind);
                }
                if (e instanceof FieldAttribute && (fa = (FieldAttribute)e).isNested()) {
                    onFind.accept(fa);
                }
            });
        }

        protected LogicalPlan rule(Project project) {
            LogicalPlan logicalPlan = project.child();
            if (logicalPlan instanceof OrderBy) {
                OrderBy ob = (OrderBy)logicalPlan;
                AttributeMap.Builder collectRefs = AttributeMap.builder();
                project.forEachUp(p -> p.forEachExpressionUp(Alias.class, a -> {
                    if (a.child() instanceof Function) {
                        collectRefs.put(a.toAttribute(), (Object)((Function)a.child()));
                    }
                }));
                AttributeMap functions = collectRefs.build();
                LinkedHashMap nestedOrders = new LinkedHashMap();
                for (Object order : ob.order()) {
                    this.findNested(order.child(), (AttributeMap<Function>)functions, arg_0 -> PruneOrderByNestedFields.lambda$rule$3(nestedOrders, (Order)order, arg_0));
                }
                if (nestedOrders.isEmpty()) {
                    return project;
                }
                ArrayList nestedTopFields = new ArrayList();
                for (Object ne : project.projections()) {
                    this.findNested((Expression)ne, (AttributeMap<Function>)functions, fa -> nestedTopFields.add(fa.nestedParent().name()));
                }
                ArrayList orders = new ArrayList(ob.order());
                if (nestedTopFields.isEmpty()) {
                    orders.removeAll(nestedOrders.values());
                } else {
                    for (Map.Entry entry : nestedOrders.entrySet()) {
                        String parent = (String)entry.getKey();
                        boolean shouldKeep = false;
                        for (String topParent : nestedTopFields) {
                            if (!topParent.startsWith(parent)) continue;
                            shouldKeep = true;
                            break;
                        }
                        if (shouldKeep) continue;
                        orders.remove(entry.getValue());
                    }
                }
                if (orders.isEmpty()) {
                    return new Project(project.source(), ob.child(), project.projections());
                }
                if (orders.size() != ob.order().size()) {
                    OrderBy newOrder = new OrderBy(ob.source(), ob.child(), orders);
                    return new Project(project.source(), (LogicalPlan)newOrder, project.projections());
                }
            }
            return project;
        }

        private static /* synthetic */ void lambda$rule$3(Map nestedOrders, Order order, FieldAttribute fa) {
            nestedOrders.put(fa.nestedParent().name(), order);
        }
    }

    static class PruneCast
    extends OptimizerRules.PruneCast<Cast> {
        PruneCast() {
            super(Cast.class);
        }

        protected Expression maybePruneCast(Cast cast) {
            return cast.from() == cast.to() ? cast.field() : cast;
        }
    }

    static class SortAggregateOnOrderBy
    extends OptimizerRules.OptimizerRule<OrderBy> {
        SortAggregateOnOrderBy() {
        }

        protected LogicalPlan rule(OrderBy ob) {
            List order = ob.order();
            LinkedList<Order> nonConstant = new LinkedList<Order>();
            for (int i = order.size() - 1; i >= 0; --i) {
                nonConstant.add((Order)order.get(i));
            }
            Holder foundAggregate = new Holder((Object)Boolean.FALSE);
            return (LogicalPlan)ob.transformDown(Aggregate.class, a -> {
                if (foundAggregate.get() == Boolean.TRUE) {
                    return a;
                }
                foundAggregate.set((Object)Boolean.TRUE);
                LinkedList<Expression> groupings = new LinkedList<Expression>(a.groupings());
                for (Order o : nonConstant) {
                    Expression fieldToOrder = o.child();
                    for (Expression group : a.groupings()) {
                        Holder isMatching = new Holder((Object)Boolean.FALSE);
                        if (Expressions.equalsAsAttribute((Expression)fieldToOrder, (Expression)group)) {
                            isMatching.set((Object)Boolean.TRUE);
                        } else {
                            a.aggregates().forEach(alias -> {
                                Expression child;
                                if (alias instanceof Alias && (Expressions.equalsAsAttribute((Expression)(child = ((Alias)alias).child()), (Expression)group) && (Expressions.equalsAsAttribute((Expression)alias, (Expression)fieldToOrder) || Expressions.equalsAsAttribute((Expression)child, (Expression)fieldToOrder)) || Expressions.equalsAsAttribute((Expression)alias, (Expression)group) && (Expressions.equalsAsAttribute((Expression)alias, (Expression)fieldToOrder) || Expressions.equalsAsAttribute((Expression)child, (Expression)fieldToOrder)))) {
                                    isMatching.set((Object)Boolean.TRUE);
                                }
                            });
                        }
                        if (!((Boolean)isMatching.get()).booleanValue()) continue;
                        groupings.remove(group);
                        groupings.add(0, group);
                    }
                }
                if (!groupings.equals(a.groupings())) {
                    return new Aggregate(a.source(), a.child(), groupings, a.aggregates());
                }
                return a;
            });
        }
    }

    static class ReplaceMinMaxWithTopHits
    extends OptimizerRules.OptimizerRule<LogicalPlan> {
        ReplaceMinMaxWithTopHits() {
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            HashMap mins = new HashMap();
            HashMap maxs = new HashMap();
            return (LogicalPlan)plan.transformExpressionsDown(NumericAggregate.class, e -> {
                Max max;
                Min min;
                if (e instanceof Min && DataTypes.isString((DataType)(min = (Min)((Object)e)).field().dataType())) {
                    return (Expression)mins.computeIfAbsent(min.field(), k -> new First(min.source(), (Expression)k, null));
                }
                if (e instanceof Max && DataTypes.isString((DataType)(max = (Max)((Object)e)).field().dataType())) {
                    return (Expression)maxs.computeIfAbsent(max.field(), k -> new Last(max.source(), (Expression)k, null));
                }
                return e;
            });
        }
    }

    static class ReplaceAggsWithMatrixStats
    extends OptimizerBasicRule {
        ReplaceAggsWithMatrixStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            return (LogicalPlan)p.transformExpressionsUp(AggregateFunction.class, f -> {
                if (f instanceof MatrixStatsEnclosed) {
                    Expression argument = f.field();
                    MatrixStats matrixStats = (MatrixStats)((Object)((Object)seen.get(argument)));
                    if (matrixStats == null) {
                        Source source = new Source(f.sourceLocation(), "MATRIX(" + argument.sourceText() + ")");
                        matrixStats = new MatrixStats(source, argument);
                        seen.put(argument, matrixStats);
                    }
                    f = new InnerAggregate(f.source(), f, (CompoundAggregate)matrixStats, argument);
                }
                return f;
            });
        }
    }

    static class ReplaceAggsWithExtendedStats
    extends OptimizerBasicRule {
        ReplaceAggsWithExtendedStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            return (LogicalPlan)p.transformExpressionsUp(AggregateFunction.class, f -> {
                if (f instanceof ExtendedStatsEnclosed) {
                    Expression argument = f.field();
                    ExtendedStats extendedStats = (ExtendedStats)((Object)((Object)seen.get(argument)));
                    if (extendedStats == null) {
                        Source source = new Source(f.sourceLocation(), "EXT_STATS(" + argument.sourceText() + ")");
                        extendedStats = new ExtendedStats(source, argument);
                        seen.put(argument, extendedStats);
                    }
                    f = new InnerAggregate(f, (CompoundAggregate)extendedStats);
                }
                return f;
            });
        }
    }

    static class ReplaceAggsWithStats
    extends OptimizerBasicRule {
        ReplaceAggsWithStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap potentialPromotions = new LinkedHashMap();
            p.forEachExpressionUp(AggregateFunction.class, f -> {
                if (Stats.isTypeCompatible((Expression)f)) {
                    Expression argument = f.field();
                    Match match = (Match)potentialPromotions.get(argument);
                    if (match == null) {
                        Source source = new Source(f.sourceLocation(), "STATS(" + argument.sourceText() + ")");
                        match = new Match(new Stats(source, argument));
                        potentialPromotions.put(argument, match);
                    }
                    match.add(f.getClass());
                }
            });
            if (potentialPromotions.isEmpty()) {
                return p;
            }
            return (LogicalPlan)p.transformExpressionsUp(AggregateFunction.class, f -> {
                Expression argument;
                Match match;
                if (Stats.isTypeCompatible((Expression)f) && (match = (Match)potentialPromotions.get(argument = f.field())) != null) {
                    return match.maybePromote((AggregateFunction)f);
                }
                return f;
            });
        }

        private static class Match {
            final Stats stats;
            private final Set<Class<? extends AggregateFunction>> functionTypes = new LinkedHashSet<Class<? extends AggregateFunction>>();
            private Map<Class<? extends AggregateFunction>, InnerAggregate> innerAggs = null;

            Match(Stats stats) {
                this.stats = stats;
            }

            public String toString() {
                return this.stats.toString();
            }

            public void add(Class<? extends AggregateFunction> aggType) {
                this.functionTypes.add(aggType);
            }

            public AggregateFunction maybePromote(AggregateFunction agg) {
                if (this.functionTypes.size() > 1) {
                    if (this.innerAggs == null) {
                        this.innerAggs = new LinkedHashMap<Class<? extends AggregateFunction>, InnerAggregate>();
                    }
                    return (AggregateFunction)this.innerAggs.computeIfAbsent(agg.getClass(), k -> new InnerAggregate(agg, (CompoundAggregate)this.stats));
                }
                return agg;
            }
        }
    }

    static class ReplaceSumWithStats
    extends OptimizerBasicRule {
        ReplaceSumWithStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            LinkedHashMap statsPerField = new LinkedHashMap();
            plan.forEachExpressionUp(Sum.class, s -> statsPerField.computeIfAbsent(s.field(), field -> {
                Source source = new Source(field.sourceLocation(), "STATS(" + field.sourceText() + ")");
                return new Stats(source, (Expression)field);
            }));
            if (!statsPerField.isEmpty()) {
                plan = (LogicalPlan)plan.transformExpressionsUp(Sum.class, sum -> new InnerAggregate((AggregateFunction)sum, (CompoundAggregate)statsPerField.get(sum.field())));
            }
            return plan;
        }
    }

    static class PromoteStatsToExtendedStats
    extends OptimizerBasicRule {
        PromoteStatsToExtendedStats() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap seen = new LinkedHashMap();
            p.forEachExpressionUp(InnerAggregate.class, ia -> {
                CompoundAggregate patt44976$temp = ia.outer();
                if (patt44976$temp instanceof ExtendedStats) {
                    ExtendedStats extStats = (ExtendedStats)patt44976$temp;
                    seen.putIfAbsent(extStats.field(), extStats);
                }
            });
            return (LogicalPlan)p.transformExpressionsUp(InnerAggregate.class, ia -> {
                Stats stats;
                ExtendedStats ext;
                CompoundAggregate patt45417$temp = ia.outer();
                if (patt45417$temp instanceof Stats && (ext = (ExtendedStats)((Object)((Object)seen.get((stats = (Stats)patt45417$temp).field())))) != null && stats.field().equals((Object)ext.field())) {
                    return new InnerAggregate(ia.inner(), (CompoundAggregate)ext);
                }
                return ia;
            });
        }
    }

    static class ReplaceAggsWithPercentiles
    extends OptimizerBasicRule {
        ReplaceAggsWithPercentiles() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<PercentileKey, Set> percentsPerAggKey = new LinkedHashMap<PercentileKey, Set>();
            p.forEachExpressionUp(Percentile.class, per -> percentsPerAggKey.computeIfAbsent(new PercentileKey((Percentile)((Object)per)), v -> new LinkedHashSet()).add(per.percent()));
            LinkedHashMap percentilesPerAggKey = new LinkedHashMap();
            percentsPerAggKey.forEach((aggKey, percents) -> percentilesPerAggKey.put(aggKey, new Percentiles(((Expression)percents.iterator().next()).source(), aggKey.field(), new ArrayList<Expression>((Collection<Expression>)percents), aggKey.percentilesConfig())));
            return (LogicalPlan)p.transformExpressionsUp(Percentile.class, per -> {
                PercentileKey a = new PercentileKey((Percentile)((Object)per));
                Percentiles percentiles = (Percentiles)((Object)((Object)percentilesPerAggKey.get((Object)a)));
                return new InnerAggregate((AggregateFunction)per, (CompoundAggregate)percentiles);
            });
        }
    }

    static class ReplaceAggsWithPercentileRanks
    extends OptimizerBasicRule {
        ReplaceAggsWithPercentileRanks() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan p) {
            LinkedHashMap<PercentileKey, Set> valuesPerAggKey = new LinkedHashMap<PercentileKey, Set>();
            p.forEachExpressionUp(PercentileRank.class, per -> valuesPerAggKey.computeIfAbsent(new PercentileKey((PercentileRank)((Object)per)), v -> new LinkedHashSet()).add(per.value()));
            LinkedHashMap ranksPerAggKey = new LinkedHashMap();
            valuesPerAggKey.forEach((aggKey, values) -> ranksPerAggKey.put(aggKey, new PercentileRanks(((Expression)values.iterator().next()).source(), aggKey.field(), new ArrayList<Expression>((Collection<Expression>)values), aggKey.percentilesConfig())));
            return (LogicalPlan)p.transformExpressionsUp(PercentileRank.class, per -> {
                PercentileRanks ranks = (PercentileRanks)((Object)((Object)ranksPerAggKey.get((Object)new PercentileKey((PercentileRank)((Object)per)))));
                return new InnerAggregate((AggregateFunction)per, (CompoundAggregate)ranks);
            });
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRules.SkipQueryOnLimitZero {
        SkipQueryOnLimitZero() {
        }

        protected LogicalPlan skipPlan(Limit limit) {
            return Optimizer.skipPlan((UnaryPlan)limit);
        }
    }

    static class SkipQueryForLiteralAggregations
    extends OptimizerRules.OptimizerRule<Aggregate> {
        SkipQueryForLiteralAggregations() {
        }

        protected LogicalPlan rule(Aggregate plan) {
            if (plan.groupings().isEmpty() && plan.child() instanceof EsRelation && plan.aggregates().stream().allMatch(this::foldable)) {
                return plan.replaceChild((LogicalPlan)new LocalRelation(plan.source(), new SingletonExecutable()));
            }
            return plan;
        }

        private boolean foldable(Expression e) {
            if (e instanceof Alias) {
                e = ((Alias)e).child();
            }
            return e.foldable();
        }
    }

    static class PushProjectionsIntoLocalRelation
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        PushProjectionsIntoLocalRelation() {
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            LogicalPlan logicalPlan;
            if ((plan instanceof Project || plan instanceof Aggregate) && (logicalPlan = plan.child()) instanceof LocalRelation) {
                LocalRelation relation = (LocalRelation)logicalPlan;
                List<Object> foldedValues = null;
                if (relation.executable() instanceof SingletonExecutable) {
                    foldedValues = plan instanceof Aggregate ? this.extractLiterals(((Aggregate)plan).aggregates()) : this.extractLiterals(((Project)plan).projections());
                } else if (relation.executable() instanceof EmptyExecutable && plan instanceof Aggregate) {
                    Aggregate agg = (Aggregate)plan;
                    if (agg.groupings().isEmpty()) {
                        foldedValues = this.extractLiterals(agg.aggregates());
                    } else {
                        return new LocalRelation(plan.source(), new EmptyExecutable(plan.output()));
                    }
                }
                if (foldedValues != null) {
                    return new LocalRelation(plan.source(), new SingletonExecutable(plan.output(), foldedValues.toArray()));
                }
            }
            return plan;
        }

        private List<Object> extractLiterals(List<? extends NamedExpression> named) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (NamedExpression namedExpression : named) {
                if (namedExpression instanceof Alias) {
                    Alias a = (Alias)namedExpression;
                    if (a.child().foldable()) {
                        values.add(a.child().fold());
                        continue;
                    }
                    return null;
                }
                if (namedExpression.foldable()) {
                    values.add(namedExpression.fold());
                    continue;
                }
                return null;
            }
            return values;
        }
    }

    static class PruneLiteralsInGroupBy
    extends OptimizerRules.OptimizerRule<Aggregate> {
        PruneLiteralsInGroupBy() {
        }

        protected LogicalPlan rule(Aggregate agg) {
            List groupings = agg.groupings();
            ArrayList<Expression> prunedGroupings = new ArrayList<Expression>();
            for (Expression g : groupings) {
                if (!g.foldable()) continue;
                prunedGroupings.add(g);
            }
            if (prunedGroupings.size() > 0) {
                ArrayList newGroupings = new ArrayList(groupings);
                newGroupings.removeAll(prunedGroupings);
                return new Aggregate(agg.source(), agg.child(), newGroupings, agg.aggregates());
            }
            return agg;
        }
    }

    static abstract class OptimizerBasicRule
    extends Rule<LogicalPlan, LogicalPlan> {
        OptimizerBasicRule() {
        }

        public abstract LogicalPlan apply(LogicalPlan var1);

        protected LogicalPlan rule(LogicalPlan plan) {
            return plan;
        }
    }

    private static class PercentileKey
    extends Tuple<Expression, PercentilesConfig> {
        PercentileKey(Percentile per) {
            super((Object)per.field(), (Object)per.percentilesConfig());
        }

        PercentileKey(PercentileRank per) {
            super((Object)per.field(), (Object)per.percentilesConfig());
        }

        private Expression field() {
            return (Expression)this.v1();
        }

        private PercentilesConfig percentilesConfig() {
            return (PercentilesConfig)this.v2();
        }
    }

    static class CombineLimits
    extends OptimizerRules.OptimizerRule<Limit> {
        CombineLimits() {
        }

        protected LogicalPlan rule(Limit limit) {
            if (limit.child() instanceof Limit) {
                throw new UnsupportedOperationException("not implemented yet");
            }
            throw new UnsupportedOperationException("not implemented yet");
        }
    }
}

