/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.matrix.stats.InternalMatrixStats;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixAggregationInspectionHelper;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.InternalMin;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalStats;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.support.AggregationInspectionHelper;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class MetricAggExtractor
implements BucketExtractor {
    static final String NAME = "m";
    private final String name;
    private final String property;
    private final String innerKey;
    private final DataType dataType;
    private final ZoneId zoneId;

    public MetricAggExtractor(String name, String property, String innerKey, ZoneId zoneId, @Nullable DataType dataType) {
        this.name = name;
        this.property = property;
        this.innerKey = innerKey;
        this.zoneId = zoneId;
        this.dataType = dataType;
    }

    public MetricAggExtractor(String name, String property, String innerKey, ZoneId zoneId) {
        this(name, property, innerKey, zoneId, null);
    }

    MetricAggExtractor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.property = in.readString();
        this.innerKey = in.readOptionalString();
        String typeName = in.readOptionalString();
        this.dataType = typeName != null ? SqlDataTypes.fromTypeName(typeName) : null;
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.property);
        out.writeOptionalString(this.innerKey);
        out.writeOptionalString(this.dataType == null ? null : this.dataType.name());
    }

    String name() {
        return this.name;
    }

    String property() {
        return this.property;
    }

    String innerKey() {
        return this.innerKey;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        InternalAggregation agg = (InternalAggregation)bucket.getAggregations().get(this.name);
        if (agg == null) {
            throw new SqlIllegalArgumentException("Cannot find an aggregation named {}", this.name);
        }
        if (!MetricAggExtractor.containsValues(agg)) {
            return null;
        }
        if (agg instanceof InternalNumericMetricsAggregation.MultiValue) {
            return this.handleTargetType(((InternalNumericMetricsAggregation.MultiValue)agg).value(this.property));
        }
        if (agg instanceof InternalFilter) {
            return ((InternalFilter)agg).getDocCount();
        }
        if (agg instanceof InternalCardinality) {
            return ((InternalCardinality)agg).getValue();
        }
        Object v = agg.getProperty(this.property);
        return this.handleTargetType(this.innerKey != null && v instanceof Map ? ((Map)v).get(this.innerKey) : v);
    }

    private Object handleTargetType(Object object) {
        if (object instanceof Number && this.dataType != null) {
            if (SqlDataTypes.isDateBased(this.dataType)) {
                return DateUtils.asDateTimeWithMillis(((Number)object).longValue(), this.zoneId);
            }
            if (this.dataType.isInteger()) {
                return SqlDataTypeConverter.convert(object, this.dataType);
            }
        }
        return object;
    }

    private static boolean containsValues(InternalAggregation agg) {
        if (agg instanceof InternalStats) {
            return AggregationInspectionHelper.hasValue((InternalStats)((InternalStats)agg));
        }
        if (agg instanceof InternalMatrixStats) {
            return MatrixAggregationInspectionHelper.hasValue((InternalMatrixStats)((InternalMatrixStats)agg));
        }
        if (agg instanceof InternalMax) {
            return AggregationInspectionHelper.hasValue((InternalMax)((InternalMax)agg));
        }
        if (agg instanceof InternalMin) {
            return AggregationInspectionHelper.hasValue((InternalMin)((InternalMin)agg));
        }
        if (agg instanceof InternalAvg) {
            return AggregationInspectionHelper.hasValue((InternalAvg)((InternalAvg)agg));
        }
        if (agg instanceof Sum) {
            return AggregationInspectionHelper.hasValue((Sum)((Sum)agg));
        }
        if (agg instanceof InternalTDigestPercentileRanks) {
            return AggregationInspectionHelper.hasValue((InternalTDigestPercentileRanks)((InternalTDigestPercentileRanks)agg));
        }
        if (agg instanceof InternalTDigestPercentiles) {
            return AggregationInspectionHelper.hasValue((InternalTDigestPercentiles)((InternalTDigestPercentiles)agg));
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.property, this.innerKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetricAggExtractor other = (MetricAggExtractor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.property, other.property) && Objects.equals(this.innerKey, other.innerKey);
    }

    public String toString() {
        String i = this.innerKey != null ? "[" + this.innerKey + "]" : "";
        return "groupby>" + this.name + "." + this.property + i;
    }
}

