/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.Base64;
import org.elasticsearch.Version;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class SqlStreamInput
extends NamedWriteableAwareStreamInput {
    private final ZoneId zoneId;

    public static SqlStreamInput fromString(String base64encoded, NamedWriteableRegistry namedWriteableRegistry, Version version) throws IOException {
        byte[] bytes = Base64.getDecoder().decode(base64encoded);
        StreamInput in = StreamInput.wrap((byte[])bytes);
        Version inVersion = Version.readVersion((StreamInput)in);
        if (version.compareTo(inVersion) != 0) {
            throw new SqlIllegalArgumentException("Unsupported cursor version [{}], expected [{}]", inVersion, version);
        }
        InputStreamStreamInput uncompressingIn = new InputStreamStreamInput(CompressorFactory.COMPRESSOR.threadLocalInputStream((InputStream)in));
        return new SqlStreamInput((StreamInput)uncompressingIn, namedWriteableRegistry, inVersion);
    }

    private SqlStreamInput(StreamInput input, NamedWriteableRegistry namedWriteableRegistry, Version version) throws IOException {
        super(input, namedWriteableRegistry);
        this.delegate.setVersion(version);
        this.zoneId = this.delegate.readZoneId();
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public static SqlStreamInput asSqlStream(StreamInput in) {
        if (in instanceof SqlStreamInput) {
            return (SqlStreamInput)in;
        }
        throw new SqlIllegalArgumentException("Expected SQL cursor stream, received [{}]", in.getClass());
    }
}

