/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.analyzer.VerifierChecks;
import org.elasticsearch.xpack.ql.capabilities.Unresolvable;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.Functions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.FullTextPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.expression.Exists;
import org.elasticsearch.xpack.sql.expression.function.Score;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Kurtosis;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Skewness;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.plan.logical.Distinct;
import org.elasticsearch.xpack.sql.plan.logical.Having;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.stats.FeatureMetric;
import org.elasticsearch.xpack.sql.stats.Metrics;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public final class Verifier {
    private final Metrics metrics;

    public Verifier(Metrics metrics) {
        this.metrics = metrics;
    }

    public Map<Node<?>, String> verifyFailures(LogicalPlan plan) {
        Collection<Failure> failures = this.verify(plan);
        return failures.stream().collect(Collectors.toMap(Failure::node, Failure::message));
    }

    Collection<Failure> verify(LogicalPlan plan) {
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        plan.forEachUp(p -> {
            if (p.analyzed()) {
                return;
            }
            if (!p.childrenResolved()) {
                return;
            }
            LinkedHashSet<Failure> localFailures = new LinkedHashSet<Failure>();
            if (p instanceof Unresolvable) {
                localFailures.add(Failure.fail((Node)p, (String)((Unresolvable)p).unresolvedMessage(), (Object[])new Object[0]));
            } else if (p instanceof Distinct) {
                localFailures.add(Failure.fail((Node)p, (String)"SELECT DISTINCT is not yet supported", (Object[])new Object[0]));
            } else {
                p.forEachExpression(e -> {
                    if (e.resolved()) {
                        return;
                    }
                    e.forEachUp(ae -> {
                        if (!ae.childrenResolved()) {
                            return;
                        }
                        if (ae instanceof Unresolvable) {
                            UnresolvedAttribute ua;
                            if (ae instanceof UnresolvedAttribute && !(ua = (UnresolvedAttribute)ae).customMessage()) {
                                boolean useQualifier = ua.qualifier() != null;
                                ArrayList<String> potentialMatches = new ArrayList<String>();
                                for (Attribute a : p.inputSet()) {
                                    String nameCandidate;
                                    String string = nameCandidate = useQualifier ? a.qualifiedName() : a.name();
                                    if (DataTypes.isUnsupported((DataType)a.dataType()) || !DataTypes.isPrimitive((DataType)a.dataType())) continue;
                                    potentialMatches.add(nameCandidate);
                                }
                                List matches = StringUtils.findSimilar((String)ua.qualifiedName(), potentialMatches);
                                if (!matches.isEmpty()) {
                                    ae = ua.withUnresolvedMessage(UnresolvedAttribute.errorMessage((String)ua.qualifiedName(), (List)matches));
                                }
                            }
                            localFailures.add(Failure.fail((Node)ae, (String)((Unresolvable)ae).unresolvedMessage(), (Object[])new Object[0]));
                            return;
                        }
                        if (ae.typeResolved().unresolved()) {
                            localFailures.add(Failure.fail((Node)ae, (String)ae.typeResolved().message(), (Object[])new Object[0]));
                        } else if (ae instanceof Exists) {
                            localFailures.add(Failure.fail((Node)ae, (String)"EXISTS is not yet supported", (Object[])new Object[0]));
                        }
                    });
                });
            }
            failures.addAll(localFailures);
        });
        if (failures.isEmpty()) {
            LinkedHashSet<Failure> localFailures = new LinkedHashSet<Failure>();
            AttributeMap.Builder collectRefs = AttributeMap.builder();
            this.checkFullTextSearchInSelect(plan, localFailures);
            plan.forEachExpressionUp(Alias.class, a -> collectRefs.put(a.toAttribute(), (Object)a.child()));
            AttributeMap attributeRefs = collectRefs.build();
            LinkedHashSet groupingFailures = new LinkedHashSet();
            plan.forEachDown(p -> {
                if (p.analyzed()) {
                    return;
                }
                if (!p.childrenResolved()) {
                    return;
                }
                VerifierChecks.checkFilterConditionType((LogicalPlan)p, (Set)localFailures);
                Verifier.checkGroupingFunctionInGroupBy(p, localFailures);
                Verifier.checkFilterOnAggs(p, localFailures, (AttributeMap<Expression>)attributeRefs);
                Verifier.checkFilterOnGrouping(p, localFailures, (AttributeMap<Expression>)attributeRefs);
                this.checkNestedAggregation((LogicalPlan)p, (Set<Failure>)localFailures, (AttributeMap<Expression>)attributeRefs);
                if (!groupingFailures.contains(p)) {
                    Verifier.checkGroupBy(p, localFailures, (AttributeMap<Expression>)attributeRefs, groupingFailures);
                }
                Verifier.checkForScoreInsideFunctions(p, localFailures);
                Verifier.checkNestedUsedInGroupByOrHavingOrWhereOrOrderBy(p, localFailures, (AttributeMap<Expression>)attributeRefs);
                Verifier.checkForGeoFunctionsOnDocValues(p, localFailures);
                Verifier.checkPivot(p, localFailures, (AttributeMap<Expression>)attributeRefs);
                Verifier.checkMatrixStats(p, localFailures);
                Verifier.checkCastOnInexact(p, localFailures);
                Verifier.checkBinaryHasDocValues(p, localFailures);
                if (localFailures.isEmpty()) {
                    p.setAnalyzed();
                }
                failures.addAll(localFailures);
            });
        }
        if (failures.isEmpty()) {
            BitSet b = new BitSet(FeatureMetric.values().length);
            plan.forEachDown(p -> {
                if (p instanceof Aggregate) {
                    b.set(FeatureMetric.GROUPBY.ordinal());
                } else if (p instanceof OrderBy) {
                    b.set(FeatureMetric.ORDERBY.ordinal());
                } else if (p instanceof Filter) {
                    if (((Filter)p).child() instanceof Aggregate) {
                        b.set(FeatureMetric.HAVING.ordinal());
                    } else {
                        b.set(FeatureMetric.WHERE.ordinal());
                    }
                } else if (p instanceof Limit) {
                    b.set(FeatureMetric.LIMIT.ordinal());
                } else if (p instanceof LocalRelation) {
                    b.set(FeatureMetric.LOCAL.ordinal());
                } else if (p instanceof Command) {
                    b.set(FeatureMetric.COMMAND.ordinal());
                }
            });
            int i = b.nextSetBit(0);
            while (i >= 0) {
                this.metrics.inc(FeatureMetric.values()[i]);
                i = b.nextSetBit(i + 1);
            }
        }
        return failures;
    }

    private void checkNestedAggregation(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        if (p instanceof Aggregate) {
            ((Aggregate)p).child().forEachDown(Aggregate.class, a -> localFailures.add(Failure.fail((Node)a, (String)"Nested aggregations in sub-selects are not supported.", (Object[])new Object[0])));
        }
    }

    private void checkFullTextSearchInSelect(LogicalPlan plan, Set<Failure> localFailures) {
        plan.forEachUp(Project.class, p -> {
            for (NamedExpression ne : p.projections()) {
                ne.forEachUp(FullTextPredicate.class, e -> localFailures.add(Failure.fail((Node)e, (String)"Cannot use MATCH() or QUERY() full-text search functions in the SELECT clause", (Object[])new Object[0])));
            }
        });
    }

    private static boolean checkGroupBy(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs, Set<LogicalPlan> groupingFailures) {
        return Verifier.checkGroupByInexactField(p, localFailures) && Verifier.checkGroupByAgg(p, localFailures, attributeRefs) && Verifier.checkGroupByOrder(p, localFailures, groupingFailures, attributeRefs) && Verifier.checkGroupByHaving(p, localFailures, groupingFailures, attributeRefs) && Verifier.checkGroupByTime(p, localFailures);
    }

    private static boolean checkGroupByOrder(LogicalPlan p, Set<Failure> localFailures, Set<LogicalPlan> groupingFailures, AttributeMap<Expression> attributeRefs) {
        if (p instanceof OrderBy) {
            OrderBy o = (OrderBy)p;
            LogicalPlan child = o.child();
            if (child instanceof Project) {
                child = ((Project)child).child();
            }
            if (child instanceof Filter) {
                child = ((Filter)child).child();
            }
            if (child instanceof Aggregate) {
                Aggregate a = (Aggregate)child;
                LinkedHashMap missing = new LinkedHashMap();
                o.order().forEach(oe -> {
                    Expression e = oe.child();
                    Expression resolvedE = (Expression)attributeRefs.resolve((Object)e, (Object)e);
                    if (Functions.isAggregate((Expression)resolvedE)) {
                        return;
                    }
                    ArrayList groupingAndMatchingAggregatesAliases = new ArrayList(a.groupings());
                    a.aggregates().forEach(as -> {
                        if (as instanceof Alias) {
                            Alias al = (Alias)as;
                            if (Expressions.anyMatch((List)a.groupings(), g -> Expressions.equalsAsAttribute((Expression)al.child(), (Expression)g))) {
                                groupingAndMatchingAggregatesAliases.add(al);
                            }
                        }
                    });
                    if (resolvedE.anyMatch(expression -> Expressions.anyMatch((List)groupingAndMatchingAggregatesAliases, g -> {
                        Expression resolvedG = (Expression)attributeRefs.resolve(g, g);
                        resolvedG = expression instanceof Attribute ? Expressions.attribute((Expression)resolvedG) : resolvedG;
                        return expression.semanticEquals(resolvedG);
                    }))) {
                        return;
                    }
                    missing.put(e, oe);
                });
                if (!missing.isEmpty()) {
                    String plural = missing.size() > 1 ? "s" : "";
                    localFailures.add(Failure.fail((Node)((Node)missing.values().iterator().next()), (String)("Cannot order by non-grouped column" + plural + " {}, expected {} or an aggregate function"), (Object[])new Object[]{Expressions.names(missing.keySet()), Expressions.names((Collection)a.groupings())}));
                    groupingFailures.add((LogicalPlan)a);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkGroupByHaving(LogicalPlan p, Set<Failure> localFailures, Set<LogicalPlan> groupingFailures, AttributeMap<Expression> attributeRefs) {
        Having h;
        LogicalPlan logicalPlan;
        if (p instanceof Having && (logicalPlan = (h = (Having)p).child()) instanceof Aggregate) {
            Aggregate a = (Aggregate)logicalPlan;
            LinkedHashSet missing = new LinkedHashSet();
            LinkedHashSet unsupported = new LinkedHashSet();
            Expression condition = h.condition();
            condition.collectFirstChildren(c -> Verifier.checkGroupByHavingHasOnlyAggs(c, missing, unsupported, attributeRefs));
            if (!missing.isEmpty()) {
                String plural = missing.size() > 1 ? "s" : "";
                localFailures.add(Failure.fail((Node)condition, (String)("Cannot use HAVING filter on non-aggregate" + plural + " {}; use WHERE instead"), (Object[])new Object[]{Expressions.names(missing)}));
                groupingFailures.add((LogicalPlan)a);
                return false;
            }
            if (!unsupported.isEmpty()) {
                String plural = unsupported.size() > 1 ? "s" : "";
                localFailures.add(Failure.fail((Node)condition, (String)("HAVING filter is unsupported for function" + plural + " {}"), (Object[])new Object[]{Expressions.names(unsupported)}));
                groupingFailures.add((LogicalPlan)a);
                return false;
            }
        }
        return true;
    }

    private static boolean checkGroupByHavingHasOnlyAggs(Expression e, Set<Expression> missing, Set<Expression> unsupported, AttributeMap<Expression> attributeRefs) {
        if (e instanceof ReferenceAttribute) {
            e = (Expression)attributeRefs.resolve((Object)e);
        }
        if (e instanceof ScalarFunction) {
            ScalarFunction sf = (ScalarFunction)e;
            for (Expression arg : sf.arguments()) {
                arg.collectFirstChildren(c -> Verifier.checkGroupByHavingHasOnlyAggs(c, missing, unsupported, attributeRefs));
            }
            return true;
        }
        if (e instanceof Score) {
            unsupported.add(e);
            return true;
        }
        if (e instanceof TopHits) {
            unsupported.add(e);
            return true;
        }
        if ((e instanceof Min || e instanceof Max) && DataTypes.isString((DataType)((AggregateFunction)e).field().dataType())) {
            unsupported.add(e);
            return true;
        }
        if (e.foldable()) {
            return true;
        }
        if (Functions.isAggregate((Expression)e) || Functions.isGrouping((Expression)e)) {
            return true;
        }
        if (e instanceof Attribute) {
            missing.add(e);
            return true;
        }
        return false;
    }

    private static boolean checkGroupByInexactField(LogicalPlan p, Set<Failure> localFailures) {
        if (p instanceof Aggregate) {
            return Verifier.onlyExactFields(((Aggregate)p).groupings(), localFailures);
        }
        return true;
    }

    private static boolean onlyExactFields(List<Expression> expressions, Set<Failure> localFailures) {
        Holder onlyExact = new Holder((Object)Boolean.TRUE);
        expressions.forEach(e -> e.forEachUp(FieldAttribute.class, c -> {
            EsField.Exact exact = c.getExactInfo();
            if (!exact.hasExact()) {
                localFailures.add(Failure.fail((Node)c, (String)"Field [{}] of data type [{}] cannot be used for grouping; {}", (Object[])new Object[]{c.sourceText(), c.dataType().typeName(), exact.errorMsg()}));
                onlyExact.set((Object)Boolean.FALSE);
            }
        }));
        return (Boolean)onlyExact.get();
    }

    private static boolean onlyRawFields(Iterable<? extends Expression> expressions, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        Holder onlyExact = new Holder((Object)Boolean.TRUE);
        expressions.forEach(e -> e.forEachDown(c -> {
            if (c instanceof ReferenceAttribute) {
                c = (Expression)attributeRefs.resolve(c, c);
            }
            if (c instanceof Function) {
                localFailures.add(Failure.fail((Node)c, (String)"No functions allowed (yet); encountered [{}]", (Object[])new Object[]{c.sourceText()}));
                onlyExact.set((Object)Boolean.FALSE);
            }
        }));
        return (Boolean)onlyExact.get();
    }

    private static boolean checkGroupByTime(LogicalPlan p, Set<Failure> localFailures) {
        if (p instanceof Aggregate) {
            Aggregate a = (Aggregate)p;
            a.groupings().forEach(f -> {
                if (f.dataType() == SqlDataTypes.TIME) {
                    localFailures.add(Failure.fail((Node)f, (String)("Function [" + f.sourceText() + "] with data type [" + f.dataType().typeName() + "] cannot be used for grouping"), (Object[])new Object[0]));
                }
            });
        }
        return true;
    }

    private static boolean checkGroupByAgg(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        if (p instanceof Aggregate) {
            Aggregate a = (Aggregate)p;
            a.groupings().forEach(e -> e.forEachUp(c -> {
                if (Functions.isAggregate((Expression)c)) {
                    localFailures.add(Failure.fail((Node)c, (String)("Cannot use an aggregate [" + c.nodeName().toUpperCase(Locale.ROOT) + "] for grouping"), (Object[])new Object[0]));
                }
                if (c instanceof Score) {
                    localFailures.add(Failure.fail((Node)c, (String)"Cannot use [SCORE()] for grouping", (Object[])new Object[0]));
                }
            }));
            a.groupings().forEach(e -> {
                if (!Functions.isGrouping((Expression)e)) {
                    e.collectFirstChildren(c -> {
                        if (Functions.isGrouping((Expression)c)) {
                            localFailures.add(Failure.fail((Node)c, (String)"Cannot combine [{}] grouping function inside GROUP BY, found [{}]; consider moving the expression inside the histogram", (Object[])new Object[]{Expressions.name((Expression)c), Expressions.name((Expression)e)}));
                            return true;
                        }
                        return false;
                    });
                }
            });
            if (!localFailures.isEmpty()) {
                return false;
            }
            LinkedHashMap missing = new LinkedHashMap();
            a.aggregates().forEach(ne -> ne.collectFirstChildren(c -> Verifier.checkGroupMatch(c, ne, a.groupings(), missing, attributeRefs)));
            if (!missing.isEmpty()) {
                String plural = missing.size() > 1 ? "s" : "";
                localFailures.add(Failure.fail((Node)((Node)missing.values().iterator().next()), (String)("Cannot use non-grouped column" + plural + " {}, expected {}"), (Object[])new Object[]{Expressions.names(missing.keySet()), Expressions.names((Collection)a.groupings())}));
                return false;
            }
        }
        return true;
    }

    private static boolean checkGroupMatch(Expression e, Node<?> source, List<Expression> groupings, Map<Expression, Node<?>> missing, AttributeMap<Expression> attributeRefs) {
        if (Expressions.match(groupings, arg_0 -> ((Expression)e).semanticEquals(arg_0))) {
            return true;
        }
        if (e instanceof ReferenceAttribute) {
            e = (Expression)attributeRefs.resolve((Object)e);
        }
        if (e instanceof ScalarFunction) {
            ScalarFunction sf = (ScalarFunction)e;
            if (Expressions.anyMatch(groupings, arg_0 -> ((Expression)e).semanticEquals(arg_0))) {
                return true;
            }
            for (Expression arg : sf.arguments()) {
                arg.collectFirstChildren(c -> Verifier.checkGroupMatch(c, source, groupings, missing, attributeRefs));
            }
            return true;
        }
        if (e instanceof Score) {
            missing.put(e, source);
            return true;
        }
        if (e.foldable()) {
            return true;
        }
        if (Functions.isAggregate((Expression)e)) {
            return true;
        }
        Expression exp = e;
        if (e.children().isEmpty()) {
            if (!Expressions.match(groupings, c -> exp.semanticEquals((Expression)(exp instanceof Attribute ? Expressions.attribute((Expression)c) : c)))) {
                missing.put(exp, source);
            }
            return true;
        }
        return false;
    }

    private static void checkGroupingFunctionInGroupBy(LogicalPlan p, Set<Failure> localFailures) {
        if (p instanceof Project) {
            Project proj = (Project)p;
            proj.projections().forEach(e -> e.forEachDown(GroupingFunction.class, f -> localFailures.add(Failure.fail((Node)f, (String)"[{}] needs to be part of the grouping", (Object[])new Object[]{Expressions.name((Expression)f)}))));
        } else if (p instanceof Aggregate) {
            Aggregate a = (Aggregate)p;
            a.aggregates().forEach(agg -> agg.forEachDown(GroupingFunction.class, e -> {
                if (a.groupings().size() == 0 || !Expressions.anyMatch((List)a.groupings(), g -> g instanceof Function && e.equals(g))) {
                    localFailures.add(Failure.fail((Node)e, (String)"[{}] needs to be part of the grouping", (Object[])new Object[]{Expressions.name((Expression)e)}));
                } else {
                    Verifier.checkGroupingFunctionTarget(e, localFailures);
                }
            }));
            a.groupings().forEach(g -> g.forEachDown(GroupingFunction.class, e -> Verifier.checkGroupingFunctionTarget(e, localFailures)));
        }
    }

    private static void checkGroupingFunctionTarget(GroupingFunction f, Set<Failure> localFailures) {
        f.field().forEachDown(e -> {
            if (e instanceof GroupingFunction) {
                localFailures.add(Failure.fail((Node)f.field(), (String)"Cannot embed grouping functions within each other, found [{}] in [{}]", (Object[])new Object[]{Expressions.name((Expression)f.field()), Expressions.name((Expression)f)}));
            }
        });
    }

    private static void checkFilterOnAggs(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        if (p instanceof Filter) {
            Filter filter = (Filter)p;
            if (!filter.anyMatch(Aggregate.class::isInstance)) {
                filter.condition().forEachDown(Expression.class, e -> {
                    if (Functions.isAggregate((Expression)((Expression)attributeRefs.resolve(e, e)))) {
                        if (filter.child() instanceof Project) {
                            filter.condition().forEachDown(FieldAttribute.class, f -> localFailures.add(Failure.fail((Node)e, (String)"[{}] field must appear in the GROUP BY clause or in an aggregate function", (Object[])new Object[]{Expressions.name((Expression)f)})));
                        } else {
                            localFailures.add(Failure.fail((Node)e, (String)"Cannot use WHERE filtering on aggregate function [{}], use HAVING instead", (Object[])new Object[]{Expressions.name((Expression)e)}));
                        }
                    }
                });
            } else {
                LinkedHashSet unsupported = new LinkedHashSet();
                filter.condition().forEachDown(Expression.class, e -> {
                    Expression f = (Expression)attributeRefs.resolve(e, e);
                    if (f instanceof TopHits) {
                        unsupported.add(f);
                    }
                });
                if (!unsupported.isEmpty()) {
                    String plural = unsupported.size() > 1 ? "s" : "";
                    localFailures.add(Failure.fail((Node)filter.condition(), (String)("filtering is unsupported for function" + plural + " {}"), (Object[])new Object[]{Expressions.names(unsupported)}));
                }
            }
        }
    }

    private static void checkFilterOnGrouping(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        if (p instanceof Filter) {
            Filter filter = (Filter)p;
            filter.condition().forEachDown(Expression.class, e -> {
                if (Functions.isGrouping((Expression)((Expression)attributeRefs.resolve(e, e)))) {
                    localFailures.add(Failure.fail((Node)e, (String)"Cannot filter on grouping function [{}], use its argument instead", (Object[])new Object[]{Expressions.name((Expression)e)}));
                }
            });
        }
    }

    private static void checkForScoreInsideFunctions(LogicalPlan p, Set<Failure> localFailures) {
        p.forEachExpression(Function.class, f -> f.arguments().stream().filter(exp -> exp.anyMatch(Score.class::isInstance)).forEach(exp -> localFailures.add(Failure.fail((Node)exp, (String)"[SCORE()] cannot be used in expressions, does not support further processing", (Object[])new Object[0]))));
    }

    private static void checkNestedUsedInGroupByOrHavingOrWhereOrOrderBy(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        ArrayList nested = new ArrayList();
        Consumer<FieldAttribute> matchNested = fa -> {
            if (fa.isNested()) {
                nested.add(fa);
            }
        };
        Consumer<Expression> checkForNested = e -> ((Expression)attributeRefs.resolve(e, e)).forEachUp(FieldAttribute.class, matchNested);
        Consumer<ScalarFunction> checkForNestedInFunction = f -> f.arguments().forEach(arg -> arg.forEachUp(FieldAttribute.class, matchNested));
        p.forEachDown(Aggregate.class, a -> a.groupings().forEach(agg -> agg.forEachUp(checkForNested)));
        if (!nested.isEmpty()) {
            localFailures.add(Failure.fail((Node)((Node)nested.get(0)), (String)("Grouping isn't (yet) compatible with nested fields " + new AttributeSet(nested).names()), (Object[])new Object[0]));
            nested.clear();
        }
        p.forEachDown(Filter.class, f -> f.forEachDown(Aggregate.class, a -> f.condition().forEachUp(checkForNested)));
        if (!nested.isEmpty()) {
            localFailures.add(Failure.fail((Node)((Node)nested.get(0)), (String)("HAVING isn't (yet) compatible with nested fields " + new AttributeSet(nested).names()), (Object[])new Object[0]));
            nested.clear();
        }
        p.forEachDown(Filter.class, f -> f.condition().forEachUp(e -> ((Expression)attributeRefs.resolve(e, e)).forEachUp(ScalarFunction.class, sf -> {
            if (!(sf instanceof BinaryComparison || sf instanceof IsNull || sf instanceof IsNotNull || sf instanceof Not || sf instanceof BinaryLogic)) {
                checkForNestedInFunction.accept((ScalarFunction)sf);
            }
        })));
        if (!nested.isEmpty()) {
            localFailures.add(Failure.fail((Node)((Node)nested.get(0)), (String)("WHERE isn't (yet) compatible with scalar functions on nested fields " + new AttributeSet(nested).names()), (Object[])new Object[0]));
            nested.clear();
        }
        p.forEachDown(OrderBy.class, ob -> ob.order().forEach(o -> o.forEachUp(e -> ((Expression)attributeRefs.resolve(e, e)).forEachUp(ScalarFunction.class, checkForNestedInFunction))));
        if (!nested.isEmpty()) {
            localFailures.add(Failure.fail((Node)((Node)nested.get(0)), (String)("ORDER BY isn't (yet) compatible with scalar functions on nested fields " + new AttributeSet(nested).names()), (Object[])new Object[0]));
        }
    }

    private static void checkForGeoFunctionsOnDocValues(LogicalPlan p, Set<Failure> localFailures) {
        p.forEachDown(Filter.class, f -> f.condition().forEachUp(FieldAttribute.class, fa -> {
            if (fa.field().getDataType() == SqlDataTypes.GEO_SHAPE) {
                localFailures.add(Failure.fail((Node)fa, (String)"geo shapes cannot be used for filtering", (Object[])new Object[0]));
            }
            if (fa.field().getDataType() == SqlDataTypes.SHAPE) {
                localFailures.add(Failure.fail((Node)fa, (String)"shapes cannot be used for filtering", (Object[])new Object[0]));
            }
        }));
        p.forEachDown(Aggregate.class, a -> a.groupings().forEach(agg -> agg.forEachUp(FieldAttribute.class, fa -> {
            if (fa.field().getDataType() == SqlDataTypes.GEO_SHAPE) {
                localFailures.add(Failure.fail((Node)fa, (String)"geo shapes cannot be used in grouping", (Object[])new Object[0]));
            }
            if (fa.field().getDataType() == SqlDataTypes.SHAPE) {
                localFailures.add(Failure.fail((Node)fa, (String)"shapes cannot be used in grouping", (Object[])new Object[0]));
            }
        })));
        p.forEachDown(OrderBy.class, o -> o.order().forEach(agg -> agg.forEachUp(FieldAttribute.class, fa -> {
            if (fa.field().getDataType() == SqlDataTypes.GEO_SHAPE) {
                localFailures.add(Failure.fail((Node)fa, (String)"geo shapes cannot be used for sorting", (Object[])new Object[0]));
            }
            if (fa.field().getDataType() == SqlDataTypes.SHAPE) {
                localFailures.add(Failure.fail((Node)fa, (String)"shapes cannot be used for sorting", (Object[])new Object[0]));
            }
        })));
    }

    private static void checkPivot(LogicalPlan p, Set<Failure> localFailures, AttributeMap<Expression> attributeRefs) {
        p.forEachDown(Pivot.class, pv -> {
            if (!Verifier.onlyExactFields(CollectionUtils.combine((Collection)pv.groupingSet(), (Object[])new Expression[]{pv.column()}), localFailures) || !Verifier.onlyRawFields((Iterable<? extends Expression>)pv.groupingSet(), localFailures, attributeRefs)) {
                return;
            }
            DataType colType = pv.column().dataType();
            for (NamedExpression v : pv.values()) {
                NamedExpression ex;
                Object object = ex = v instanceof Alias ? ((Alias)v).child() : v;
                if (!(ex instanceof Literal)) {
                    localFailures.add(Failure.fail((Node)v, (String)"Non-literal [{}] found inside PIVOT values", (Object[])new Object[]{v.name()}));
                    continue;
                }
                if (ex.foldable() && ex.fold() == null) {
                    localFailures.add(Failure.fail((Node)v, (String)"Null not allowed as a PIVOT value", (Object[])new Object[]{v.name()}));
                    continue;
                }
                if (SqlDataTypes.areCompatible(colType, v.dataType())) continue;
                localFailures.add(Failure.fail((Node)v, (String)"Literal [{}] of type [{}] does not match type [{}] of PIVOT column [{}]", (Object[])new Object[]{v.name(), v.dataType().typeName(), colType.typeName(), pv.column().sourceText()}));
            }
            pv.aggregates().forEach(a -> {
                Holder hasAggs = new Holder((Object)Boolean.FALSE);
                List aggs = a.collectFirstChildren(c -> {
                    if (Functions.isAggregate((Expression)c)) {
                        hasAggs.set((Object)Boolean.TRUE);
                        return true;
                    }
                    return c.children().isEmpty();
                });
                if (Boolean.FALSE.equals(hasAggs.get())) {
                    localFailures.add(Failure.fail((Node)a, (String)"No aggregate function found in PIVOT at [{}]", (Object[])new Object[]{a.sourceText()}));
                } else {
                    for (Expression agg : aggs) {
                        if (!(agg instanceof FieldAttribute)) continue;
                        localFailures.add(Failure.fail((Node)a, (String)"Non-aggregate function found in PIVOT at [{}]", (Object[])new Object[]{a.sourceText()}));
                    }
                }
            });
        });
    }

    private static void checkMatrixStats(LogicalPlan p, Set<Failure> localFailures) {
        p.forEachExpressionUp(NumericAggregate.class, s -> {
            if ((s instanceof Kurtosis || s instanceof Skewness) && s.field() instanceof Function) {
                localFailures.add(Failure.fail((Node)s.field(), (String)"[{}()] cannot be used on top of operators or scalars", (Object[])new Object[]{s.functionName()}));
            }
        });
    }

    private static void checkCastOnInexact(LogicalPlan p, Set<Failure> localFailures) {
        p.forEachDown(Filter.class, f -> f.forEachExpressionUp(Cast.class, c -> {
            EsField.Exact exactInfo;
            if (!(!(c.field() instanceof FieldAttribute) || (exactInfo = ((FieldAttribute)c.field()).getExactInfo()).hasExact() && ((FieldAttribute)c.field()).exactAttribute().equals((Object)c.field()))) {
                localFailures.add(Failure.fail((Node)c.field(), (String)"[{}] of data type [{}] cannot be used for [{}()] inside the WHERE clause", (Object[])new Object[]{c.field().sourceText(), c.field().dataType().typeName(), c.functionName()}));
            }
        }));
    }

    private static void checkBinaryHasDocValues(LogicalPlan plan, Set<Failure> localFailures) {
        ArrayList fields = new ArrayList();
        plan.forEachDown(Filter.class, e -> e.condition().forEachDown(FieldAttribute.class, f -> fields.add(Tuple.tuple((Object)f, (Object)"for filtering"))));
        plan.forEachDown(Aggregate.class, e -> e.groupings().forEach(g -> g.forEachDown(FieldAttribute.class, f -> fields.add(Tuple.tuple((Object)f, (Object)"in aggregations")))));
        plan.forEachDown(OrderBy.class, e -> e.order().forEach(o -> o.child().forEachDown(FieldAttribute.class, f -> fields.add(Tuple.tuple((Object)f, (Object)"for ordering")))));
        fields.stream().filter(t -> ((FieldAttribute)t.v1()).dataType() == DataTypes.BINARY && !((FieldAttribute)t.v1()).field().isAggregatable()).forEach(t -> localFailures.add(Failure.fail((Node)((Node)t.v1()), (String)("Binary field [" + ((FieldAttribute)t.v1()).name() + "] cannot be used " + (String)t.v2() + " unless it has the doc_values setting enabled"), (Object[])new Object[0])));
    }
}

