/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.CreateDataStreamAction;
import org.elasticsearch.action.datastreams.DataStreamsStatsAction;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.datastreams.MigrateToDataStreamAction;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.datastreams.PromoteDataStreamAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.datastreams.DataStreamIndexSettingsProvider;
import org.elasticsearch.datastreams.action.CreateDataStreamTransportAction;
import org.elasticsearch.datastreams.action.DataStreamsStatsTransportAction;
import org.elasticsearch.datastreams.action.DeleteDataStreamTransportAction;
import org.elasticsearch.datastreams.action.GetDataStreamsTransportAction;
import org.elasticsearch.datastreams.action.MigrateToDataStreamTransportAction;
import org.elasticsearch.datastreams.action.ModifyDataStreamsTransportAction;
import org.elasticsearch.datastreams.action.PromoteDataStreamTransportAction;
import org.elasticsearch.datastreams.rest.RestCreateDataStreamAction;
import org.elasticsearch.datastreams.rest.RestDataStreamsStatsAction;
import org.elasticsearch.datastreams.rest.RestDeleteDataStreamAction;
import org.elasticsearch.datastreams.rest.RestGetDataStreamsAction;
import org.elasticsearch.datastreams.rest.RestMigrateToDataStreamAction;
import org.elasticsearch.datastreams.rest.RestModifyDataStreamsAction;
import org.elasticsearch.datastreams.rest.RestPromoteDataStreamAction;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class DataStreamsPlugin
extends Plugin
implements ActionPlugin {
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler createDsAction = new ActionPlugin.ActionHandler((ActionType)CreateDataStreamAction.INSTANCE, CreateDataStreamTransportAction.class);
        ActionPlugin.ActionHandler deleteDsInfoAction = new ActionPlugin.ActionHandler((ActionType)DeleteDataStreamAction.INSTANCE, DeleteDataStreamTransportAction.class);
        ActionPlugin.ActionHandler getDsAction = new ActionPlugin.ActionHandler((ActionType)GetDataStreamAction.INSTANCE, GetDataStreamsTransportAction.class);
        ActionPlugin.ActionHandler dsStatsAction = new ActionPlugin.ActionHandler((ActionType)DataStreamsStatsAction.INSTANCE, DataStreamsStatsTransportAction.class);
        ActionPlugin.ActionHandler migrateAction = new ActionPlugin.ActionHandler((ActionType)MigrateToDataStreamAction.INSTANCE, MigrateToDataStreamTransportAction.class);
        ActionPlugin.ActionHandler promoteAction = new ActionPlugin.ActionHandler((ActionType)PromoteDataStreamAction.INSTANCE, PromoteDataStreamTransportAction.class);
        ActionPlugin.ActionHandler modifyAction = new ActionPlugin.ActionHandler((ActionType)ModifyDataStreamsAction.INSTANCE, ModifyDataStreamsTransportAction.class);
        return List.of(createDsAction, deleteDsInfoAction, getDsAction, dsStatsAction, migrateAction, promoteAction, modifyAction);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestCreateDataStreamAction createDsAction = new RestCreateDataStreamAction();
        RestDeleteDataStreamAction deleteDsAction = new RestDeleteDataStreamAction();
        RestGetDataStreamsAction getDsAction = new RestGetDataStreamsAction();
        RestDataStreamsStatsAction dsStatsAction = new RestDataStreamsStatsAction();
        RestMigrateToDataStreamAction migrateAction = new RestMigrateToDataStreamAction();
        RestPromoteDataStreamAction promoteAction = new RestPromoteDataStreamAction();
        RestModifyDataStreamsAction modifyAction = new RestModifyDataStreamsAction();
        return List.of(createDsAction, deleteDsAction, getDsAction, dsStatsAction, migrateAction, promoteAction, modifyAction);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders() {
        return List.of(new DataStreamIndexSettingsProvider());
    }
}

