/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;

public class DataStreamIndexSettingsProvider
implements IndexSettingProvider {
    static final DateFormatter FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;

    public Settings getAdditionalIndexSettings(String indexName, String dataStreamName, IndexMode templateIndexMode, Metadata metadata, long resolvedAt, Settings allSettings) {
        DataStream dataStream;
        IndexMode indexMode;
        if (dataStreamName != null && (indexMode = (dataStream = (DataStream)metadata.dataStreams().get(dataStreamName)) != null ? dataStream.getIndexMode() : templateIndexMode) != null) {
            Settings.Builder builder = Settings.builder();
            builder.put(IndexSettings.MODE.getKey(), (Enum)indexMode);
            if (indexMode == IndexMode.TIME_SERIES) {
                Instant start;
                TimeValue lookAheadTime = (TimeValue)IndexSettings.LOOK_AHEAD_TIME.get(allSettings);
                if (dataStream == null) {
                    start = Instant.ofEpochMilli(resolvedAt).minusMillis(lookAheadTime.getMillis());
                } else {
                    IndexMetadata currentLatestBackingIndex = metadata.index(dataStream.getWriteIndex());
                    if (!currentLatestBackingIndex.getSettings().hasValue(IndexSettings.TIME_SERIES_END_TIME.getKey())) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "backing index [%s] in tsdb mode doesn't have the [%s] index setting", currentLatestBackingIndex.getIndex().getName(), IndexSettings.TIME_SERIES_END_TIME.getKey()));
                    }
                    start = (Instant)IndexSettings.TIME_SERIES_END_TIME.get(currentLatestBackingIndex.getSettings());
                }
                builder.put(IndexSettings.TIME_SERIES_START_TIME.getKey(), FORMATTER.format((TemporalAccessor)start));
                Instant end = Instant.ofEpochMilli(resolvedAt).plusMillis(lookAheadTime.getMillis());
                builder.put(IndexSettings.TIME_SERIES_END_TIME.getKey(), FORMATTER.format((TemporalAccessor)end));
            }
            return builder.build();
        }
        return Settings.EMPTY;
    }
}

