/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureWriteTimeoutHandler";
    private static final String WRITE_TIMED_OUT_MESSAGE = "Channel write operation timed out after %d milliseconds.";
    private final ChannelFutureListener writeListener = future -> {
        this.lastWriteMillis = System.currentTimeMillis();
    };
    private final long timeoutMillis;
    private long lastWriteMillis;
    private long lastWriteProgress;
    private ScheduledFuture<?> writeTimeoutWatcher;

    public WriteTimeoutHandler(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener)this.writeListener);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.timeoutMillis > 0L) {
            this.writeTimeoutWatcher = ctx.executor().scheduleAtFixedRate(() -> this.writeTimeoutRunnable(ctx), this.timeoutMillis, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.writeTimeoutWatcher != null && !this.writeTimeoutWatcher.isDone()) {
            this.writeTimeoutWatcher.cancel(false);
            this.writeTimeoutWatcher = null;
        }
    }

    private void writeTimeoutRunnable(ChannelHandlerContext ctx) {
        long writeProgress;
        if (this.timeoutMillis - (System.currentTimeMillis() - this.lastWriteMillis) > 0L) {
            return;
        }
        ChannelOutboundBuffer buffer = ctx.channel().unsafe().outboundBuffer();
        if (buffer != null && (writeProgress = buffer.currentProgress()) != this.lastWriteProgress) {
            this.lastWriteProgress = writeProgress;
            return;
        }
        ctx.fireExceptionCaught((Throwable)new TimeoutException(String.format(WRITE_TIMED_OUT_MESSAGE, this.timeoutMillis)));
    }
}

